/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.data;

import com.phoenixnap.oss.ramlapisync.data.ApiBodyMetadata;
import com.phoenixnap.oss.ramlapisync.data.ApiMappingMetadata;
import com.phoenixnap.oss.ramlapisync.naming.NamingHelper;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.raml.model.Action;
import org.raml.model.ActionType;
import org.raml.model.Raml;
import org.raml.model.Resource;

public class ApiControllerMetadata {
    public static final String CONTROLLER_SUFFIX = "Controller";
    private String controllerUrl;
    private transient Resource resource;
    private String basePackage;
    private Raml document;
    Set<ApiMappingMetadata> apiCalls = new LinkedHashSet<ApiMappingMetadata>();

    public ApiControllerMetadata(String controllerUrl, Resource resource, String basePackage, Raml document) {
        this.controllerUrl = controllerUrl;
        this.resource = resource;
        this.basePackage = basePackage;
        this.document = document;
    }

    public void addApiCall(Resource resource, ActionType actionType, Action action) {
        this.apiCalls.add(new ApiMappingMetadata(this, resource, actionType, action));
    }

    public void addApiCall(Resource resource, ActionType actionType, Action action, String responseContentType) {
        this.apiCalls.add(new ApiMappingMetadata(this, resource, actionType, action, responseContentType));
    }

    public Set<ApiMappingMetadata> getApiCalls() {
        return Collections.unmodifiableSet(this.apiCalls);
    }

    public String getName() {
        String name = NamingHelper.getResourceName(this.resource);
        if (name != null) {
            return name + CONTROLLER_SUFFIX;
        }
        return CONTROLLER_SUFFIX;
    }

    public Resource getResource() {
        return this.resource;
    }

    public String getResourceUri() {
        return this.resource.getUri();
    }

    public String getControllerUrl() {
        return this.controllerUrl;
    }

    public String toString() {
        return "Controller " + this.getName() + "[" + this.getControllerUrl() + "]";
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public Set<ApiBodyMetadata> getDependencies() {
        LinkedHashSet<ApiBodyMetadata> dependencies = new LinkedHashSet<ApiBodyMetadata>();
        for (ApiMappingMetadata method : this.apiCalls) {
            if (method.getRequestBody() != null) {
                dependencies.add(method.getRequestBody());
            }
            dependencies.addAll(method.getResponseBody().values());
        }
        return dependencies;
    }

    public String getDescription() {
        return this.resource.getDescription();
    }

    public Raml getDocument() {
        return this.document;
    }
}

