/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.data;

import com.google.common.reflect.ClassPath;
import org.springframework.util.StringUtils;

public class ApiDocumentMetadata {
    private String title;
    private String path;
    private ClassPath.ResourceInfo document;

    public ApiDocumentMetadata(ClassPath.ResourceInfo document, String docSuffix) {
        String name;
        this.document = document;
        String title = name = document.getResourceName();
        if (name.contains("/") && !name.endsWith("/")) {
            name = name.substring(name.lastIndexOf("/") + 1);
            title = StringUtils.capitalize((String)name).replace(docSuffix, "");
        }
        this.path = name;
        this.title = title;
    }

    public String getDocumentPath() {
        return this.path;
    }

    public String getDocumentTitle() {
        return this.title;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.document == null ? 0 : this.document.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApiDocumentMetadata other = (ApiDocumentMetadata)obj;
        if (this.document == null ? other.document != null : !this.document.equals((Object)other.document)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        return !(this.title == null ? other.title != null : !this.title.equals(other.title));
    }
}

