/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.data;

import com.phoenixnap.oss.ramlapisync.data.ApiBodyMetadata;
import com.phoenixnap.oss.ramlapisync.data.ApiControllerMetadata;
import com.phoenixnap.oss.ramlapisync.data.ApiParameterMetadata;
import com.phoenixnap.oss.ramlapisync.naming.NamingHelper;
import com.phoenixnap.oss.ramlapisync.naming.SchemaHelper;
import com.phoenixnap.oss.ramlapisync.parser.ResourceParser;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.raml.model.Action;
import org.raml.model.ActionType;
import org.raml.model.MimeType;
import org.raml.model.Resource;
import org.raml.model.Response;
import org.raml.model.parameter.AbstractParam;
import org.raml.model.parameter.FormParameter;
import org.springframework.util.StringUtils;

public class ApiMappingMetadata {
    ApiControllerMetadata parent;
    Resource resource;
    ActionType actionType;
    Action action;
    ApiBodyMetadata requestBody = null;
    Map<String, ApiBodyMetadata> responseBody = new LinkedHashMap<String, ApiBodyMetadata>();
    Set<ApiParameterMetadata> pathVariables = null;
    Set<ApiParameterMetadata> requestParameters = null;
    private String responseContentTypeFilter;

    public ApiMappingMetadata(ApiControllerMetadata parent, Resource resource, ActionType actionType, Action action, String responseContentTypeFilter) {
        this.parent = parent;
        this.resource = resource;
        this.actionType = actionType;
        this.action = action;
        this.responseContentTypeFilter = responseContentTypeFilter;
        this.parseRequest();
        this.parseResponse(responseContentTypeFilter);
    }

    public ApiMappingMetadata(ApiControllerMetadata parent, Resource resource, ActionType actionType, Action action) {
        this(parent, resource, actionType, action, null);
    }

    public String toString() {
        return "Method " + this.getName() + "  Verb [" + this.actionType + "] Url [" + this.getUrl() + "] \nConsumes [" + this.getConsumes() + "] Produces [" + this.getProduces() + "] with Schema [" + null + "] \nPath Vars [" + StringUtils.collectionToCommaDelimitedString(this.getPathVariables()) + "] \nRequest Params [" + StringUtils.collectionToCommaDelimitedString(this.getRequestParameters()) + "] \n";
    }

    public Set<ApiParameterMetadata> getPathVariables() {
        if (this.pathVariables != null) {
            return this.pathVariables;
        }
        this.pathVariables = new LinkedHashSet<ApiParameterMetadata>();
        Resource targetResource = this.action.getResource();
        do {
            for (Map.Entry param : targetResource.getUriParameters().entrySet()) {
                this.pathVariables.add(new ApiParameterMetadata((String)param.getKey(), (AbstractParam)param.getValue()));
            }
        } while ((targetResource = targetResource.getParentResource()) != null);
        return this.pathVariables;
    }

    public Set<ApiParameterMetadata> getRequestParameters() {
        if (this.requestParameters == null) {
            return Collections.emptySet();
        }
        return this.requestParameters;
    }

    private void parseRequest() {
        this.requestParameters = this.action.getQueryParameters().entrySet().stream().map(param -> new ApiParameterMetadata((String)param.getKey(), (AbstractParam)param.getValue())).collect(Collectors.toCollection(LinkedHashSet::new));
        if (this.action.getBody() != null && !this.action.getBody().isEmpty()) {
            this.action.getBody().entrySet().forEach(this::collectBodyParams);
        }
    }

    private void collectBodyParams(Map.Entry<String, MimeType> mime) {
        ApiBodyMetadata requestBody;
        String schema;
        if (mime.getKey().equals("multipart/form-data") && ResourceParser.doesActionTypeSupportMultipartMime(this.actionType)) {
            this.collectRequestParamsForMime((MimeType)this.action.getBody().get("multipart/form-data"));
        } else if (mime.getKey().equals("application/x-www-form-urlencoded") && ResourceParser.doesActionTypeSupportMultipartMime(this.actionType)) {
            this.collectRequestParamsForMime((MimeType)this.action.getBody().get("application/x-www-form-urlencoded"));
        }
        if (ResourceParser.doesActionTypeSupportRequestBody(this.actionType) && mime.getKey().toLowerCase().contains("json") && StringUtils.hasText((String)(schema = mime.getValue().getSchema())) && (requestBody = SchemaHelper.mapSchemaToPojo(this.parent.getDocument(), schema, this.parent.getBasePackage() + NamingHelper.getDefaultModelPackage(), StringUtils.capitalize((String)this.getName()) + "Request")) != null) {
            this.setRequestBody(requestBody);
        }
    }

    private void collectRequestParamsForMime(MimeType requestBody) {
        if (requestBody == null) {
            return;
        }
        for (Map.Entry params : requestBody.getFormParameters().entrySet()) {
            for (FormParameter param : (List)params.getValue()) {
                this.requestParameters.add(new ApiParameterMetadata((String)params.getKey(), (AbstractParam)param));
            }
        }
    }

    private void parseResponse(String responseContentTypeFilter) {
        Response response = ResourceParser.getSuccessfulResponse(this.action);
        if (response != null && response.getBody() != null && !response.getBody().isEmpty()) {
            for (Map.Entry body : response.getBody().entrySet()) {
                ApiBodyMetadata responseBody;
                String schema;
                if (responseContentTypeFilter != null && !((String)body.getKey()).equals(responseContentTypeFilter) || !((String)body.getKey()).toLowerCase().contains("json") || !StringUtils.hasText((String)(schema = ((MimeType)body.getValue()).getSchema())) || (responseBody = SchemaHelper.mapSchemaToPojo(this.parent.getDocument(), schema, this.parent.getBasePackage() + NamingHelper.getDefaultModelPackage(), StringUtils.capitalize((String)this.getName()) + "Response")) == null) continue;
                this.responseBody.put((String)body.getKey(), responseBody);
            }
        }
    }

    public String getUrl() {
        return this.resource.getUri().replace(this.parent.getResourceUri(), "");
    }

    public String getName() {
        String name = NamingHelper.getActionName(this.parent.getResource(), this.resource, this.action, this.actionType);
        if (this.responseContentTypeFilter != null) {
            name = name + NamingHelper.convertContentTypeToQualifier(this.responseContentTypeFilter);
        }
        return name;
    }

    public String getProduces() {
        if (this.responseBody != null && !this.responseBody.isEmpty()) {
            String out = "";
            boolean first = true;
            for (String key : this.responseBody.keySet()) {
                if (first) {
                    first = false;
                } else {
                    out = out + ",";
                }
                out = out + key;
            }
            return out;
        }
        return null;
    }

    public String getConsumes() {
        if (this.action.hasBody()) {
            String out = null;
            boolean first = true;
            for (String key : this.action.getBody().keySet()) {
                if ("application/x-www-form-urlencoded".equals(key)) continue;
                if (first) {
                    first = false;
                    out = "";
                } else {
                    out = out + ",";
                }
                out = out + key;
            }
            return out;
        }
        return null;
    }

    public String getDescription() {
        return this.action.getDescription();
    }

    public ApiControllerMetadata getParent() {
        return this.parent;
    }

    public void setParent(ApiControllerMetadata parent) {
        this.parent = parent;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public void setActionType(ActionType actionType) {
        this.actionType = actionType;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public ApiBodyMetadata getRequestBody() {
        return this.requestBody;
    }

    private void setRequestBody(ApiBodyMetadata requestBody) {
        if (this.requestBody != null) {
            throw new IllegalStateException("Body Metadata is immutable");
        }
        this.requestBody = requestBody;
    }

    public void setPathVariables(Set<ApiParameterMetadata> pathVariables) {
        this.pathVariables = pathVariables;
    }

    public void setRequestParameters(Set<ApiParameterMetadata> requestParameters) {
        this.requestParameters = requestParameters;
    }

    public Map<String, ApiBodyMetadata> getResponseBody() {
        return this.responseBody;
    }
}

