/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.data;

import com.phoenixnap.oss.ramlapisync.annotations.Example;
import com.phoenixnap.oss.ramlapisync.naming.SchemaHelper;
import com.phoenixnap.oss.ramlapisync.naming.TypeHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import org.apache.commons.lang.NullArgumentException;
import org.raml.model.parameter.AbstractParam;
import org.raml.model.parameter.UriParameter;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public class ApiParameterMetadata {
    private String name;
    private Parameter param;
    private AbstractParam ramlParam;
    private Class<?> type;
    private Class<?> genericType;
    private boolean nullable;
    private boolean resourceId;
    private String example;

    private String resolveParameterName(String preferredOption, Parameter fallback) {
        if (StringUtils.hasText((String)preferredOption)) {
            return preferredOption;
        }
        return fallback != null ? fallback.getName() : null;
    }

    public ApiParameterMetadata(String name, AbstractParam param) {
        if (param == null) {
            throw new NullArgumentException("param");
        }
        if (param instanceof UriParameter) {
            this.resourceId = true;
            this.nullable = false;
        } else {
            this.resourceId = false;
            this.nullable = !param.isRequired();
        }
        this.name = name;
        this.param = null;
        this.type = SchemaHelper.mapSimpleType(param.getType());
        this.genericType = null;
        this.example = StringUtils.hasText((String)param.getExample()) ? param.getExample() : null;
        this.setRamlParam(param);
    }

    public ApiParameterMetadata(Parameter param) {
        Example parameterExample;
        RequestBody requestBody;
        PathVariable pathVariable;
        this.resourceId = false;
        this.nullable = false;
        String annotatedName = null;
        if (param == null) {
            throw new NullArgumentException("param");
        }
        RequestParam requestParam = param.getAnnotation(RequestParam.class);
        if (requestParam != null) {
            annotatedName = requestParam.value();
            boolean bl = this.nullable = !requestParam.required();
        }
        if ((pathVariable = param.getAnnotation(PathVariable.class)) != null) {
            this.resourceId = true;
            annotatedName = pathVariable.value();
        }
        if ((requestBody = param.getAnnotation(RequestBody.class)) != null) {
            this.nullable = !requestBody.required();
        }
        this.name = this.resolveParameterName(annotatedName, param);
        this.param = param;
        if (param != null) {
            this.type = param.getType();
            this.genericType = (Class)TypeHelper.inferGenericType(param.getParameterizedType());
        }
        if ((parameterExample = param.getAnnotation(Example.class)) != null && StringUtils.hasText((String)parameterExample.value())) {
            this.example = parameterExample.value();
        }
    }

    public Class<?> getType() {
        return this.type;
    }

    public Class<?> getGenericType() {
        return this.genericType;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isResourceId() {
        return this.resourceId;
    }

    public String getName() {
        return this.name;
    }

    public String getJavaName() {
        return this.param.getName();
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.param.isAnnotationPresent(annotationClass);
    }

    public String getExample() {
        return this.example;
    }

    public String toString() {
        return "ApiParameterMetadata [name=" + this.name + ", type=" + this.type + "]";
    }

    public AbstractParam getRamlParam() {
        return this.ramlParam;
    }

    private void setRamlParam(AbstractParam ramlParam) {
        this.ramlParam = ramlParam;
    }
}

