/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.generation;

import com.phoenixnap.oss.ramlapisync.generation.exception.InvalidCodeModelException;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Properties;

public abstract class CodeModelHelper {
    public static JClass findFirstClassBySimpleName(JCodeModel codeModel, String simpleClassName) {
        JCodeModel[] jCodeModelArray;
        if (codeModel == null) {
            jCodeModelArray = null;
        } else {
            JCodeModel[] jCodeModelArray2 = new JCodeModel[1];
            jCodeModelArray = jCodeModelArray2;
            jCodeModelArray2[0] = codeModel;
        }
        return CodeModelHelper.findFirstClassBySimpleName(jCodeModelArray, simpleClassName);
    }

    public static JClass findFirstClassBySimpleName(JCodeModel[] codeModels, String simpleClassName) {
        if (codeModels != null && codeModels.length > 0) {
            for (JCodeModel codeModel : codeModels) {
                Iterator packages = codeModel.packages();
                while (packages.hasNext()) {
                    JPackage jPackage = (JPackage)packages.next();
                    Iterator classes = jPackage.classes();
                    while (classes.hasNext()) {
                        JDefinedClass aClass = (JDefinedClass)classes.next();
                        if (!aClass.name().equals(simpleClassName)) continue;
                        return aClass;
                    }
                }
            }
        }
        throw new InvalidCodeModelException("No unique class found for simple class name " + simpleClassName);
    }

    public static JExtMethod ext(JMethod jMethod, JCodeModel jCodeModel) {
        return new JExtMethod(jMethod, jCodeModel);
    }

    public static String getVersion() {
        try {
            Properties prop = new Properties();
            InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("parser.properties");
            prop.load(in);
            in.close();
            return prop.getProperty("parser.version");
        }
        catch (IOException e) {
            return "???";
        }
    }

    public static class JExtMethod {
        private final JMethod jMethod;
        private final JCodeModel owner;

        public JExtMethod(JMethod jMethod, JCodeModel jCodeModel) {
            this.jMethod = jMethod;
            this.owner = jCodeModel;
        }

        public JMethod get() {
            return this.jMethod;
        }

        public JCodeModel owner() {
            return this.owner;
        }
    }
}

