/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.generation;

import com.phoenixnap.oss.ramlapisync.data.ApiDocumentMetadata;
import com.phoenixnap.oss.ramlapisync.parser.ResourceParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.raml.emitter.RamlEmitter;
import org.raml.model.DocumentationItem;
import org.raml.model.Raml;
import org.raml.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RamlGenerator {
    private static final String DEFAULT_RAML_FILENAME = "api.raml";
    private static final String RAML_EXTENSION = ".raml";
    private static final String pathSeparator = System.getProperty("path.separator");
    private static final Pattern INCLUDE_FIXER_PATTERN = Pattern.compile("\"(\\!include [^\"]*)\"");
    protected static final Logger logger = LoggerFactory.getLogger(RamlGenerator.class);
    private Raml raml;
    private ResourceParser scanner;

    public RamlGenerator() {
    }

    public RamlGenerator(ResourceParser scanner) {
        this();
        this.scanner = scanner;
    }

    public RamlGenerator generateRamlForClasses(String title, String version, String baseUri, Class<?>[] classesToGenerate, Set<ApiDocumentMetadata> documents) {
        this.assertResourceParser();
        Raml raml = new Raml();
        raml.setBaseUri(baseUri);
        raml.setVersion(version);
        raml.setTitle(title);
        if (documents != null && documents.size() > 0) {
            raml.setDocumentation(this.generateDocuments(documents));
        }
        logger.info("Generating Raml for " + title + " v" + version + " from " + classesToGenerate.length + " annotated classes");
        Arrays.asList(classesToGenerate).forEach(item -> {
            Resource resource = this.scanner.extractResourceInfo((Class<?>)item);
            if (resource.getRelativeUri().equals("/")) {
                for (Resource cResource : resource.getResources().values()) {
                    this.mergeResources(raml, cResource, true);
                }
            } else {
                this.mergeResources(raml, resource, true);
            }
        });
        this.raml = raml;
        return this;
    }

    private void assertResourceParser() {
        if (this.scanner == null) {
            throw new IllegalStateException("Please make sure to setup a ResourceParser before calling this method.");
        }
    }

    private void mergeResources(Resource existing, Resource resource, boolean addActions) {
        Map existingChildResources = existing.getResources();
        Map newChildResources = resource.getResources();
        for (String newChildKey : newChildResources.keySet()) {
            if (!existingChildResources.containsKey(newChildKey)) {
                existingChildResources.put(newChildKey, newChildResources.get(newChildKey));
                continue;
            }
            this.mergeResources((Resource)existingChildResources.get(newChildKey), (Resource)newChildResources.get(newChildKey), addActions);
        }
        if (addActions) {
            existing.getActions().putAll(resource.getActions());
        }
    }

    private void mergeResources(Raml raml, Resource resource, boolean addActions) {
        Resource existingResource = raml.getResource(resource.getRelativeUri());
        if (existingResource == null) {
            raml.getResources().put(resource.getRelativeUri(), resource);
        } else {
            this.mergeResources(existingResource, resource, addActions);
        }
    }

    protected List<DocumentationItem> generateDocuments(Set<ApiDocumentMetadata> documents) {
        ArrayList<DocumentationItem> documentInfos = new ArrayList<DocumentationItem>();
        for (ApiDocumentMetadata documentInfo : documents) {
            logger.info("Adding document: " + documentInfo.getDocumentTitle());
            DocumentationItem documentItem = new DocumentationItem();
            documentItem.setContent("!include " + documentInfo.getDocumentPath());
            documentItem.setTitle(documentInfo.getDocumentTitle());
            documentInfos.add(documentItem);
        }
        return documentInfos;
    }

    protected String postProcessRaml(String preRaml) {
        Matcher fixIncludes = INCLUDE_FIXER_PATTERN.matcher(preRaml);
        while (fixIncludes.find()) {
            try {
                preRaml = preRaml.replace(fixIncludes.group(0), fixIncludes.group(1));
                logger.info("    RAML Post Processor replacing: [" + fixIncludes.group(0) + "] with [" + fixIncludes.group(1) + "]");
            }
            catch (Exception ex) {
                logger.error("    RAML Post Processor Exception: " + ex.getMessage());
            }
        }
        return preRaml;
    }

    public String outputRamlToString() {
        if (this.raml == null) {
            return "";
        }
        RamlEmitter ramlEmitter = new RamlEmitter();
        return this.postProcessRaml(ramlEmitter.dump(this.raml));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File outputRamlToFile(String path, Boolean createPathIfMissing, Boolean removeOldOutput) throws FileNotFoundException {
        if (this.raml == null) {
            return null;
        }
        FileOutputStream fos = null;
        File file = this.getRamlOutputFile(path);
        try {
            this.prepareDirectories(file, createPathIfMissing, removeOldOutput);
            logger.info("Saving generated raml to " + file.getAbsolutePath());
            fos = new FileOutputStream(file);
            fos.write(this.outputRamlToString().getBytes());
            fos.flush();
        }
        catch (FileNotFoundException e) {
            logger.error("Could not save raml - directory enclosing " + file.getAbsolutePath() + " does not exist", (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return file;
    }

    public File getRamlOutputFile(String path) {
        File file = new File(this.preparePath(path));
        file = this.prepareFile(file);
        return file;
    }

    private String preparePath(String path) {
        if (path.endsWith("/") || path.endsWith(pathSeparator)) {
            path = path + DEFAULT_RAML_FILENAME;
        }
        return path;
    }

    private File prepareFile(File file) {
        if (file.isDirectory()) {
            file = new File(file, DEFAULT_RAML_FILENAME);
        } else if (!file.getName().toLowerCase().endsWith(RAML_EXTENSION)) {
            file = new File(file.getAbsolutePath() + RAML_EXTENSION);
        }
        return file;
    }

    private void prepareDirectories(File file, Boolean createPathIfMissing, Boolean removeOldOutput) {
        File outputDirectory = file.isDirectory() ? file : file.getParentFile();
        if (!outputDirectory.exists() && createPathIfMissing.booleanValue() && !outputDirectory.mkdirs()) {
            logger.info("Failed to create directory: " + outputDirectory);
        }
        if (removeOldOutput.booleanValue()) {
            try {
                FileUtils.cleanDirectory((File)outputDirectory);
            }
            catch (IOException ioe) {
                logger.error("Failed to clean directory: " + outputDirectory, (Throwable)ioe);
            }
        }
    }

    public Raml getRaml() {
        return this.raml;
    }
}

