/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.generation;

import com.phoenixnap.oss.ramlapisync.data.ApiControllerMetadata;
import com.phoenixnap.oss.ramlapisync.parser.ResourceParser;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.raml.model.Action;
import org.raml.model.ActionType;
import org.raml.model.Raml;
import org.raml.model.Resource;
import org.raml.model.Response;
import org.raml.parser.visitor.RamlDocumentBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RamlParser {
    protected static final Logger logger = LoggerFactory.getLogger(RamlParser.class);
    private String basePackage;
    private String startUrl = "";
    protected boolean seperateMethodsByContentType = false;

    public RamlParser(String basePackage) {
        this.basePackage = basePackage;
    }

    public RamlParser(String basePackage, String startUrl) {
        this(basePackage);
        this.startUrl = startUrl;
    }

    public RamlParser(String basePackage, String startUrl, boolean seperateMethodsByContentType) {
        this(basePackage, startUrl);
        this.seperateMethodsByContentType = seperateMethodsByContentType;
    }

    public Set<ApiControllerMetadata> extractControllers(Raml raml) {
        LinkedHashSet<ApiControllerMetadata> controllers = new LinkedHashSet<ApiControllerMetadata>();
        if (raml == null) {
            return controllers;
        }
        for (Map.Entry resource : raml.getResources().entrySet()) {
            controllers.addAll(this.checkResource(this.startUrl, (Resource)resource.getValue(), null, raml));
        }
        return controllers;
    }

    private boolean shouldCreateController(Resource resource) {
        if (resource.getActions() != null && !resource.getActions().isEmpty()) {
            return true;
        }
        if (resource.getResources() != null && !resource.getResources().isEmpty()) {
            for (Resource childResource : resource.getResources().values()) {
                if ((childResource.getUriParameters() == null || childResource.getUriParameters().isEmpty()) && (childResource.getResolvedUriParameters() == null || childResource.getResolvedUriParameters().isEmpty())) continue;
                return true;
            }
        }
        return false;
    }

    public Set<ApiControllerMetadata> checkResource(String baseUrl, Resource resource, ApiControllerMetadata controller, Raml document) {
        LinkedHashSet<ApiControllerMetadata> controllers = new LinkedHashSet<ApiControllerMetadata>();
        String url = baseUrl + resource.getRelativeUri();
        if (controller == null && this.shouldCreateController(resource)) {
            controller = new ApiControllerMetadata(url, resource, this.basePackage, document);
            controllers.add(controller);
        }
        if (resource.getActions() != null && !resource.getActions().isEmpty()) {
            for (Map.Entry childResource : resource.getActions().entrySet()) {
                Response response = null;
                if (((Action)childResource.getValue()).getResponses() != null) {
                    response = ResourceParser.getSuccessfulResponse((Action)childResource.getValue());
                }
                if (this.seperateMethodsByContentType && response != null && response.hasBody() && response.getBody().size() > 1) {
                    for (String responseType : response.getBody().keySet()) {
                        controller.addApiCall(resource, (ActionType)childResource.getKey(), (Action)childResource.getValue(), responseType);
                    }
                    continue;
                }
                controller.addApiCall(resource, (ActionType)childResource.getKey(), (Action)childResource.getValue());
            }
        }
        if (resource.getResources() != null && !resource.getResources().isEmpty()) {
            for (Map.Entry childResource : resource.getResources().entrySet()) {
                controllers.addAll(this.checkResource(url, (Resource)childResource.getValue(), controller, document));
            }
        }
        return controllers;
    }

    public static Raml loadRamlFromFile(String ramlFileUrl) {
        try {
            return (Raml)new RamlDocumentBuilder().build(ramlFileUrl);
        }
        catch (NullPointerException npe) {
            logger.error("File not found at " + ramlFileUrl);
            return null;
        }
    }
}

