/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.generation.rules;

import com.phoenixnap.oss.ramlapisync.data.ApiControllerMetadata;
import com.phoenixnap.oss.ramlapisync.data.ApiMappingMetadata;
import com.phoenixnap.oss.ramlapisync.generation.rules.Rule;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class GenericJavaClassRule
implements Rule<JCodeModel, JDefinedClass, ApiControllerMetadata> {
    private Rule<JCodeModel, JPackage, ApiControllerMetadata> packageRule;
    private Optional<Rule<JDefinedClass, JDocComment, ApiControllerMetadata>> classCommentRule = Optional.empty();
    private List<Rule<JDefinedClass, JAnnotationUse, ApiControllerMetadata>> classAnnotationRules = new ArrayList<Rule<JDefinedClass, JAnnotationUse, ApiControllerMetadata>>();
    private Rule<JPackage, JDefinedClass, ApiControllerMetadata> classRule;
    private Optional<Rule<JDefinedClass, JDefinedClass, ApiControllerMetadata>> implementsExtendsRule = Optional.empty();
    private List<Rule<JDefinedClass, JFieldVar, ApiControllerMetadata>> fieldDeclerationRules = new ArrayList<Rule<JDefinedClass, JFieldVar, ApiControllerMetadata>>();
    private Optional<Rule<JMethod, JDocComment, ApiMappingMetadata>> methodCommentRule = Optional.empty();
    private List<Rule<JMethod, JAnnotationUse, ApiMappingMetadata>> methodAnnotationRules = new ArrayList<Rule<JMethod, JAnnotationUse, ApiMappingMetadata>>();
    private Rule<JDefinedClass, JMethod, ApiMappingMetadata> methodSignatureRule;
    private Optional<Rule<JMethod, JMethod, ApiMappingMetadata>> methodBodyRule = Optional.empty();

    @Override
    public JDefinedClass apply(ApiControllerMetadata metadata, JCodeModel codeModel) {
        if (this.packageRule == null || this.classRule == null) {
            throw new IllegalStateException("A packageRule and classRule are mandatory.");
        }
        if (!metadata.getApiCalls().isEmpty() && this.methodSignatureRule == null) {
            throw new IllegalStateException("Since there are API Calls in the metadata at least a methodSignatureRule is mandatory");
        }
        JPackage jPackage = this.packageRule.apply(metadata, codeModel);
        JDefinedClass jClass = this.classRule.apply(metadata, jPackage);
        this.implementsExtendsRule.ifPresent(rule -> {
            JDefinedClass cfr_ignored_0 = (JDefinedClass)rule.apply(metadata, jClass);
        });
        this.classCommentRule.ifPresent(rule -> {
            JDocComment cfr_ignored_0 = (JDocComment)rule.apply(metadata, jClass);
        });
        this.classAnnotationRules.forEach(rule -> {
            JAnnotationUse cfr_ignored_0 = (JAnnotationUse)rule.apply(metadata, jClass);
        });
        this.fieldDeclerationRules.forEach(rule -> {
            JFieldVar cfr_ignored_0 = (JFieldVar)rule.apply(metadata, jClass);
        });
        metadata.getApiCalls().forEach(apiMappingMetadata -> {
            JMethod jMethod = this.methodSignatureRule.apply((ApiMappingMetadata)apiMappingMetadata, jClass);
            this.methodCommentRule.ifPresent(rule -> {
                JDocComment cfr_ignored_0 = (JDocComment)rule.apply(apiMappingMetadata, jMethod);
            });
            this.methodAnnotationRules.forEach(rule -> {
                JAnnotationUse cfr_ignored_0 = (JAnnotationUse)rule.apply(apiMappingMetadata, jMethod);
            });
            this.methodBodyRule.ifPresent(rule -> {
                JMethod cfr_ignored_0 = (JMethod)rule.apply(apiMappingMetadata, jMethod);
            });
        });
        return jClass;
    }

    public GenericJavaClassRule setPackageRule(Rule<JCodeModel, JPackage, ApiControllerMetadata> packageRule) {
        this.packageRule = packageRule;
        return this;
    }

    public GenericJavaClassRule addClassAnnotationRule(Rule<JDefinedClass, JAnnotationUse, ApiControllerMetadata> annotationRule) {
        if (annotationRule != null) {
            this.classAnnotationRules.add(annotationRule);
        }
        return this;
    }

    public GenericJavaClassRule setClassCommentRule(Rule<JDefinedClass, JDocComment, ApiControllerMetadata> classCommentRule) {
        this.classCommentRule = Optional.ofNullable(classCommentRule);
        return this;
    }

    public GenericJavaClassRule setClassRule(Rule<JPackage, JDefinedClass, ApiControllerMetadata> classRule) {
        this.classRule = classRule;
        return this;
    }

    public GenericJavaClassRule setMethodSignatureRule(Rule<JDefinedClass, JMethod, ApiMappingMetadata> methodSignatureRule) {
        this.methodSignatureRule = methodSignatureRule;
        return this;
    }

    public GenericJavaClassRule setMethodBodyRule(Rule<JMethod, JMethod, ApiMappingMetadata> metodBodyRule) {
        this.methodBodyRule = Optional.ofNullable(metodBodyRule);
        return this;
    }

    public GenericJavaClassRule addFieldDeclarationRule(Rule<JDefinedClass, JFieldVar, ApiControllerMetadata> fieldDeclerationRule) {
        this.fieldDeclerationRules.add(fieldDeclerationRule);
        return this;
    }

    public GenericJavaClassRule setImplementsExtendsRule(Rule<JDefinedClass, JDefinedClass, ApiControllerMetadata> implementsExtendsRule) {
        this.implementsExtendsRule = Optional.ofNullable(implementsExtendsRule);
        return this;
    }

    public GenericJavaClassRule addMethodAnnotationRule(Rule<JMethod, JAnnotationUse, ApiMappingMetadata> methodAnnotationRule) {
        if (methodAnnotationRule != null) {
            this.methodAnnotationRules.add(methodAnnotationRule);
        }
        return this;
    }

    public GenericJavaClassRule setMethodCommentRule(Rule<JMethod, JDocComment, ApiMappingMetadata> methodCommentRule) {
        this.methodCommentRule = Optional.ofNullable(methodCommentRule);
        return this;
    }
}

