/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.generation.rules.spring;

import com.phoenixnap.oss.ramlapisync.data.ApiControllerMetadata;
import com.phoenixnap.oss.ramlapisync.generation.exception.InvalidCodeModelException;
import com.phoenixnap.oss.ramlapisync.generation.rules.Rule;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JDefinedClass;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;

public class SpringRequestMappingClassAnnotationRule
implements Rule<JDefinedClass, JAnnotationUse, ApiControllerMetadata> {
    @Override
    public JAnnotationUse apply(ApiControllerMetadata controllerMetadata, JDefinedClass generatableType) {
        JAnnotationUse requestMapping = generatableType.annotate(RequestMapping.class);
        requestMapping.param("value", controllerMetadata.getControllerUrl());
        try {
            String mediaType = this.generateMediaType(controllerMetadata);
            if (mediaType != null) {
                requestMapping.param("produces", mediaType);
            }
        }
        catch (Exception e) {
            throw new InvalidCodeModelException("Your model contains an invalid media type", e);
        }
        return requestMapping;
    }

    private String generateMediaType(ApiControllerMetadata controllerMetadata) {
        String ramlMediaType = controllerMetadata.getDocument().getMediaType();
        return MediaType.parseMediaType((String)ramlMediaType).toString();
    }
}

