/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.javadoc;

import com.phoenixnap.oss.ramlapisync.naming.NamingHelper;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class JavaDocEntry {
    private static final Logger logger = LoggerFactory.getLogger(JavaDocEntry.class);
    private static final Pattern COMMENT_BLOCK = Pattern.compile("([^@]+)@(return|param|throws|exception|since|version|author)", 2);
    private static final Pattern PARAM_BLOCK = Pattern.compile("(?m)^[\\s|\\*]*@param([^@]+)(\n|\\Z)", 10);
    private static final Pattern LINK_BLOCK = Pattern.compile("\\{[\\s]*@[a-zA-Z]+[\\s]*([^@]+)\\}", 10);
    private static final Pattern RETURN_BLOCK = Pattern.compile("(?m)^[\\s|\\*]*@return([^@]+)\n", 10);
    private String comment;
    private Map<String, String> parameterComments = new LinkedHashMap<String, String>();
    private String returnTypeComment;
    private Map<Integer, String> errorComments = new LinkedHashMap<Integer, String>();

    public JavaDocEntry(String rawJavaDoc) {
        rawJavaDoc = this.cleanLinks(rawJavaDoc);
        this.buildMainComment(rawJavaDoc);
        this.buildParameterComments(rawJavaDoc);
        this.buildReturnComments(rawJavaDoc);
    }

    private void buildReturnComments(String rawJavaDoc) {
        Matcher returnMatcher = RETURN_BLOCK.matcher(rawJavaDoc);
        if (returnMatcher.find()) {
            try {
                String rawParam = returnMatcher.group(1);
                this.returnTypeComment = NamingHelper.cleanLeadingAndTrailingNewLineAndChars(rawParam);
            }
            catch (Exception ex) {
                logger.warn("****WARNING: Error processing javadoc return type for: " + rawJavaDoc, (Throwable)ex);
            }
        }
    }

    private void buildParameterComments(String rawJavaDoc) {
        Matcher paramMatcher = PARAM_BLOCK.matcher(rawJavaDoc);
        while (paramMatcher.find()) {
            try {
                String rawParam = paramMatcher.group(1);
                if ((rawParam = NamingHelper.cleanLeadingAndTrailingNewLineAndChars(rawParam)) == null || !rawParam.contains(" ")) continue;
                String key = NamingHelper.cleanLeadingAndTrailingNewLineAndChars(rawParam.substring(0, rawParam.indexOf(" ")));
                String value = NamingHelper.cleanLeadingAndTrailingNewLineAndChars(rawParam.substring(rawParam.indexOf(" ")));
                if (!StringUtils.hasText((String)key)) continue;
                this.parameterComments.put(key, value);
            }
            catch (Exception ex) {
                logger.warn("Error processing javadoc parameters for: " + rawJavaDoc, (Throwable)ex);
            }
        }
    }

    private void buildMainComment(String rawJavaDoc) {
        Matcher commentMatcher = COMMENT_BLOCK.matcher(rawJavaDoc);
        commentMatcher.find();
        try {
            this.comment = commentMatcher.group(1);
        }
        catch (Exception ex) {
            this.comment = rawJavaDoc;
        }
        this.comment = NamingHelper.cleanLeadingAndTrailingNewLineAndChars(this.comment).replaceAll("\\n *\\* *", "\n ");
    }

    public String getComment() {
        return this.comment;
    }

    public Map<String, String> getParameterComments() {
        return this.parameterComments;
    }

    public String getReturnTypeComment() {
        return this.returnTypeComment;
    }

    public Map<Integer, String> getErrorComments() {
        return this.errorComments;
    }

    public String toString() {
        String out = "Comment: || " + this.comment + " || Params: ";
        for (Map.Entry<String, String> entry : this.parameterComments.entrySet()) {
            out = out + entry.getKey() + " : " + entry.getValue() + ", ";
        }
        out = out + "|| Return Comment: || " + this.returnTypeComment + " || Errors: ||";
        for (Map.Entry<Object, String> entry : this.errorComments.entrySet()) {
            out = out + entry.getKey() + " : " + entry.getValue() + ", ";
        }
        return out + " ||";
    }

    private int getStringScore(String comment) {
        if (!StringUtils.hasText((String)comment)) {
            return 0;
        }
        String modifiedString = comment.toLowerCase();
        modifiedString = modifiedString.replaceAll("@see(\\n| |\\t)+[a-z|0-9|.]*(\\#[a-z|0-9|.]*){0,1}(\\([a-z|0-9|.]*\\)){0,1}", "");
        modifiedString = modifiedString.replaceAll("[^\\w]{0,3}non[^\\w]javadoc[^\\w]{0,3}", "");
        modifiedString = modifiedString.replaceAll("[^\\w]{0,3}inheritdoc[^\\w]{0,3}", "");
        modifiedString = " " + modifiedString;
        boolean loop = false;
        do {
            String tempString;
            if (!(tempString = modifiedString.replaceAll("[\\s](all|helper|common|functionality|to|useful|toolkit|parent|super)[\\s]", " ")).equals(modifiedString)) {
                loop = true;
                modifiedString = tempString;
                continue;
            }
            loop = false;
        } while (loop);
        modifiedString = modifiedString.replaceAll("[^\\w]", "");
        return modifiedString.length();
    }

    private boolean shouldReplace(String current, String proposed) {
        return this.getStringScore(current) <= this.getStringScore(proposed);
    }

    private String cleanLinks(String target) {
        Matcher linkMatcher = LINK_BLOCK.matcher(target);
        while (linkMatcher.find()) {
            try {
                target = target.substring(0, linkMatcher.start(0)) + linkMatcher.group(1) + target.substring(linkMatcher.end(1) + 1);
            }
            catch (Exception exception) {}
        }
        return target;
    }

    public void merge(JavaDocEntry entry) {
        if (entry != null) {
            if (this.shouldReplace(this.comment, entry.comment)) {
                this.comment = entry.comment;
            }
            if (this.shouldReplace(this.returnTypeComment, entry.returnTypeComment)) {
                this.returnTypeComment = entry.returnTypeComment;
            }
            for (Map.Entry<String, String> entry2 : entry.parameterComments.entrySet()) {
                if (this.parameterComments.containsKey(entry2.getKey()) && !this.shouldReplace(this.parameterComments.get(entry2.getKey()), entry2.getValue())) continue;
                this.parameterComments.put(entry2.getKey(), entry2.getValue());
            }
            for (Map.Entry<Object, String> entry3 : entry.errorComments.entrySet()) {
                if (this.errorComments.containsKey(entry3.getKey()) && !this.shouldReplace(this.errorComments.get(entry3.getKey()), entry3.getValue())) continue;
                this.errorComments.put((Integer)entry3.getKey(), entry3.getValue());
            }
        }
    }
}

