/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.naming;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import com.fasterxml.jackson.module.jsonSchema.types.ArraySchema;
import com.fasterxml.jackson.module.jsonSchema.types.ObjectSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ValueTypeSchema;
import com.phoenixnap.oss.ramlapisync.data.ApiBodyMetadata;
import com.phoenixnap.oss.ramlapisync.data.ApiParameterMetadata;
import com.phoenixnap.oss.ramlapisync.javadoc.JavaDocEntry;
import com.phoenixnap.oss.ramlapisync.javadoc.JavaDocStore;
import com.phoenixnap.oss.ramlapisync.naming.NamingHelper;
import com.phoenixnap.oss.ramlapisync.naming.TypeHelper;
import com.sun.codemodel.JCodeModel;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.jsonschema2pojo.Annotator;
import org.jsonschema2pojo.DefaultGenerationConfig;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.Jackson2Annotator;
import org.jsonschema2pojo.SchemaGenerator;
import org.jsonschema2pojo.SchemaMapper;
import org.jsonschema2pojo.SchemaStore;
import org.jsonschema2pojo.rules.RuleFactory;
import org.raml.model.ParamType;
import org.raml.model.Raml;
import org.raml.model.parameter.QueryParameter;
import org.raml.parser.utils.Inflector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class SchemaHelper {
    protected static final Logger logger = LoggerFactory.getLogger(SchemaHelper.class);
    private static String JSON_SCHEMA_IDENT = "http://jsonschema.net";

    public static Map<String, QueryParameter> convertParameterToQueryParameter(Parameter param, String paramComment) {
        QueryParameter queryParam = new QueryParameter();
        ApiParameterMetadata parameterMetadata = new ApiParameterMetadata(param);
        ParamType type = SchemaHelper.mapSimpleType(param.getType());
        if (type == null) {
            throw new IllegalArgumentException("This method is only applicable to simple types or primitives");
        }
        if (StringUtils.hasText((String)paramComment)) {
            queryParam.setDescription(paramComment);
        }
        queryParam.setDisplayName(parameterMetadata.getName());
        queryParam.setType(SchemaHelper.mapSimpleType(param.getType()));
        if (StringUtils.hasText((String)parameterMetadata.getExample())) {
            queryParam.setExample(parameterMetadata.getExample());
        }
        queryParam.setRequired(!parameterMetadata.isNullable());
        queryParam.setRepeat(param.getType().isArray());
        return Collections.singletonMap(parameterMetadata.getName(), queryParam);
    }

    public static String resolveSchema(String schema, Raml document) {
        if (document == null || schema == null || schema.indexOf("{") != -1) {
            return null;
        }
        if (document.getSchemas() != null && !document.getSchemas().isEmpty()) {
            for (Map map : document.getSchemas()) {
                if (!map.containsKey(schema)) continue;
                return (String)map.get(schema);
            }
        }
        return null;
    }

    public static Map<String, QueryParameter> convertClassToQueryParameters(Parameter param, JavaDocStore javaDocStore) {
        TreeMap<String, QueryParameter> outParams = new TreeMap<String, QueryParameter>();
        if (param == null || param.equals(Void.class)) {
            return outParams;
        }
        ApiParameterMetadata parameterMetadata = new ApiParameterMetadata(param);
        if (SchemaHelper.mapSimpleType(param.getType()) != null) {
            throw new IllegalArgumentException("This method should only be called on non primitive classes which will be broken down into query parameters");
        }
        try {
            for (Field field : param.getType().getDeclaredFields()) {
                JavaDocEntry paramComment;
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || Modifier.isVolatile(field.getModifiers())) continue;
                QueryParameter queryParam = new QueryParameter();
                JavaDocEntry javaDocEntry = paramComment = javaDocStore == null ? null : javaDocStore.getJavaDoc(field.getName());
                if (paramComment != null && StringUtils.hasText((String)paramComment.getComment())) {
                    queryParam.setDescription(paramComment.getComment());
                }
                queryParam.setDisplayName(field.getName());
                ParamType simpleType = SchemaHelper.mapSimpleType(field.getType());
                queryParam.setType(simpleType == null ? ParamType.STRING : simpleType);
                queryParam.setRequired(parameterMetadata.isNullable());
                queryParam.setRepeat(false);
                outParams.put(field.getName(), queryParam);
            }
            return outParams;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static String convertClassToJsonSchema(ApiParameterMetadata clazz, String responseDescription, JavaDocStore javaDocStore) {
        if (clazz == null || clazz.equals(Void.class)) {
            return "{}";
        }
        try {
            ObjectMapper m = new ObjectMapper();
            JsonSchema jsonSchema = SchemaHelper.extractSchemaInternal(clazz.getType(), clazz.getGenericType(), responseDescription, javaDocStore, m);
            return m.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonSchema);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static String convertClassToJsonSchema(Type clazz, String responseDescription, JavaDocStore javaDocStore) {
        if (clazz == null || clazz.equals(Void.class)) {
            return "{}";
        }
        try {
            ObjectMapper m = new ObjectMapper();
            JsonSchema jsonSchema = SchemaHelper.extractSchemaInternal(clazz, TypeHelper.inferGenericType(clazz), responseDescription, javaDocStore, m);
            return m.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonSchema);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static JsonSchema extractSchemaInternal(Type clazz, Type genericType, String responseDescription, JavaDocStore javaDocStore, ObjectMapper m) throws JsonMappingException {
        SchemaFactoryWrapper visitor = new SchemaFactoryWrapper();
        if (genericType != null) {
            try {
                m.acceptJsonFormatVisitor(m.constructType(genericType), (JsonFormatVisitorWrapper)visitor);
            }
            catch (Exception ex) {
                logger.error("Unable to add JSON visitor for " + genericType.toString());
            }
        }
        try {
            m.acceptJsonFormatVisitor(m.constructType(clazz), (JsonFormatVisitorWrapper)visitor);
        }
        catch (Exception ex) {
            logger.error("Unable to add JSON visitor for " + clazz.toString());
        }
        JsonSchema jsonSchema = visitor.finalSchema();
        if (jsonSchema instanceof ObjectSchema && javaDocStore != null) {
            ObjectSchema objectSchema = (ObjectSchema)jsonSchema;
            if (objectSchema.getProperties() != null) {
                for (Map.Entry cSchema : objectSchema.getProperties().entrySet()) {
                    JavaDocEntry javaDocEntry = javaDocStore.getJavaDoc((String)cSchema.getKey());
                    if (javaDocEntry == null || !StringUtils.hasText((String)javaDocEntry.getComment())) continue;
                    ((JsonSchema)cSchema.getValue()).setDescription(javaDocEntry.getComment());
                }
            }
        } else if (jsonSchema instanceof ValueTypeSchema && StringUtils.hasText((String)responseDescription)) {
            ValueTypeSchema valueTypeSchema = (ValueTypeSchema)jsonSchema;
            valueTypeSchema.setDescription(responseDescription);
        } else if (jsonSchema instanceof ArraySchema && genericType != null) {
            ArraySchema arraySchema = (ArraySchema)jsonSchema;
            arraySchema.setItemsSchema(SchemaHelper.extractSchemaInternal(genericType, TypeHelper.inferGenericType(genericType), responseDescription, javaDocStore, m));
        }
        return jsonSchema;
    }

    public static ParamType mapSimpleType(Class<?> clazz) {
        Class<?> targetClazz = clazz;
        if (targetClazz.isArray() && clazz.getComponentType() != null) {
            targetClazz = clazz.getComponentType();
        }
        if (targetClazz.equals(Long.TYPE) || targetClazz.equals(Long.class) || targetClazz.equals(Integer.TYPE) || targetClazz.equals(Integer.class) || targetClazz.equals(Short.TYPE) || targetClazz.equals(Short.class) || targetClazz.equals(Byte.TYPE) || targetClazz.equals(Byte.class)) {
            return ParamType.INTEGER;
        }
        if (targetClazz.equals(Float.TYPE) || targetClazz.equals(Float.class) || targetClazz.equals(Double.TYPE) || targetClazz.equals(Double.class) || targetClazz.equals(BigDecimal.class)) {
            return ParamType.NUMBER;
        }
        if (targetClazz.equals(Boolean.class) || targetClazz.equals(Boolean.TYPE)) {
            return ParamType.BOOLEAN;
        }
        if (targetClazz.equals(String.class)) {
            return ParamType.STRING;
        }
        return null;
    }

    public static Class<?> mapSimpleType(ParamType param) {
        switch (param) {
            case BOOLEAN: {
                return Boolean.class;
            }
            case DATE: {
                return Date.class;
            }
            case INTEGER: {
                return Long.class;
            }
            case NUMBER: {
                return BigDecimal.class;
            }
            case FILE: {
                return MultipartFile.class;
            }
        }
        return String.class;
    }

    public static ApiBodyMetadata mapSchemaToPojo(Raml document, String schema, String basePackage, String name) {
        JCodeModel codeModel;
        String resolvedName = null;
        String schemaName = schema;
        String resolvedSchema = SchemaHelper.resolveSchema(schema, document);
        if (resolvedSchema == null) {
            resolvedSchema = schema;
            schemaName = null;
        }
        if (resolvedSchema.contains("\"id\"")) {
            int endIdx;
            int idIdx = resolvedSchema.indexOf("\"id\"");
            int startIdx = resolvedSchema.indexOf("\"", idIdx + 4);
            String id = resolvedSchema.substring(startIdx + 1, endIdx = resolvedSchema.indexOf("\"", startIdx + 1));
            if (id.startsWith("urn:") && id.lastIndexOf(":") + 1 < id.length()) {
                id = id.substring(id.lastIndexOf(":") + 1);
            } else if (id.startsWith(JSON_SCHEMA_IDENT)) {
                if (id.length() > JSON_SCHEMA_IDENT.length() + 3) {
                    id = id.substring(JSON_SCHEMA_IDENT.length());
                }
            } else {
                resolvedName = StringUtils.capitalize((String)id);
            }
        }
        if (!NamingHelper.isValidJavaClassName(resolvedName)) {
            resolvedName = NamingHelper.isValidJavaClassName(schemaName) ? Inflector.capitalize((String)schemaName) : name;
        }
        if ((codeModel = SchemaHelper.buildBodyJCodeModel(basePackage, resolvedName, resolvedSchema, null, null)) != null) {
            return new ApiBodyMetadata(resolvedName, resolvedSchema, codeModel);
        }
        return null;
    }

    public static JCodeModel buildBodyJCodeModel(String basePackage, String name, String schema, GenerationConfig config, Annotator annotator) {
        JCodeModel codeModel = new JCodeModel();
        SchemaStore schemaStore = new SchemaStore();
        if (config == null) {
            config = new DefaultGenerationConfig(){

                public boolean isGenerateBuilders() {
                    return true;
                }

                public boolean isIncludeAdditionalProperties() {
                    return false;
                }

                public boolean isIncludeDynamicAccessors() {
                    return false;
                }
            };
        }
        if (annotator == null) {
            annotator = new Jackson2Annotator();
        }
        RuleFactory ruleFactory = new RuleFactory(config, annotator, schemaStore);
        SchemaMapper mapper = new SchemaMapper(ruleFactory, new SchemaGenerator());
        try {
            mapper.generate(codeModel, name, basePackage, schema);
        }
        catch (Exception e) {
            logger.error("Error generating pojo from schema " + name, (Throwable)e);
            return null;
        }
        return codeModel;
    }
}

