/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.parser;

import com.phoenixnap.oss.ramlapisync.data.ApiParameterMetadata;
import com.phoenixnap.oss.ramlapisync.javadoc.JavaDocEntry;
import com.phoenixnap.oss.ramlapisync.javadoc.JavaDocExtractor;
import com.phoenixnap.oss.ramlapisync.javadoc.JavaDocStore;
import com.phoenixnap.oss.ramlapisync.naming.Pair;
import com.phoenixnap.oss.ramlapisync.naming.SchemaHelper;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.raml.model.Action;
import org.raml.model.ActionType;
import org.raml.model.MimeType;
import org.raml.model.ParamType;
import org.raml.model.Resource;
import org.raml.model.Response;
import org.raml.model.parameter.QueryParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class ResourceParser {
    protected static final Logger logger = LoggerFactory.getLogger(ResourceParser.class);
    protected static final Pattern IGNORE_METHOD_REGEX = Pattern.compile("^(equals|hashCode|clone|finalize|getClass|notify|notifyAll|toString|wait)", 2);
    protected static final String CSRF_HEADER = "X-CSRF-TOKEN";
    public static final String CATCH_ALL_MEDIA_TYPE = "application/everything";
    protected JavaDocExtractor javaDocs;
    protected String version;
    protected String defaultMediaType;

    public ResourceParser(File javaDocPath, String version, String defaultMediaType) {
        this.version = version;
        this.defaultMediaType = defaultMediaType;
        this.javaDocs = new JavaDocExtractor(javaDocPath);
    }

    private void getMethodsFromService(Class<?> clazz, JavaDocStore javaDoc, Resource parentResource) {
        try {
            for (Method method : clazz.getMethods()) {
                if (IGNORE_METHOD_REGEX.matcher(method.getName()).matches() || !this.shouldAddMethodToApi(method)) continue;
                this.extractAndAppendResourceInfo(method, javaDoc.getJavaDoc(method), parentResource);
            }
        }
        catch (NoClassDefFoundError nEx) {
            logger.error("Unable to get methods - skipping class " + clazz, (Throwable)nEx);
        }
    }

    public void setJavaDocs(JavaDocExtractor javaDocs) {
        this.javaDocs = javaDocs;
    }

    public static boolean doesActionTypeSupportRequestBody(ActionType target) {
        return target.equals((Object)ActionType.POST) || target.equals((Object)ActionType.PUT);
    }

    public static boolean doesActionTypeSupportMultipartMime(ActionType target) {
        return target.equals((Object)ActionType.POST);
    }

    protected abstract boolean shouldAddMethodToApi(Method var1);

    protected Map<String, QueryParameter> extractQueryParameters(ActionType apiAction, Method method, Map<String, String> parameterComments) {
        if (apiAction.equals((Object)ActionType.POST) || method.getParameterCount() == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, QueryParameter> queryParams = new LinkedHashMap<String, QueryParameter>();
        for (Parameter param : method.getParameters()) {
            if (!this.isQueryParameter(param)) continue;
            ParamType simpleType = SchemaHelper.mapSimpleType(param.getType());
            if (simpleType == null) {
                queryParams.putAll(SchemaHelper.convertClassToQueryParameters(param, this.javaDocs.getJavaDoc(param.getType())));
                continue;
            }
            String paramComment = parameterComments.get(param.getName());
            queryParams.putAll(SchemaHelper.convertParameterToQueryParameter(param, paramComment));
        }
        return queryParams;
    }

    protected abstract boolean isQueryParameter(Parameter var1);

    protected abstract List<ApiParameterMetadata> getApiParameters(Method var1, boolean var2, boolean var3);

    protected Map<String, MimeType> extractRequestBodyFromMethod(ActionType apiAction, Method method, Map<String, String> parameterComments) {
        if (!ResourceParser.doesActionTypeSupportRequestBody(apiAction) || method.getParameterCount() == 0) {
            return Collections.emptyMap();
        }
        String comment = null;
        List<ApiParameterMetadata> apiParameters = this.getApiParameters(method, false, true);
        if (apiParameters.size() == 0) {
            return Collections.emptyMap();
        }
        Pair<String, MimeType> schemaAndMime = this.extractRequestBody(method, parameterComments, comment, apiParameters);
        return Collections.singletonMap(schemaAndMime.getFirst(), schemaAndMime.getSecond());
    }

    protected Pair<String, MimeType> extractRequestBody(Method method, Map<String, String> parameterComments, String comment, List<ApiParameterMetadata> apiParameters) {
        String schema;
        MimeType mimeType = new MimeType();
        if (apiParameters.size() == 1) {
            if (parameterComments != null && parameterComments.size() == 1) {
                comment = parameterComments.values().iterator().next();
            }
            ApiParameterMetadata ajaxParameter = apiParameters.get(0);
            schema = SchemaHelper.convertClassToJsonSchema(ajaxParameter, comment, this.javaDocs.getJavaDoc(ajaxParameter.getType()));
            if (StringUtils.hasText((String)ajaxParameter.getExample())) {
                mimeType.setExample(ajaxParameter.getExample());
            }
        } else {
            schema = "{ \"type\": \"object\", \n \"properties\": {\n";
            boolean first = true;
            for (ApiParameterMetadata param : apiParameters) {
                if (!first) {
                    schema = schema + ",\n";
                } else {
                    first = false;
                }
                schema = schema + "\"" + param.getName() + "\" : ";
                comment = "";
                if (parameterComments != null && StringUtils.hasText((String)comment) && StringUtils.hasText((String)parameterComments.get(param.getJavaName()))) {
                    comment = parameterComments.get(param.getJavaName());
                }
                schema = schema + SchemaHelper.convertClassToJsonSchema(param, comment, this.javaDocs.getJavaDoc(param.getType()));
            }
            schema = schema + "}\n}";
        }
        mimeType.setSchema(schema);
        return new Pair<String, MimeType>(this.extractExpectedMimeTypeFromMethod(method), mimeType);
    }

    protected abstract void addHeadersForMethod(Action var1, ActionType var2, Method var3);

    protected abstract ApiParameterMetadata[] extractResourceIdParameter(Method var1);

    protected abstract Map<ActionType, String> getHttpMethodAndName(Method var1);

    protected abstract void extractAndAppendResourceInfo(Method var1, JavaDocEntry var2, Resource var3);

    protected abstract boolean isActionOnResourceWithoutCommand(Method var1);

    protected String extractMimeTypeFromMethod(Method method) {
        return this.defaultMediaType;
    }

    protected String extractExpectedMimeTypeFromMethod(Method method) {
        return this.defaultMediaType;
    }

    protected Response extractResponseFromMethod(Method method, String responseComment) {
        Response response = new Response();
        String mime = this.extractMimeTypeFromMethod(method);
        MimeType jsonType = new MimeType(mime);
        jsonType.setSchema(SchemaHelper.convertClassToJsonSchema(method.getGenericReturnType(), responseComment, this.javaDocs.getJavaDoc(method.getReturnType())));
        LinkedHashMap<String, MimeType> body = new LinkedHashMap<String, MimeType>();
        body.put(mime, jsonType);
        response.setBody(body);
        if (StringUtils.hasText((String)responseComment)) {
            response.setDescription(responseComment);
        } else {
            response.setDescription("Successful Response");
        }
        return response;
    }

    protected void mergeActions(Action existingAction, Action newAction) {
        Response existingSuccessfulResponse = ResourceParser.getSuccessfulResponse(existingAction);
        Response successfulResponse = ResourceParser.getSuccessfulResponse(newAction);
        if (existingSuccessfulResponse != null && existingSuccessfulResponse.hasBody() && successfulResponse != null && successfulResponse.hasBody()) {
            for (Map.Entry body : successfulResponse.getBody().entrySet()) {
                existingSuccessfulResponse.getBody().putIfAbsent(body.getKey(), body.getValue());
            }
        }
    }

    public static Response getSuccessfulResponse(Action action) {
        String[] successfulResponses;
        for (String code : successfulResponses = new String[]{"200", "201"}) {
            if (action == null || CollectionUtils.isEmpty((Map)action.getResponses()) || !action.getResponses().containsKey(code)) continue;
            return (Response)action.getResponses().get(code);
        }
        return null;
    }

    public Resource extractResourceInfo(Class<?> clazz) {
        logger.info("Parsing resource: " + clazz.getSimpleName() + " ");
        Resource resource = new Resource();
        resource.setRelativeUri("/" + this.getResourceName(clazz));
        resource.setDisplayName(clazz.getSimpleName());
        JavaDocStore javaDoc = this.javaDocs.getJavaDoc(clazz);
        String comment = javaDoc.getJavaDocComment(clazz);
        if (comment != null) {
            resource.setDescription(comment);
        }
        this.getMethodsFromService(clazz, javaDoc, resource);
        return resource;
    }

    protected abstract String getResourceName(Class<?> var1);
}

