/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.parser;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import com.phoenixnap.oss.ramlapisync.annotations.Description;
import com.phoenixnap.oss.ramlapisync.annotations.data.PathDescription;
import com.phoenixnap.oss.ramlapisync.data.ApiParameterMetadata;
import com.phoenixnap.oss.ramlapisync.javadoc.JavaDocEntry;
import com.phoenixnap.oss.ramlapisync.naming.NamingHelper;
import com.phoenixnap.oss.ramlapisync.naming.Pair;
import com.phoenixnap.oss.ramlapisync.naming.SchemaHelper;
import com.phoenixnap.oss.ramlapisync.parser.ResourceParser;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.raml.model.Action;
import org.raml.model.ActionType;
import org.raml.model.MimeType;
import org.raml.model.ParamType;
import org.raml.model.Resource;
import org.raml.model.Response;
import org.raml.model.parameter.FormParameter;
import org.raml.model.parameter.UriParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

public class SpringMvcResourceParser
extends ResourceParser {
    protected static final Logger logger = LoggerFactory.getLogger(SpringMvcResourceParser.class);
    protected boolean restrictOnMediaType;

    public SpringMvcResourceParser(File path, String version, String defaultMediaType, boolean restrictOnMediaType) {
        super(path, version, defaultMediaType);
        this.restrictOnMediaType = restrictOnMediaType;
    }

    @Override
    protected Pair<String, MimeType> extractRequestBody(Method method, Map<String, String> parameterComments, String comment, List<ApiParameterMetadata> apiParameters) {
        MimeType mimeType = new MimeType();
        if (apiParameters != null && apiParameters.size() == 0) {
            return null;
        }
        if (apiParameters != null && apiParameters.size() == 1 && String.class.equals(apiParameters.get(0).getType()) && apiParameters.get(0).isAnnotationPresent(RequestBody.class)) {
            ApiParameterMetadata apiParameterMetadata = apiParameters.get(0);
            String type = "text/plain";
            if (StringUtils.hasText((String)apiParameterMetadata.getExample())) {
                mimeType.setExample(apiParameterMetadata.getExample());
            }
            ObjectMapper m = new ObjectMapper();
            SchemaFactoryWrapper visitor = new SchemaFactoryWrapper();
            try {
                m.acceptJsonFormatVisitor(m.constructType(String.class), (JsonFormatVisitorWrapper)visitor);
                JsonSchema jsonSchema = visitor.finalSchema();
                String description = parameterComments.get(apiParameterMetadata.getJavaName());
                if (description == null) {
                    description = apiParameterMetadata.getName();
                }
                jsonSchema.setDescription(description);
                jsonSchema.setRequired(Boolean.valueOf(!apiParameterMetadata.isNullable()));
                mimeType.setSchema(m.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonSchema));
            }
            catch (JsonProcessingException e) {
                throw new IllegalStateException(e);
            }
            return new Pair<String, MimeType>(type, mimeType);
        }
        if (apiParameters != null && (apiParameters.size() > 1 || !apiParameters.get(0).isAnnotationPresent(RequestBody.class) && String.class.equals(apiParameters.get(0).getType()))) {
            String type = "application/x-www-form-urlencoded";
            for (ApiParameterMetadata param : apiParameters) {
                TreeMap paramMap;
                FormParameter formParameter = new FormParameter();
                formParameter.setDisplayName(param.getName());
                formParameter.setExample(param.getExample());
                ParamType simpleType = SchemaHelper.mapSimpleType(param.getType());
                formParameter.setType(simpleType == null ? ParamType.STRING : simpleType);
                String description = parameterComments.get(param.getJavaName());
                if (description == null) {
                    description = param.getName();
                }
                formParameter.setDescription(description);
                formParameter.setRequired(!param.isNullable());
                if (mimeType.getFormParameters() == null) {
                    paramMap = new TreeMap();
                    mimeType.setFormParameters(paramMap);
                } else {
                    paramMap = mimeType.getFormParameters();
                }
                mimeType.getFormParameters().put(param.getName(), Collections.singletonList(formParameter));
            }
            return new Pair<String, MimeType>(type, mimeType);
        }
        return super.extractRequestBody(method, parameterComments, comment, apiParameters);
    }

    @Override
    protected String extractMimeTypeFromMethod(Method method) {
        RequestMapping requestMapping = this.getRequestMapping(method);
        if (requestMapping != null && requestMapping.produces() != null && requestMapping.produces().length > 0) {
            if (requestMapping.produces().length > 1) {
                logger.warn("Method " + method.getName() + " is annotated with multiple Produces entries.");
            }
            return requestMapping.produces()[0];
        }
        return super.extractMimeTypeFromMethod(method);
    }

    private RequestMapping getRequestMapping(Method method) {
        RequestMapping requestMapping = method.getAnnotation(RequestMapping.class);
        if (requestMapping == null) {
            for (Class<?> cInterface : method.getDeclaringClass().getInterfaces()) {
                try {
                    Method methodInInterface = cInterface.getMethod(method.getName(), method.getParameterTypes());
                    requestMapping = methodInInterface.getAnnotation(RequestMapping.class);
                    if (requestMapping != null) {
                        return requestMapping;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        return requestMapping;
    }

    private <T extends Annotation> T getAnnotation(Class<?> clazz, Class<T> annotation, boolean inherit) {
        T foundAnnotation = clazz.getAnnotation(annotation);
        if (foundAnnotation == null && inherit) {
            for (Class<?> cInterface : clazz.getInterfaces()) {
                foundAnnotation = cInterface.getAnnotation(annotation);
                if (foundAnnotation == null) continue;
                return foundAnnotation;
            }
        }
        return foundAnnotation;
    }

    @Override
    protected String extractExpectedMimeTypeFromMethod(Method method) {
        RequestMapping requestMapping = this.getRequestMapping(method);
        if (requestMapping != null && requestMapping.consumes() != null && requestMapping.consumes().length > 0) {
            return requestMapping.consumes()[0];
        }
        return super.extractMimeTypeFromMethod(method);
    }

    @Override
    protected boolean shouldAddMethodToApi(Method method) {
        RequestMapping requestMapping = this.getRequestMapping(method);
        if (requestMapping != null) {
            if (this.restrictOnMediaType) {
                for (String cHeader : requestMapping.consumes()) {
                    if (!cHeader.toLowerCase().contains(this.defaultMediaType.toLowerCase())) continue;
                    return true;
                }
                for (String cHeader : requestMapping.produces()) {
                    if (!cHeader.toLowerCase().contains(this.defaultMediaType.toLowerCase())) continue;
                    return true;
                }
                for (String cHeader : requestMapping.headers()) {
                    if (!cHeader.toLowerCase().contains(this.defaultMediaType.toLowerCase()) || !cHeader.toLowerCase().contains("accept")) continue;
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    protected String getParameterName(String preferredOption, String fallback) {
        if (StringUtils.hasText((String)preferredOption)) {
            return preferredOption;
        }
        return fallback;
    }

    protected boolean shouldAddParameter(Parameter param) {
        for (Annotation annotation : param.getAnnotations()) {
            if (!annotation.getClass().equals(RequestParam.class) && !annotation.getClass().equals(RequestBody.class) && !annotation.getClass().equals(PathVariable.class)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected List<ApiParameterMetadata> getApiParameters(Method method, boolean includeUrlParameters, boolean includeNonUrlParameters) {
        ArrayList<ApiParameterMetadata> params = new ArrayList<ApiParameterMetadata>();
        for (Parameter param : method.getParameters()) {
            boolean nonPathParameter = this.isNonPathParameter(param);
            ApiParameterMetadata parameterMetadata = new ApiParameterMetadata(param);
            if (parameterMetadata == null) continue;
            if (nonPathParameter && includeNonUrlParameters) {
                params.add(parameterMetadata);
                continue;
            }
            if (nonPathParameter || !includeUrlParameters) continue;
            params.add(parameterMetadata);
        }
        return params;
    }

    protected boolean isParameter(Parameter param) {
        return this.isPathParameter(param) || this.isNonPathParameter(param);
    }

    protected boolean isPathParameter(Parameter param) {
        return param.isAnnotationPresent(PathVariable.class);
    }

    protected boolean isNonPathParameter(Parameter param) {
        return param.isAnnotationPresent(RequestParam.class) || param.isAnnotationPresent(RequestBody.class);
    }

    @Override
    protected boolean isQueryParameter(Parameter param) {
        return param.isAnnotationPresent(RequestParam.class);
    }

    protected Map<String, String> getPathDescriptionsForMethod(Method method) {
        HashMap<String, String> outDescriptions = new HashMap<String, String>();
        Description description = this.getAnnotation(method.getDeclaringClass(), Description.class, true);
        if (description != null) {
            for (PathDescription descriptions : description.pathDescriptions()) {
                outDescriptions.put(NamingHelper.cleanLeadingAndTrailingNewLineAndChars(descriptions.key()), descriptions.value());
            }
        }
        if (method.isAnnotationPresent(Description.class)) {
            Description methodDescription = method.getAnnotation(Description.class);
            for (PathDescription descriptions : methodDescription.pathDescriptions()) {
                outDescriptions.put(NamingHelper.cleanLeadingAndTrailingNewLineAndChars(descriptions.key()), descriptions.value());
            }
        }
        return outDescriptions;
    }

    @Override
    protected ApiParameterMetadata[] extractResourceIdParameter(Method method) {
        HashMap<String, ApiParameterMetadata> pathVariables = new HashMap<String, ApiParameterMetadata>();
        for (Parameter param : method.getParameters()) {
            if (!this.isPathParameter(param)) continue;
            ApiParameterMetadata extractParameterMetadata = new ApiParameterMetadata(param);
            pathVariables.put(extractParameterMetadata.getName(), extractParameterMetadata);
        }
        return pathVariables.values().toArray(new ApiParameterMetadata[pathVariables.size()]);
    }

    @Override
    protected Map<ActionType, String> getHttpMethodAndName(Method method) {
        RequestMapping methodMapping = this.getRequestMapping(method);
        RequestMapping classMapping = this.getAnnotation(method.getDeclaringClass(), RequestMapping.class, false);
        RestController classRestController = this.getAnnotation(method.getDeclaringClass(), RestController.class, false);
        Controller classController = this.getAnnotation(method.getDeclaringClass(), Controller.class, false);
        RequestMethod[] verbs = methodMapping.method();
        if (verbs == null || verbs.length == 0) {
            verbs = RequestMethod.values();
        }
        String name = "";
        if (classMapping != null && classMapping.value() != null && classMapping.value().length > 0) {
            name = name + NamingHelper.resolveProperties(classMapping.value()[0]);
        }
        if (classRestController != null && classRestController.value() != null) {
            name = name + NamingHelper.resolveProperties(classRestController.value());
        }
        if (classController != null && classController.value() != null) {
            name = name + NamingHelper.resolveProperties(classController.value());
        }
        if (methodMapping.value() != null && methodMapping.value().length > 0) {
            if (name.endsWith("/") && methodMapping.value()[0].startsWith("/")) {
                name = name.substring(0, name.length() - 1);
            } else if (name != "" && !name.endsWith("/") && !methodMapping.value()[0].startsWith("/")) {
                name = name + "/";
            }
            name = name + NamingHelper.resolveProperties(methodMapping.value()[0]);
        }
        HashMap<ActionType, String> outMap = new HashMap<ActionType, String>();
        for (RequestMethod rm : verbs) {
            try {
                ActionType apiAction = ActionType.valueOf((String)rm.name());
                outMap.put(apiAction, name);
            }
            catch (Exception ex) {
                logger.warn("Skipping unknown verb " + rm);
            }
        }
        return outMap;
    }

    @Override
    protected boolean isActionOnResourceWithoutCommand(Method method) {
        if (!method.isAnnotationPresent(RequestMapping.class)) {
            return true;
        }
        RequestMapping requestMapping = this.getRequestMapping(method);
        if (requestMapping.value().length == 0) {
            return true;
        }
        String url = requestMapping.value()[0];
        if (StringUtils.hasText((String)url)) {
            return true;
        }
        logger.debug("Parsing url: [" + url + "]");
        List<ApiParameterMetadata> apiParameters = this.getApiParameters(method, true, false);
        for (ApiParameterMetadata parameterMetadata : apiParameters) {
            url.replace(parameterMetadata.getName(), "");
        }
        return !StringUtils.hasText((String)(url = url.replaceAll("[^\\w]", "")));
    }

    @Override
    protected String getResourceName(Class<?> clazz) {
        RequestMapping mapping = clazz.getAnnotation(RequestMapping.class);
        String outMapping = "";
        if (mapping != null && StringUtils.hasText((String)mapping.name())) {
            outMapping = mapping.name();
        }
        return NamingHelper.resolveProperties(outMapping);
    }

    @Override
    protected void extractAndAppendResourceInfo(Method method, JavaDocEntry docEntry, Resource parentResource) {
        Map<ActionType, String> methodActions = this.getHttpMethodAndName(method);
        for (Map.Entry<ActionType, String> methodAction : methodActions.entrySet()) {
            String[] splitUrl;
            String description;
            Action action = new Action();
            ActionType apiAction = methodAction.getKey();
            String apiName = methodAction.getValue();
            if (apiName != null && !apiName.startsWith("/")) {
                apiName = "/" + apiName;
            }
            Map<String, String> pathDescriptions = this.getPathDescriptionsForMethod(method);
            logger.info("Added call: " + apiName + " " + apiAction + " from method: " + method.getName());
            String responseComment = docEntry == null ? null : docEntry.getReturnTypeComment();
            Response response = this.extractResponseFromMethod(method, responseComment);
            Map<String, String> parameterComments = docEntry == null ? Collections.emptyMap() : docEntry.getParameterComments();
            action.getQueryParameters().putAll(this.extractQueryParameters(apiAction, method, parameterComments));
            action.setBody(this.extractRequestBodyFromMethod(apiAction, method, parameterComments));
            this.addHeadersForMethod(action, apiAction, method);
            String string = description = docEntry == null ? null : docEntry.getComment();
            if (StringUtils.hasText((String)description)) {
                action.setDescription(description);
            } else {
                action.setDescription(method.getName());
            }
            action.getResponses().put("200", response);
            Resource idResource = null;
            Resource leafResource = null;
            ApiParameterMetadata[] resourceIdParameters = this.extractResourceIdParameter(method);
            HashMap<String, ApiParameterMetadata> resourceIdParameterMap = new HashMap<String, ApiParameterMetadata>();
            for (ApiParameterMetadata apiParameterMetadata : resourceIdParameters) {
                resourceIdParameterMap.put("{" + apiParameterMetadata.getName() + "}", apiParameterMetadata);
            }
            for (String partialUrl : splitUrl = apiName.replaceFirst("/", "").split("/")) {
                String displayName;
                leafResource = leafResource == null ? parentResource : idResource;
                partialUrl = this.cleanPathVariableRegex(partialUrl);
                String resourceName = "/" + partialUrl;
                idResource = leafResource.getResource(resourceName);
                if (idResource != null) continue;
                idResource = new Resource();
                idResource.setRelativeUri(resourceName);
                String resourceDescription = displayName = StringUtils.capitalize((String)partialUrl) + " Resource";
                if (pathDescriptions.containsKey(partialUrl)) {
                    resourceDescription = pathDescriptions.get(partialUrl);
                }
                if (resourceIdParameterMap.containsKey(partialUrl)) {
                    String paramComment;
                    displayName = "A specific " + StringUtils.capitalize((String)partialUrl).replace("{", "").replace("}", "");
                    ApiParameterMetadata resourceIdParameter = (ApiParameterMetadata)resourceIdParameterMap.get(partialUrl);
                    UriParameter uriParameter = new UriParameter(resourceIdParameter.getName());
                    ParamType simpleType = SchemaHelper.mapSimpleType(resourceIdParameter.getType());
                    if (simpleType == null) {
                        logger.warn("Only simple parameters are supported for URL Parameters, defaulting " + resourceIdParameter.getType() + " to String");
                        simpleType = ParamType.STRING;
                    }
                    uriParameter.setType(simpleType);
                    uriParameter.setRequired(true);
                    if (StringUtils.hasText((String)resourceIdParameter.getExample())) {
                        uriParameter.setExample(resourceIdParameter.getExample());
                    }
                    if (StringUtils.hasText((String)(paramComment = parameterComments.get(resourceIdParameter.getName())))) {
                        uriParameter.setDescription(paramComment);
                    }
                    idResource.getUriParameters().put(resourceIdParameter.getName(), uriParameter);
                }
                idResource.setDisplayName(displayName);
                idResource.setDescription(resourceDescription);
                idResource.setParentResource(leafResource);
                if (leafResource.getUri() != null) {
                    String targetUri = leafResource.getUri();
                    if (targetUri.startsWith("null/")) {
                        targetUri = targetUri.substring(5);
                    }
                    idResource.setParentUri(targetUri);
                }
                leafResource.getResources().put(resourceName, idResource);
            }
            Resource actionTargetResource = idResource != null ? idResource : (leafResource != null ? leafResource : parentResource);
            action.setResource(actionTargetResource);
            action.setType(apiAction);
            if (actionTargetResource.getActions().containsKey(apiAction)) {
                Action existingAction = (Action)actionTargetResource.getActions().get(apiAction);
                this.mergeActions(existingAction, action);
                continue;
            }
            actionTargetResource.getActions().put(apiAction, action);
        }
    }

    private String cleanPathVariableRegex(String partialUrl) {
        if (partialUrl.startsWith("{") && partialUrl.endsWith("}") && partialUrl.contains(":")) {
            int regexStartIndex = partialUrl.indexOf(":");
            return partialUrl.substring(0, regexStartIndex) + "}";
        }
        return partialUrl;
    }

    @Override
    protected void addHeadersForMethod(Action action, ActionType actionType, Method method) {
    }
}

