/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.style;

import com.phoenixnap.oss.ramlapisync.naming.Pair;
import com.phoenixnap.oss.ramlapisync.style.RamlStyleChecker;
import com.phoenixnap.oss.ramlapisync.verification.Issue;
import com.phoenixnap.oss.ramlapisync.verification.IssueLocation;
import com.phoenixnap.oss.ramlapisync.verification.IssueSeverity;
import com.phoenixnap.oss.ramlapisync.verification.IssueType;
import com.phoenixnap.oss.ramlapisync.verification.RamlChecker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.raml.model.Action;
import org.raml.model.ActionType;
import org.raml.model.Raml;
import org.raml.model.Resource;
import org.raml.model.parameter.AbstractParam;

public class RamlStyleCheckVisitorCoordinator
implements RamlChecker {
    private boolean ignoreCodeStyle = true;
    private Set<Issue> warnings = new LinkedHashSet<Issue>();
    private List<RamlStyleChecker> checkers = new ArrayList<RamlStyleChecker>();

    public RamlStyleCheckVisitorCoordinator(List<RamlStyleChecker> styleChecks) {
        this.checkers.addAll(styleChecks);
    }

    @Override
    public Pair<Set<Issue>, Set<Issue>> check(Raml published, Raml implemented) {
        this.checkChildren(published.getResources(), IssueLocation.CONTRACT);
        if (!this.ignoreCodeStyle) {
            this.checkChildren(implemented.getResources(), IssueLocation.SOURCE);
        }
        return new Pair<Set<Issue>, Set<Issue>>(this.warnings, Collections.emptySet());
    }

    private void checkChildren(Map<String, Resource> resources, IssueLocation location) {
        if (resources != null) {
            for (Map.Entry<String, Resource> entry : resources.entrySet()) {
                Map map;
                Resource resource = entry.getValue();
                for (RamlStyleChecker ramlStyleChecker : this.checkers) {
                    this.warnings.addAll(ramlStyleChecker.checkResourceStyle(entry.getKey(), resource, location));
                }
                Map uriParameters = resource.getUriParameters();
                if (uriParameters != null) {
                    for (Map.Entry uriParameter : uriParameters.entrySet()) {
                        for (RamlStyleChecker ramlStyleChecker : this.checkers) {
                            this.warnings.addAll(ramlStyleChecker.checkParameterStyle((String)uriParameter.getKey(), (AbstractParam)uriParameter.getValue()));
                        }
                    }
                }
                if ((map = resource.getActions()) != null) {
                    for (Map.Entry actionEntry : map.entrySet()) {
                        for (RamlStyleChecker checker : this.checkers) {
                            this.warnings.addAll(checker.checkActionStyle((ActionType)actionEntry.getKey(), (Action)actionEntry.getValue(), location));
                        }
                        Map map2 = ((Action)actionEntry.getValue()).getQueryParameters();
                        if (map2 == null) continue;
                        for (Map.Entry queryParam : map2.entrySet()) {
                            for (RamlStyleChecker checker : this.checkers) {
                                this.warnings.addAll(checker.checkParameterStyle((String)queryParam.getKey(), (AbstractParam)queryParam.getValue()));
                            }
                        }
                    }
                }
                this.checkChildren(resource.getResources(), location);
            }
        }
    }

    protected final void addIssue(IssueLocation location, String description, String ramlLocation) {
        this.warnings.add(new Issue(IssueSeverity.WARNING, location, IssueType.STYLE, description, ramlLocation));
    }
}

