/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.style.checkers;

import com.phoenixnap.oss.ramlapisync.style.RamlStyleCheckerAdapter;
import com.phoenixnap.oss.ramlapisync.style.StyleIssue;
import com.phoenixnap.oss.ramlapisync.verification.IssueLocation;
import java.util.LinkedHashSet;
import java.util.Set;
import org.raml.model.Action;
import org.raml.model.ActionType;
import org.raml.model.SecurityReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionSecurityResponseChecker
extends RamlStyleCheckerAdapter {
    protected static final Logger logger = LoggerFactory.getLogger(ActionSecurityResponseChecker.class);
    public static String DESCRIPTION = "Secured Resources should define 401 and 403 responses";

    @Override
    public Set<StyleIssue> checkActionStyle(ActionType key, Action value, IssueLocation location) {
        logger.debug("Checking Action: " + key);
        LinkedHashSet<StyleIssue> issues = new LinkedHashSet<StyleIssue>();
        if (!(value.getSecuredBy() == null || value.getSecuredBy().size() <= 0 || ((SecurityReference)value.getSecuredBy().get(0)).getName() == null || ((SecurityReference)value.getSecuredBy().get(0)).getName().equals("null") && value.getSecuredBy().size() <= 1 || value.getResponses() != null && value.getResponses().containsKey("401") && value.getResponses().containsKey("403"))) {
            issues.add(new StyleIssue(location, DESCRIPTION, value.getResource(), value));
        }
        return issues;
    }
}

