/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.style.checkers;

import com.phoenixnap.oss.ramlapisync.style.RamlStyleCheckerAdapter;
import com.phoenixnap.oss.ramlapisync.style.StyleIssue;
import com.phoenixnap.oss.ramlapisync.verification.IssueLocation;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.raml.model.ActionType;
import org.raml.model.Resource;
import org.raml.parser.utils.Inflector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceCollectionPluralisationChecker
extends RamlStyleCheckerAdapter {
    protected static final Logger logger = LoggerFactory.getLogger(ResourceCollectionPluralisationChecker.class);
    public static String DESCRIPTION = "Collections of Resources should be Pluralised in the URL";
    public static String ID_RESOURCE_REGEX = "[/]{0,1}\\{([^\\}]*)\\}";
    private static Pattern ID_RESOURCE_PATTERN = Pattern.compile(ID_RESOURCE_REGEX);

    @Override
    public Set<StyleIssue> checkResourceStyle(String name, Resource resource, IssueLocation location) {
        logger.debug("Checking resource " + name);
        LinkedHashSet<StyleIssue> issues = new LinkedHashSet<StyleIssue>();
        if (ID_RESOURCE_PATTERN.matcher(name).find() || "/".equals(name)) {
            return issues;
        }
        boolean hasIdSubresource = false;
        boolean hasVerb = false;
        for (Map.Entry subResourceEntry : resource.getResources().entrySet()) {
            Resource subResource;
            if (ID_RESOURCE_PATTERN.matcher((CharSequence)subResourceEntry.getKey()).find()) {
                hasIdSubresource = true;
            }
            if ((subResource = (Resource)subResourceEntry.getValue()) != null && (subResource.getAction(ActionType.POST) != null || subResource.getAction(ActionType.GET) != null)) {
                hasVerb = true;
            }
            if (!hasIdSubresource || !hasVerb) continue;
            logger.debug("Collection Resource identified: " + name);
            if (!Inflector.singularize((String)name).equals(name) || Inflector.pluralize((String)name).equals(name)) break;
            issues.add(new StyleIssue(location, DESCRIPTION, resource, null));
            break;
        }
        return issues;
    }
}

