/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.verification.checkers;

import com.phoenixnap.oss.ramlapisync.naming.Pair;
import com.phoenixnap.oss.ramlapisync.parser.ResourceParser;
import com.phoenixnap.oss.ramlapisync.verification.Issue;
import com.phoenixnap.oss.ramlapisync.verification.IssueLocation;
import com.phoenixnap.oss.ramlapisync.verification.IssueSeverity;
import com.phoenixnap.oss.ramlapisync.verification.IssueType;
import com.phoenixnap.oss.ramlapisync.verification.RamlActionVisitorCheck;
import com.phoenixnap.oss.ramlapisync.verification.checkers.RamlCheckerResourceVisitorCoordinator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.raml.model.Action;
import org.raml.model.ActionType;
import org.raml.model.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionContentTypeChecker
implements RamlActionVisitorCheck {
    public static String REQUEST_BODY_MISSING = "Body required but not found in target";
    public static String RESPONSE_BODY_MISSING = "Response Body required but not found in target";
    protected static final Logger logger = LoggerFactory.getLogger(ActionContentTypeChecker.class);

    @Override
    public Pair<Set<Issue>, Set<Issue>> check(ActionType name, Action reference, Action target, IssueLocation location, IssueSeverity maxSeverity) {
        Response response;
        Issue issue;
        logger.debug("Checking action " + name);
        LinkedHashSet<Issue> errors = new LinkedHashSet<Issue>();
        LinkedHashSet<Issue> warnings = new LinkedHashSet<Issue>();
        if (location.equals((Object)IssueLocation.CONTRACT)) {
            return new Pair<Set<Issue>, Set<Issue>>(warnings, errors);
        }
        if (reference.getBody() != null && !reference.getBody().isEmpty()) {
            if (target.getBody() == null || target.getBody().isEmpty()) {
                issue = new Issue(maxSeverity, location, IssueType.MISSING, REQUEST_BODY_MISSING, reference.getResource(), reference);
                RamlCheckerResourceVisitorCoordinator.addIssue(errors, warnings, issue, REQUEST_BODY_MISSING);
            }
            if (target.getBody() == null || !target.getBody().containsKey("application/everything")) {
                for (String key : reference.getBody().keySet()) {
                    if (target.getBody().containsKey(key)) continue;
                    issue = new Issue(maxSeverity, location, IssueType.MISSING, REQUEST_BODY_MISSING, reference.getResource(), reference);
                    RamlCheckerResourceVisitorCoordinator.addIssue(errors, warnings, issue, REQUEST_BODY_MISSING + " " + key);
                }
            }
        }
        if ((response = ResourceParser.getSuccessfulResponse(reference)) != null && response.getBody() != null && !response.getBody().isEmpty()) {
            Response targetResponse = ResourceParser.getSuccessfulResponse(target);
            if (targetResponse == null) {
                issue = new Issue(maxSeverity, location, IssueType.MISSING, RESPONSE_BODY_MISSING, reference.getResource(), reference);
                RamlCheckerResourceVisitorCoordinator.addIssue(errors, warnings, issue, RESPONSE_BODY_MISSING);
            } else {
                boolean found = false;
                for (String key : response.getBody().keySet()) {
                    logger.debug("Processing key {}.", (Object)key);
                    if (targetResponse.getBody().containsKey(key)) {
                        found = true;
                        break;
                    }
                    if (found || targetResponse.getBody().containsKey("application/everything")) continue;
                    issue = new Issue(maxSeverity, location, IssueType.MISSING, RESPONSE_BODY_MISSING, reference.getResource(), reference);
                    RamlCheckerResourceVisitorCoordinator.addIssue(errors, warnings, issue, RESPONSE_BODY_MISSING + " " + response.getBody().values());
                }
            }
        }
        return new Pair<Set<Issue>, Set<Issue>>(warnings, errors);
    }
}

