/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.verification.checkers;

import com.phoenixnap.oss.ramlapisync.naming.Pair;
import com.phoenixnap.oss.ramlapisync.verification.Issue;
import com.phoenixnap.oss.ramlapisync.verification.IssueLocation;
import com.phoenixnap.oss.ramlapisync.verification.IssueSeverity;
import com.phoenixnap.oss.ramlapisync.verification.IssueType;
import com.phoenixnap.oss.ramlapisync.verification.RamlResourceVisitorCheck;
import com.phoenixnap.oss.ramlapisync.verification.checkers.RamlCheckerResourceVisitorCoordinator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.raml.model.Action;
import org.raml.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionExistenceChecker
implements RamlResourceVisitorCheck {
    public static String ACTION_MISSING = "Missing Action.";
    protected static final Logger logger = LoggerFactory.getLogger(ActionExistenceChecker.class);

    @Override
    public Pair<Set<Issue>, Set<Issue>> check(String name, Resource reference, Resource target, IssueLocation location, IssueSeverity maxSeverity) {
        logger.debug("Checking Action " + name);
        LinkedHashSet<Issue> errors = new LinkedHashSet<Issue>();
        LinkedHashSet<Issue> warnings = new LinkedHashSet<Issue>();
        Map referenceActions = reference.getActions();
        Map targetActions = target.getActions();
        if (referenceActions != null && referenceActions.size() > 0) {
            for (Map.Entry action : referenceActions.entrySet()) {
                Action targetAction = (Action)targetActions.get(action.getKey());
                if (targetAction != null) continue;
                Issue issue = new Issue(maxSeverity, location, IssueType.MISSING, ACTION_MISSING, reference, (Action)action.getValue());
                RamlCheckerResourceVisitorCoordinator.addIssue(errors, warnings, issue, "Expected action missing: " + action.getKey() + " in " + location.name());
            }
        }
        return new Pair<Set<Issue>, Set<Issue>>(warnings, errors);
    }
}

