/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.verification.checkers;

import com.phoenixnap.oss.ramlapisync.naming.Pair;
import com.phoenixnap.oss.ramlapisync.parser.ResourceParser;
import com.phoenixnap.oss.ramlapisync.verification.Issue;
import com.phoenixnap.oss.ramlapisync.verification.IssueLocation;
import com.phoenixnap.oss.ramlapisync.verification.IssueSeverity;
import com.phoenixnap.oss.ramlapisync.verification.IssueType;
import com.phoenixnap.oss.ramlapisync.verification.RamlActionVisitorCheck;
import com.phoenixnap.oss.ramlapisync.verification.checkers.RamlCheckerResourceVisitorCoordinator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.raml.model.Action;
import org.raml.model.ActionType;
import org.raml.model.MimeType;
import org.raml.model.parameter.QueryParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionQueryParameterChecker
implements RamlActionVisitorCheck {
    public static String QUERY_PARAMETER_MISSING = "Missing Query Parameter.";
    public static String QUERY_PARAMETER_FOUND_IN_FORM = "Missing Query Parameter but found in Form Parameters";
    public static String INCOMPATIBLE_TYPES = "Incompatible data types";
    public static String INCOMPATIBLE_VALIDATION = "Incompatible validation parameters";
    public static String REQUIRED_PARAM_HIDDEN = "Target requires parameter that is marked not required in reference.";
    protected static final Logger logger = LoggerFactory.getLogger(ActionQueryParameterChecker.class);

    @Override
    public Pair<Set<Issue>, Set<Issue>> check(ActionType name, Action reference, Action target, IssueLocation location, IssueSeverity maxSeverity) {
        logger.debug("Checking Action " + name);
        LinkedHashSet<Issue> errors = new LinkedHashSet<Issue>();
        LinkedHashSet<Issue> warnings = new LinkedHashSet<Issue>();
        if (reference.getQueryParameters() != null && !reference.getQueryParameters().isEmpty()) {
            for (Map.Entry cParam : reference.getQueryParameters().entrySet()) {
                Issue issue;
                logger.debug("ActionQueryParameterChecker Checking param " + (String)cParam.getKey());
                IssueSeverity targetSeverity = maxSeverity;
                if (target.getQueryParameters() == null || target.getQueryParameters().isEmpty() || !target.getQueryParameters().containsKey(cParam.getKey())) {
                    targetSeverity = !((QueryParameter)cParam.getValue()).isRequired() ? IssueSeverity.WARNING : IssueSeverity.ERROR;
                    Map targetBody = target.getBody();
                    issue = location == IssueLocation.SOURCE && targetBody != null && targetBody.containsKey("application/x-www-form-urlencoded") && targetBody.get("application/x-www-form-urlencoded") != null && ((MimeType)targetBody.get("application/x-www-form-urlencoded")).getFormParameters() != null && ((MimeType)targetBody.get("application/x-www-form-urlencoded")).getFormParameters().containsKey(cParam.getKey()) && ResourceParser.doesActionTypeSupportRequestBody(reference.getType()) ? new Issue(IssueSeverity.WARNING, location, IssueType.MISSING, QUERY_PARAMETER_FOUND_IN_FORM, reference.getResource(), reference, (String)cParam.getKey()) : new Issue(targetSeverity, location, IssueType.MISSING, QUERY_PARAMETER_MISSING, reference.getResource(), reference, (String)cParam.getKey());
                    RamlCheckerResourceVisitorCoordinator.addIssue(errors, warnings, issue, issue.getDescription() + "  " + (String)cParam.getKey() + " in " + location.name());
                    continue;
                }
                QueryParameter referenceParameter = (QueryParameter)cParam.getValue();
                QueryParameter targetParameter = (QueryParameter)target.getQueryParameters().get(cParam.getKey());
                if (!referenceParameter.isRequired() && targetParameter.isRequired()) {
                    issue = new Issue(maxSeverity, location, IssueType.DIFFERENT, REQUIRED_PARAM_HIDDEN, reference.getResource(), reference, (String)cParam.getKey());
                    RamlCheckerResourceVisitorCoordinator.addIssue(errors, warnings, issue, REQUIRED_PARAM_HIDDEN + " " + (String)cParam.getKey() + " in " + location.name());
                }
                if (referenceParameter.getType() != null && !referenceParameter.getType().equals((Object)targetParameter.getType())) {
                    issue = new Issue(IssueSeverity.WARNING, location, IssueType.DIFFERENT, INCOMPATIBLE_TYPES, reference.getResource(), reference, (String)cParam.getKey());
                    RamlCheckerResourceVisitorCoordinator.addIssue(errors, warnings, issue, INCOMPATIBLE_TYPES + " " + (String)cParam.getKey() + " in " + location.name());
                }
                if (!(referenceParameter.getMinLength() != null && !referenceParameter.getMinLength().equals(targetParameter.getMinLength()) || referenceParameter.getMaxLength() != null && !referenceParameter.getMaxLength().equals(targetParameter.getMaxLength()) || referenceParameter.getMaximum() != null && !referenceParameter.getMaximum().equals(targetParameter.getMaximum()) || referenceParameter.getMinimum() != null && !referenceParameter.getMinimum().equals(targetParameter.getMinimum())) && (referenceParameter.getPattern() == null || referenceParameter.getPattern().equals(targetParameter.getPattern()))) continue;
                issue = new Issue(IssueSeverity.WARNING, location, IssueType.DIFFERENT, INCOMPATIBLE_VALIDATION, reference.getResource(), reference, (String)cParam.getKey());
                RamlCheckerResourceVisitorCoordinator.addIssue(errors, warnings, issue, INCOMPATIBLE_VALIDATION + " " + (String)cParam.getKey() + " in " + location.name());
            }
        }
        return new Pair<Set<Issue>, Set<Issue>>(warnings, errors);
    }
}

