/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.verification.checkers;

import com.phoenixnap.oss.ramlapisync.naming.Pair;
import com.phoenixnap.oss.ramlapisync.verification.Issue;
import com.phoenixnap.oss.ramlapisync.verification.IssueLocation;
import com.phoenixnap.oss.ramlapisync.verification.IssueSeverity;
import com.phoenixnap.oss.ramlapisync.verification.IssueType;
import com.phoenixnap.oss.ramlapisync.verification.RamlActionVisitorCheck;
import com.phoenixnap.oss.ramlapisync.verification.checkers.RamlCheckerResourceVisitorCoordinator;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JFieldVar;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jsonschema2pojo.Annotator;
import org.jsonschema2pojo.DefaultGenerationConfig;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.Jackson2Annotator;
import org.jsonschema2pojo.SchemaGenerator;
import org.jsonschema2pojo.SchemaMapper;
import org.jsonschema2pojo.SchemaStore;
import org.jsonschema2pojo.rules.RuleFactory;
import org.raml.model.Action;
import org.raml.model.ActionType;
import org.raml.model.MimeType;
import org.raml.model.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ActionResponseBodySchemaChecker
implements RamlActionVisitorCheck {
    public static String RESPONSE_BODY_DIFFERENTSIZE = "Response Body in target has a different number of fields to reference";
    public static String RESPONSE_BODY_FIELDMISSING = "Response Body field type is missing";
    public static String RESPONSE_BODY_MISSING = "Response Body required but not found in target";
    public static String RESPONSE_BODY_FIELDDIFFERENT = "Response Body field type is different";
    protected static final Logger logger = LoggerFactory.getLogger(ActionResponseBodySchemaChecker.class);

    @Override
    public Pair<Set<Issue>, Set<Issue>> check(ActionType name, Action reference, Action target, IssueLocation location, IssueSeverity maxSeverity) {
        logger.debug("Checking action " + name);
        LinkedHashSet<Issue> errors = new LinkedHashSet<Issue>();
        LinkedHashSet<Issue> warnings = new LinkedHashSet<Issue>();
        if (location.equals((Object)IssueLocation.CONTRACT)) {
            return new Pair<Set<Issue>, Set<Issue>>(warnings, errors);
        }
        if (reference.getResponses() != null && !reference.getResponses().isEmpty() && reference.getResponses().containsKey("200") && ((Response)reference.getResponses().get("200")).getBody() != null) {
            Map response = ((Response)reference.getResponses().get("200")).getBody();
            for (Map.Entry responseBodyMime : response.entrySet()) {
                Issue issue;
                MimeType value = (MimeType)responseBodyMime.getValue();
                if (!StringUtils.hasText((String)value.getSchema())) continue;
                logger.debug("Found body for mime type " + (String)responseBodyMime.getKey());
                String targetSchema = null;
                try {
                    targetSchema = ((MimeType)((Response)target.getResponses().get("200")).getBody().get(responseBodyMime.getKey())).getSchema();
                }
                catch (NullPointerException npe) {
                    try {
                        targetSchema = ((MimeType)((Response)target.getResponses().get("200")).getBody().values().iterator().next()).getSchema();
                    }
                    catch (Exception ex) {
                        issue = new Issue(maxSeverity, location, IssueType.MISSING, RESPONSE_BODY_MISSING, reference.getResource(), reference);
                        RamlCheckerResourceVisitorCoordinator.addIssue(errors, warnings, issue, RESPONSE_BODY_MISSING + " " + (String)responseBodyMime.getKey());
                        break;
                    }
                }
                if (targetSchema == null) continue;
                JCodeModel referenceCodeModel = new JCodeModel();
                JCodeModel targetCodeModel = new JCodeModel();
                DefaultGenerationConfig config = new DefaultGenerationConfig(){

                    public boolean isGenerateBuilders() {
                        return false;
                    }
                };
                try {
                    String fieldKey;
                    SchemaMapper mapper = new SchemaMapper(new RuleFactory((GenerationConfig)config, (Annotator)new Jackson2Annotator(), new SchemaStore()), new SchemaGenerator());
                    mapper.generate(referenceCodeModel, "Reference", "com.response", value.getSchema());
                    mapper.generate(targetCodeModel, "Target", "com.response", targetSchema);
                    Map referenceResponseFields = referenceCodeModel._getClass("com.response.Reference").fields();
                    Map targetResponseClassFields = targetCodeModel._getClass("com.response.Target").fields();
                    for (Map.Entry referenceField : referenceResponseFields.entrySet()) {
                        fieldKey = (String)referenceField.getKey();
                        JFieldVar targetField = (JFieldVar)targetResponseClassFields.get(fieldKey);
                        if (targetField == null) {
                            issue = new Issue(maxSeverity, location, IssueType.MISSING, RESPONSE_BODY_FIELDMISSING, reference.getResource(), reference, fieldKey);
                            RamlCheckerResourceVisitorCoordinator.addIssue(errors, warnings, issue, RESPONSE_BODY_FIELDMISSING + " " + fieldKey);
                            continue;
                        }
                        if (((JFieldVar)referenceField.getValue()).type().fullName().equals(targetField.type().fullName())) continue;
                        issue = new Issue(IssueSeverity.WARNING, location, IssueType.DIFFERENT, RESPONSE_BODY_FIELDDIFFERENT, reference.getResource(), reference, fieldKey);
                        RamlCheckerResourceVisitorCoordinator.addIssue(errors, warnings, issue, RESPONSE_BODY_FIELDDIFFERENT + " " + fieldKey);
                    }
                    if (referenceResponseFields.size() == targetResponseClassFields.size()) continue;
                    for (Map.Entry targetField : targetResponseClassFields.entrySet()) {
                        fieldKey = (String)targetField.getKey();
                        JFieldVar referenceField = (JFieldVar)referenceResponseFields.get(fieldKey);
                        if (referenceField == null) {
                            issue = new Issue(maxSeverity, IssueLocation.CONTRACT, IssueType.MISSING, RESPONSE_BODY_FIELDMISSING, reference.getResource(), reference, fieldKey);
                            RamlCheckerResourceVisitorCoordinator.addIssue(errors, warnings, issue, RESPONSE_BODY_FIELDMISSING + " " + fieldKey);
                            continue;
                        }
                        if (((JFieldVar)targetField.getValue()).type().fullName().equals(referenceField.type().fullName())) continue;
                        issue = new Issue(IssueSeverity.WARNING, IssueLocation.CONTRACT, IssueType.DIFFERENT, RESPONSE_BODY_FIELDDIFFERENT, reference.getResource(), reference, fieldKey);
                        RamlCheckerResourceVisitorCoordinator.addIssue(errors, warnings, issue, RESPONSE_BODY_FIELDDIFFERENT + " " + fieldKey);
                    }
                }
                catch (IOException ex) {
                    logger.error("Error during Schema to POJO generation");
                }
            }
        }
        return new Pair<Set<Issue>, Set<Issue>>(warnings, errors);
    }
}

