/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.verification.checkers;

import com.phoenixnap.oss.ramlapisync.naming.Pair;
import com.phoenixnap.oss.ramlapisync.verification.Issue;
import com.phoenixnap.oss.ramlapisync.verification.IssueLocation;
import com.phoenixnap.oss.ramlapisync.verification.IssueSeverity;
import com.phoenixnap.oss.ramlapisync.verification.IssueType;
import com.phoenixnap.oss.ramlapisync.verification.RamlActionVisitorCheck;
import com.phoenixnap.oss.ramlapisync.verification.RamlChecker;
import com.phoenixnap.oss.ramlapisync.verification.RamlResourceVisitorCheck;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.raml.model.Action;
import org.raml.model.ActionType;
import org.raml.model.Raml;
import org.raml.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RamlCheckerResourceVisitorCoordinator
implements RamlChecker {
    protected static final Logger logger = LoggerFactory.getLogger(RamlCheckerResourceVisitorCoordinator.class);
    private Set<Issue> errors = new LinkedHashSet<Issue>();
    private Set<Issue> warnings = new LinkedHashSet<Issue>();
    private List<RamlActionVisitorCheck> actionCheckers = new ArrayList<RamlActionVisitorCheck>();
    private List<RamlResourceVisitorCheck> resourceCheckers = new ArrayList<RamlResourceVisitorCheck>();

    public RamlCheckerResourceVisitorCoordinator(List<RamlActionVisitorCheck> actionCheckers, List<RamlResourceVisitorCheck> resourceCheckers) {
        this.actionCheckers.addAll(actionCheckers);
        this.resourceCheckers.addAll(resourceCheckers);
    }

    public static void addIssue(Set<Issue> errors, Set<Issue> warnings, Issue issue, String logDescription) {
        if (issue.getSeverity().equals((Object)IssueSeverity.ERROR)) {
            logger.error(logDescription);
            errors.add(issue);
        } else {
            logger.warn(logDescription);
            warnings.add(issue);
        }
    }

    @Override
    public Pair<Set<Issue>, Set<Issue>> check(Raml published, Raml implemented) {
        if (this.actionCheckers.size() == 0 && this.resourceCheckers.size() == 0) {
            return new Pair<Set<Issue>, Set<Issue>>(Collections.emptySet(), Collections.emptySet());
        }
        logger.info("Performing Resource and Action Visitor Checks");
        if (published != null && implemented == null) {
            this.errors.add(new Issue(IssueSeverity.ERROR, IssueLocation.CONTRACT, IssueType.MISSING, "Completely Missing Implementation for RAML file", "/"));
        } else if (published == null && implemented != null) {
            this.errors.add(new Issue(IssueSeverity.ERROR, IssueLocation.SOURCE, IssueType.MISSING, "Completely Missing RAML file", "/"));
        } else {
            logger.debug("Checking resources using contract as reference. Warnings only");
            this.check(published.getResources(), implemented.getResources(), IssueLocation.SOURCE, IssueSeverity.ERROR);
            logger.debug("Checking resources using implementation as reference. Warnings only");
            this.check(implemented.getResources(), published.getResources(), IssueLocation.CONTRACT, IssueSeverity.WARNING);
        }
        return new Pair<Set<Issue>, Set<Issue>>(this.warnings, this.errors);
    }

    private void check(Map<String, Resource> referenceResourcesMap, Map<String, Resource> targetResourcesMap, IssueLocation location, IssueSeverity severity) {
        Set<Object> referenceResources = referenceResourcesMap != null ? referenceResourcesMap.keySet() : Collections.emptySet();
        Set<Object> targetResources = targetResourcesMap != null ? targetResourcesMap.keySet() : Collections.emptySet();
        for (String string : referenceResources) {
            Resource reference = referenceResourcesMap.get(string);
            String resourceLocation = Issue.buildRamlLocation(reference, null, null);
            if (targetResources.contains(string)) {
                logger.debug("Visiting resource: " + resourceLocation + " in " + (Object)((Object)(location.equals((Object)IssueLocation.SOURCE) ? IssueLocation.CONTRACT : IssueLocation.SOURCE)));
                Resource target = targetResourcesMap.get(string);
                for (RamlResourceVisitorCheck resourceCheck : this.resourceCheckers) {
                    Pair<Set<Issue>, Set<Issue>> check = resourceCheck.check(string, reference, target, location, severity);
                    if (check != null && check.getFirst() != null) {
                        this.warnings.addAll((Collection<Issue>)check.getFirst());
                    }
                    if (check == null || check.getSecond() == null) continue;
                    this.errors.addAll((Collection<Issue>)check.getSecond());
                }
                Map referenceActions = reference.getActions();
                Map targetActions = target.getActions();
                if (referenceActions != null && referenceActions.size() > 0 && targetActions != null && targetActions.size() > 0) {
                    for (Map.Entry action : referenceActions.entrySet()) {
                        Action targetAction = (Action)targetActions.get(action.getKey());
                        String actionLocation = Issue.buildRamlLocation(reference, (Action)referenceActions.get(action.getKey()), null);
                        if (targetAction != null) {
                            logger.debug("Visiting action: " + actionLocation);
                            for (RamlActionVisitorCheck actionCheck : this.actionCheckers) {
                                Pair<Set<Issue>, Set<Issue>> check = actionCheck.check((ActionType)action.getKey(), (Action)action.getValue(), targetAction, location, severity);
                                if (check != null && check.getFirst() != null) {
                                    this.warnings.addAll((Collection<Issue>)check.getFirst());
                                }
                                if (check == null || check.getSecond() == null) continue;
                                this.errors.addAll((Collection<Issue>)check.getSecond());
                            }
                            continue;
                        }
                        logger.debug("Skipping visiting action " + actionLocation + " in " + (Object)((Object)(location.equals((Object)IssueLocation.SOURCE) ? IssueLocation.CONTRACT : IssueLocation.SOURCE)));
                    }
                }
                this.check(referenceResourcesMap.get(string).getResources(), targetResourcesMap.get(string).getResources(), location, severity);
                continue;
            }
            logger.debug("Skipping visiting resource " + resourceLocation + " in " + (Object)((Object)(location.equals((Object)IssueLocation.SOURCE) ? IssueLocation.CONTRACT : IssueLocation.SOURCE)));
        }
    }
}

