/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.plugin;

import com.phoenixnap.oss.ramlapisync.data.ApiBodyMetadata;
import com.phoenixnap.oss.ramlapisync.data.ApiControllerMetadata;
import com.phoenixnap.oss.ramlapisync.generation.RamlParser;
import com.phoenixnap.oss.ramlapisync.generation.rules.Rule;
import com.phoenixnap.oss.ramlapisync.generation.rules.Spring4ControllerStubRule;
import com.phoenixnap.oss.ramlapisync.naming.NamingHelper;
import com.phoenixnap.oss.ramlapisync.plugin.ClassLoaderUtils;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.jsonschema2pojo.Annotator;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.Jackson1Annotator;
import org.raml.model.Raml;
import org.springframework.util.StringUtils;

@Mojo(name="generate-springmvc-endpoints", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class SpringMvcEndpointGeneratorMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Component
    private PluginDescriptor descriptor;
    @Parameter(required=true, readonly=true, defaultValue="")
    protected String ramlPath;
    @Parameter(required=false, readonly=true, defaultValue="")
    protected String outputRelativePath;
    @Parameter(required=false, readonly=true, defaultValue="false")
    protected Boolean addTimestampFolder;
    @Parameter(required=true, readonly=true, defaultValue="")
    protected String basePackage;
    @Parameter(required=false, readonly=true)
    protected String baseUri;
    @Parameter(required=false, readonly=true, defaultValue="false")
    protected Boolean seperateMethodsByContentType;
    @Parameter(required=false, readonly=true, defaultValue="false")
    protected Boolean useJackson1xCompatibility;
    @Parameter(required=false, readonly=true, defaultValue="com.phoenixnap.oss.ramlapisync.generation.rules.Spring4ControllerStubRule")
    protected String rule;
    private ClassRealm classRealm;

    protected void generateEndpoints() throws MojoExecutionException, MojoFailureException, IOException {
        String resolvedPath = this.project.getBasedir().getAbsolutePath();
        if (resolvedPath.endsWith(File.separator) || resolvedPath.endsWith("/")) {
            resolvedPath = resolvedPath.substring(0, resolvedPath.length() - 1);
        }
        String resolvedRamlPath = this.project.getBasedir().getAbsolutePath();
        resolvedRamlPath = !this.ramlPath.startsWith(File.separator) && !this.ramlPath.startsWith("/") ? resolvedRamlPath + File.separator + this.ramlPath : resolvedRamlPath + this.ramlPath;
        Raml loadRamlFromFile = RamlParser.loadRamlFromFile((String)("file:" + resolvedRamlPath));
        RamlParser par = new RamlParser(this.basePackage, this.getBasePath(loadRamlFromFile), this.seperateMethodsByContentType.booleanValue());
        Set controllers = par.extractControllers(loadRamlFromFile);
        if (StringUtils.hasText((String)this.outputRelativePath)) {
            if (!this.outputRelativePath.startsWith(File.separator) && !this.outputRelativePath.startsWith("/")) {
                resolvedPath = resolvedPath + File.separator;
            }
            resolvedPath = resolvedPath + this.outputRelativePath;
        } else {
            resolvedPath = resolvedPath + "/target/generated-sources/spring-mvc";
        }
        File rootDir = new File(resolvedPath + (this.addTimestampFolder == true ? Long.valueOf(System.currentTimeMillis()) : "") + "/");
        if (!rootDir.exists() && !rootDir.mkdirs()) {
            throw new IOException("Could not create directory:" + rootDir.getAbsolutePath());
        }
        this.generateCode(controllers, rootDir);
    }

    private void generateCode(Set<ApiControllerMetadata> controllers, File rootDir) {
        for (ApiControllerMetadata met : controllers) {
            this.getLog().debug((CharSequence)"");
            this.getLog().debug((CharSequence)"-----------------------------------------------------------");
            this.getLog().debug((CharSequence)met.getName());
            this.getLog().debug((CharSequence)"");
            Set dependencies = met.getDependencies();
            for (ApiBodyMetadata body : dependencies) {
                this.generateModelSources(met, body, rootDir, null, (Annotator)(this.useJackson1xCompatibility == true ? new Jackson1Annotator() : null));
            }
            this.generateControllerSource(met, rootDir);
        }
    }

    private String getBasePath(Raml loadRamlFromFile) {
        String basePath = loadRamlFromFile.getBaseUri();
        if (this.baseUri != null) {
            basePath = this.baseUri;
        }
        if (basePath != null && basePath.equals("/")) {
            basePath = "";
        }
        return basePath;
    }

    private Rule<JCodeModel, JDefinedClass, ApiControllerMetadata> loadRule() {
        Spring4ControllerStubRule ruleInstance = new Spring4ControllerStubRule();
        try {
            ruleInstance = (Rule)this.getClassRealm().loadClass(this.rule).newInstance();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Could not instantiate Rule " + this.rule + ". The default Rule will be used for code generation."), (Throwable)e);
        }
        return ruleInstance;
    }

    private ClassRealm getClassRealm() throws DependencyResolutionRequiredException, MalformedURLException {
        if (this.classRealm == null) {
            List runtimeClasspathElements = this.project.getRuntimeClasspathElements();
            this.classRealm = this.descriptor.getClassRealm();
            for (String element : runtimeClasspathElements) {
                File elementFile = new File(element);
                this.classRealm.addURL(elementFile.toURI().toURL());
            }
        }
        return this.classRealm;
    }

    private void generateModelSources(ApiControllerMetadata met, ApiBodyMetadata body, File rootDir, GenerationConfig config, Annotator annotator) {
        try {
            JCodeModel codeModel = config == null && annotator == null ? body.getCodeModel() : body.getCodeModel(this.basePackage + NamingHelper.getDefaultModelPackage(), config, annotator);
            if (codeModel != null) {
                codeModel.build(rootDir);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.getLog().error((CharSequence)("Could not build code model for " + met.getName()), (Throwable)e);
        }
    }

    private void generateControllerSource(ApiControllerMetadata met, File dir) {
        JCodeModel codeModel = new JCodeModel();
        this.loadRule().apply((Object)met, (Object)codeModel);
        try {
            codeModel.build(dir);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.getLog().error((CharSequence)("Could not build code model for " + met.getName()), (Throwable)e);
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        long startTime = System.currentTimeMillis();
        try {
            this.generateEndpoints();
        }
        catch (IOException e) {
            ClassLoaderUtils.restoreOriginalClassLoader();
            throw new MojoExecutionException((Object)e, "Unexpected exception while executing Spring MVC Endpoint Generation Plugin.", e.toString());
        }
        this.getLog().info((CharSequence)("Endpoint Generation Complete in:" + (System.currentTimeMillis() - startTime) + "ms"));
    }
}

