/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.plugin;

import com.phoenixnap.oss.ramlapisync.generation.RamlGenerator;
import com.phoenixnap.oss.ramlapisync.parser.ResourceParser;
import com.phoenixnap.oss.ramlapisync.parser.SpringMvcResourceParser;
import com.phoenixnap.oss.ramlapisync.plugin.ClassLoaderUtils;
import com.phoenixnap.oss.ramlapisync.plugin.CommonApiSyncMojo;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Mojo(name="generate-springmvc-api-docs", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class SpringMvcRamlApiSyncMojo
extends CommonApiSyncMojo {
    @Parameter(required=true, readonly=true)
    protected String outputRamlFilePath;
    @Parameter(required=false, readonly=true, defaultValue="false")
    protected Boolean createPathIfMissing;
    @Parameter(required=false, readonly=true, defaultValue="false")
    private boolean removeOldOutput;
    @Parameter(required=true, readonly=true)
    protected String restBasePath;
    @Parameter(required=false, readonly=true, defaultValue="false")
    protected Boolean restrictOnMediaType;

    @Override
    protected Class<? extends Annotation>[] getSupportedClassAnnotations() {
        return new Class[]{Controller.class, RestController.class, RequestMapping.class};
    }

    protected void generateRaml() throws MojoExecutionException, MojoFailureException, IOException {
        super.prepareRaml();
        Class[] classArray = new Class[this.annotatedClasses.size()];
        classArray = this.annotatedClasses.toArray(classArray);
        File targetPath = StringUtils.hasText((String)this.javaDocPath) ? new File(this.javaDocPath) : (this.project.getBasedir().getParentFile() != null ? this.project.getBasedir().getParentFile() : this.project.getBasedir());
        SpringMvcResourceParser scanner = new SpringMvcResourceParser(targetPath, this.version, this.defaultMediaType, this.restrictOnMediaType.booleanValue());
        RamlGenerator ramlGenerator = new RamlGenerator((ResourceParser)scanner);
        ramlGenerator.generateRamlForClasses(this.project.getArtifactId(), this.version, this.restBasePath, classArray, this.documents);
        ramlGenerator.outputRamlToFile(this.getFullRamlOutputPath(), this.createPathIfMissing, Boolean.valueOf(this.removeOldOutput));
    }

    public String getFullRamlOutputPath() {
        return this.project.getBasedir() + this.outputRamlFilePath;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        long startTime = System.currentTimeMillis();
        if (this.project.getPackaging().equals("pom")) {
            this.getLog().info((CharSequence)("Skipping [pom] project: " + this.project.getName()));
        } else if (this.project.getPackaging().equals("maven-plugin")) {
            this.getLog().info((CharSequence)("Skipping [maven-plugin] project: " + this.project.getName()));
        } else if (!Files.isDirectory(Paths.get(this.project.getBuild().getSourceDirectory(), new String[0]), LinkOption.NOFOLLOW_LINKS)) {
            this.getLog().info((CharSequence)("Skipping project with missing src folder: " + this.project.getName()));
        } else {
            try {
                this.generateRaml();
            }
            catch (IOException e) {
                ClassLoaderUtils.restoreOriginalClassLoader();
                throw new MojoExecutionException((Object)e, "Unexpected exception while executing Raml Sync Plugin.", e.toString());
            }
        }
        this.getLog().info((CharSequence)("Raml Generation Complete in:" + (System.currentTimeMillis() - startTime) + "ms"));
    }
}

