/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlplugin.raml2code.data;

import com.phoenixnap.oss.ramlplugin.raml2code.data.ApiBodyMetadata;
import com.phoenixnap.oss.ramlplugin.raml2code.data.ApiParameterMetadata;
import com.phoenixnap.oss.ramlplugin.raml2code.data.ApiResourceMetadata;
import com.phoenixnap.oss.ramlplugin.raml2code.data.RamlFormParameter;
import com.phoenixnap.oss.ramlplugin.raml2code.helpers.NamingHelper;
import com.phoenixnap.oss.ramlplugin.raml2code.helpers.RamlHelper;
import com.phoenixnap.oss.ramlplugin.raml2code.helpers.RamlTypeHelper;
import com.phoenixnap.oss.ramlplugin.raml2code.helpers.SchemaHelper;
import com.phoenixnap.oss.ramlplugin.raml2code.plugin.Config;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlAbstractParam;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlAction;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlActionType;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlDataType;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlMimeType;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlQueryParameter;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlResource;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlResponse;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlUriParameter;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.raml10.RJP10V2RamlQueryParameter;
import com.sun.codemodel.JCodeModel;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.raml.v2.api.model.v10.datamodel.JSONTypeDeclaration;
import org.springframework.util.StringUtils;

public class ApiActionMetadata {
    ApiResourceMetadata parent;
    RamlResource resource;
    RamlActionType actionType;
    RamlAction action;
    String requestBodyMime = null;
    ApiBodyMetadata requestBody = null;
    Map<String, ApiBodyMetadata> responseBody = new LinkedHashMap<String, ApiBodyMetadata>();
    Set<ApiParameterMetadata> pathVariables = null;
    Set<ApiParameterMetadata> requestParameters = new LinkedHashSet<ApiParameterMetadata>();
    Set<ApiParameterMetadata> requestHeaders = null;
    private String responseContentTypeFilter;

    public ApiActionMetadata(ApiResourceMetadata parent, RamlResource resource, RamlActionType actionType, RamlAction action, String responseContentTypeFilter) {
        this.parent = parent;
        this.resource = resource;
        this.actionType = actionType;
        this.action = action;
        this.responseContentTypeFilter = responseContentTypeFilter;
        this.parseRequest(parent.getBodyCodeModel());
        this.parseResponse(parent.getBodyCodeModel(), responseContentTypeFilter);
    }

    public String toString() {
        return "Method " + this.getName() + "  Verb [" + (Object)((Object)this.actionType) + "] Url [" + this.getUrl() + "] \nConsumes [" + this.getConsumes() + "] Produces [" + this.getProduces() + "] with Schema [" + null + "] \nPath Vars [" + StringUtils.collectionToCommaDelimitedString(this.getPathVariables()) + "] \nRequest Params [" + StringUtils.collectionToCommaDelimitedString(this.getRequestParameters()) + "] \nRequest Headers [" + StringUtils.collectionToCommaDelimitedString(this.getRequestHeaders()) + "] \n";
    }

    public Set<ApiParameterMetadata> getPathVariables() {
        this.pathVariables = new LinkedHashSet<ApiParameterMetadata>();
        RamlResource targetResource = this.action.getResource();
        do {
            for (Map.Entry<String, RamlUriParameter> param : targetResource.getUriParameters().entrySet()) {
                this.pathVariables.add(new ApiParameterMetadata(param.getKey(), param.getValue(), null));
            }
        } while ((targetResource = targetResource.getParentResource()) != null);
        return this.pathVariables;
    }

    public Set<ApiParameterMetadata> getRequestParameters() {
        if (this.requestParameters == null) {
            return Collections.emptySet();
        }
        return this.requestParameters;
    }

    public Set<ApiParameterMetadata> getRequestHeaders() {
        if (this.requestHeaders == null) {
            return Collections.emptySet();
        }
        return this.requestHeaders;
    }

    private void parseRequest(JCodeModel codeModel) {
        if (this.action.getQueryParameters() != null && !this.action.getQueryParameters().isEmpty()) {
            for (Map.Entry<String, RamlQueryParameter> entry : this.action.getQueryParameters().entrySet()) {
                this.collectQueryParams(codeModel, entry);
            }
        }
        this.requestHeaders = this.action.getHeaders().entrySet().stream().map(param -> new ApiParameterMetadata((String)param.getKey(), (RamlAbstractParam)param.getValue(), codeModel)).collect(Collectors.toCollection(LinkedHashSet::new));
        if (this.action.getBody() != null && !this.action.getBody().isEmpty()) {
            for (Map.Entry<String, Object> entry : this.action.getBody().entrySet()) {
                this.collectBodyParams(codeModel, entry);
            }
        }
    }

    private void collectQueryParams(JCodeModel codeModel, Map.Entry<String, RamlQueryParameter> queryParameter) {
        RamlDataType type;
        if (queryParameter.getValue() instanceof RJP10V2RamlQueryParameter && (type = ((RJP10V2RamlQueryParameter)queryParameter.getValue()).getRamlDataType()) != null) {
            RamlTypeHelper.mapTypeToPojo(codeModel, this.parent.getDocument(), type.getType());
        }
        this.requestParameters.add(new ApiParameterMetadata(queryParameter.getKey(), queryParameter.getValue(), codeModel));
    }

    private void collectBodyParams(JCodeModel codeModel, Map.Entry<String, RamlMimeType> mime) {
        if (mime.getKey().equals("multipart/form-data") && this.doesActionTypeSupportMultipartMime(this.actionType)) {
            this.collectRequestParamsForMime(this.action.getBody().get("multipart/form-data"));
        } else if (mime.getKey().equals("application/x-www-form-urlencoded") && this.doesActionTypeSupportMultipartMime(this.actionType)) {
            this.collectRequestParamsForMime(this.action.getBody().get("application/x-www-form-urlencoded"));
        }
        if (this.doesActionTypeSupportRequestBody(this.actionType) && (mime.getKey().toLowerCase().contains("json") || mime.getKey().toLowerCase().equals("body"))) {
            String schema = mime.getValue().getSchema();
            RamlDataType type = mime.getValue().getType();
            ApiBodyMetadata requestBody = null;
            String name = StringUtils.capitalize((String)this.getName()) + "Request";
            if (type != null && type.getType() != null && !(type.getType() instanceof JSONTypeDeclaration)) {
                requestBody = RamlTypeHelper.mapTypeToPojo(codeModel, this.parent.getDocument(), type.getType());
            } else if (StringUtils.hasText((String)schema)) {
                requestBody = SchemaHelper.mapSchemaToPojo(this.parent.getDocument(), schema, Config.getPojoPackage(), name, null);
            }
            if (requestBody != null) {
                this.setRequestBody(requestBody, mime.getKey());
            }
        }
    }

    private boolean doesActionTypeSupportRequestBody(RamlActionType target) {
        return target.equals((Object)RamlActionType.POST) || target.equals((Object)RamlActionType.PUT) || target.equals((Object)RamlActionType.PATCH) || target.equals((Object)RamlActionType.DELETE);
    }

    private boolean doesActionTypeSupportMultipartMime(RamlActionType target) {
        return target.equals((Object)RamlActionType.POST);
    }

    private void collectRequestParamsForMime(RamlMimeType requestBody) {
        if (requestBody == null) {
            return;
        }
        for (Map.Entry<String, List<RamlFormParameter>> params : requestBody.getFormParameters().entrySet()) {
            for (RamlFormParameter param : params.getValue()) {
                this.requestParameters.add(new ApiParameterMetadata(params.getKey(), param, null));
            }
        }
    }

    private void parseResponse(JCodeModel codeModel, String responseContentTypeFilter) {
        RamlResponse response = RamlHelper.getSuccessfulResponse(this.action);
        if (response != null && response.getBody() != null && !response.getBody().isEmpty()) {
            for (Map.Entry<String, RamlMimeType> body : response.getBody().entrySet()) {
                if (responseContentTypeFilter != null && !body.getKey().equals(responseContentTypeFilter) || !body.getKey().toLowerCase().contains("json") && !body.getKey().toLowerCase().equals("body")) continue;
                ApiBodyMetadata responseBody = null;
                RamlDataType type = body.getValue().getType();
                String schema = body.getValue().getSchema();
                String name = StringUtils.capitalize((String)this.getName()) + "Response";
                if (type != null && type.getType() != null && !(type.getType() instanceof JSONTypeDeclaration)) {
                    responseBody = RamlTypeHelper.mapTypeToPojo(codeModel, this.parent.getDocument(), type.getType());
                } else if (StringUtils.hasText((String)schema)) {
                    responseBody = SchemaHelper.mapSchemaToPojo(this.parent.getDocument(), schema, Config.getPojoPackage(), name, null);
                }
                if (responseBody == null) continue;
                this.responseBody.put(body.getKey(), responseBody);
            }
        }
    }

    public String getUrl() {
        return this.resource.getUri().replace(this.parent.getResourceUri(), "");
    }

    public String getName() {
        String name = NamingHelper.getActionName(this);
        if (this.responseContentTypeFilter != null) {
            name = name + NamingHelper.convertContentTypeToQualifier(this.responseContentTypeFilter);
        }
        return name;
    }

    public String getProduces() {
        if (this.responseBody != null && !this.responseBody.isEmpty()) {
            String out = "";
            boolean first = true;
            for (String key : this.responseBody.keySet()) {
                if (first) {
                    first = false;
                } else {
                    out = out + ",";
                }
                out = out + key;
            }
            return out;
        }
        return null;
    }

    public String getConsumes() {
        if (this.action.hasBody()) {
            String out = null;
            boolean first = true;
            for (String key : this.action.getBody().keySet()) {
                if ("application/x-www-form-urlencoded".equals(key)) continue;
                if (first) {
                    first = false;
                    out = "";
                } else {
                    out = out + ",";
                }
                if (key.equals("body")) {
                    try {
                        out = out + this.parent.getDocument().getMediaType();
                    }
                    catch (Exception exception) {}
                    continue;
                }
                out = out + key;
            }
            return out;
        }
        return null;
    }

    public String getDescription() {
        return this.action.getDescription();
    }

    public ApiResourceMetadata getParent() {
        return this.parent;
    }

    public void setParent(ApiResourceMetadata parent) {
        this.parent = parent;
    }

    public RamlResource getResource() {
        return this.resource;
    }

    public void setResource(RamlResource resource) {
        this.resource = resource;
    }

    public RamlActionType getActionType() {
        return this.actionType;
    }

    public void setActionType(RamlActionType actionType) {
        this.actionType = actionType;
    }

    public RamlAction getAction() {
        return this.action;
    }

    public void setAction(RamlAction action) {
        this.action = action;
    }

    public ApiBodyMetadata getRequestBody() {
        return this.requestBody;
    }

    private void setRequestBody(ApiBodyMetadata requestBody, String mimeType) {
        if (this.requestBody != null) {
            throw new IllegalStateException("Body Metadata is immutable");
        }
        this.requestBodyMime = mimeType;
        this.requestBody = requestBody;
    }

    public void setPathVariables(Set<ApiParameterMetadata> pathVariables) {
        this.pathVariables = pathVariables;
    }

    public void setRequestParameters(Set<ApiParameterMetadata> requestParameters) {
        this.requestParameters = requestParameters;
    }

    public Map<String, ApiBodyMetadata> getResponseBody() {
        return this.responseBody;
    }

    public String getRequestBodyMime() {
        return this.requestBodyMime;
    }

    public void setRequestBodyMime(String requestBodyMime) {
        this.requestBodyMime = requestBodyMime;
    }
}

