/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlplugin.raml2code.data;

import com.phoenixnap.oss.ramlplugin.raml2code.helpers.NamingHelper;
import com.phoenixnap.oss.ramlplugin.raml2code.helpers.SchemaHelper;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlParamType;
import com.sun.codemodel.JCodeModel;
import org.jsonschema2pojo.Annotator;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class ApiBodyMetadata {
    private String name;
    private String schema;
    private TypeDeclaration type;
    private JCodeModel codeModel;
    private boolean array = false;

    public ApiBodyMetadata(String name, TypeDeclaration type, boolean array, JCodeModel codeModel) {
        this.schema = null;
        this.type = type;
        this.name = name;
        this.codeModel = codeModel;
        this.array = array;
    }

    private int nestingCounter(String target, int index) {
        int nestedLevels = 0;
        for (int i = 0; i < index; ++i) {
            if (target.charAt(i) == '{') {
                ++nestedLevels;
            }
            if (target.charAt(i) != '}') continue;
            --nestedLevels;
        }
        return nestedLevels;
    }

    public ApiBodyMetadata(String name, String schema, JCodeModel codeModel) {
        int nextQuoteIdxIdx;
        int quoteIdx;
        this.schema = schema;
        this.name = name;
        this.codeModel = codeModel;
        boolean typeFound = false;
        int typeIdx = schema.indexOf("type");
        while (!typeFound) {
            if (typeIdx == -1) {
                typeFound = true;
                break;
            }
            if (this.nestingCounter(schema, typeIdx) == 1) {
                typeFound = true;
                continue;
            }
            typeIdx = schema.indexOf("type", typeIdx + 1);
        }
        if (typeIdx != -1 && (quoteIdx = schema.indexOf("\"", typeIdx + 6)) != -1 && (nextQuoteIdxIdx = schema.indexOf("\"", quoteIdx + 1)) != -1) {
            String possibleType = schema.substring(quoteIdx + 1, nextQuoteIdxIdx);
            this.name = NamingHelper.getResourceName(this.name, true);
            if ("array".equals(possibleType.toLowerCase())) {
                this.array = true;
            }
            if (codeModel.countArtifacts() == 0 && !"object".equals(possibleType.toLowerCase())) {
                try {
                    this.name = SchemaHelper.mapSimpleType(RamlParamType.valueOf(possibleType.toUpperCase()), null).getSimpleName();
                }
                catch (Exception ex) {
                    this.name = String.class.getSimpleName();
                }
                this.codeModel = null;
            }
        }
    }

    public TypeDeclaration getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getSchema() {
        return this.schema;
    }

    public JCodeModel getCodeModel() {
        return this.codeModel;
    }

    public boolean isArray() {
        return this.array;
    }

    public JCodeModel getCodeModel(String basePackage, String schemaLocation, Annotator annotator) {
        if (this.type != null) {
            return this.codeModel;
        }
        return SchemaHelper.buildBodyJCodeModel(schemaLocation, basePackage, this.name, this.schema, annotator);
    }
}

