/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlplugin.raml2code.helpers;

import com.phoenixnap.oss.ramlplugin.raml2code.data.ApiActionMetadata;
import com.phoenixnap.oss.ramlplugin.raml2code.data.ApiBodyMetadata;
import com.phoenixnap.oss.ramlplugin.raml2code.data.ApiParameterMetadata;
import com.phoenixnap.oss.ramlplugin.raml2code.helpers.SchemaHelper;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlActionType;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlResource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jsonschema2pojo.util.NameHelper;
import org.raml.v2.internal.utils.Inflector;

public class NamingHelper {
    private static final Pattern CONTENT_TYPE_VERSION = Pattern.compile("[^v]*(v[\\d\\.]*).*", 2);
    private static final Pattern SLASH = Pattern.compile("/");
    private static final String ILLEGAL_CHARACTER_REGEX = "[^0-9a-zA-Z_$]";
    private static NameHelper cachedNameHelper;

    private static NameHelper getNameHelper() {
        if (cachedNameHelper != null) {
            return cachedNameHelper;
        }
        cachedNameHelper = new NameHelper(SchemaHelper.getDefaultGenerationConfig());
        return cachedNameHelper;
    }

    public static String convertContentTypeToQualifier(String contentType) {
        String version;
        if (contentType.equals("application/json")) {
            return "AsJson";
        }
        if (contentType.equals("application/octet-stream")) {
            return "AsBinary";
        }
        if (contentType.equals("text/plain") || contentType.equals("text/html")) {
            return "AsText";
        }
        Matcher versionMatcher = CONTENT_TYPE_VERSION.matcher(contentType);
        if (versionMatcher.find() && (version = versionMatcher.group(1)) != null) {
            return org.springframework.util.StringUtils.capitalize((String)version).replace(".", "_");
        }
        int seperatorIndex = contentType.indexOf("/");
        if (seperatorIndex != -1 && seperatorIndex < contentType.length()) {
            String candidate = contentType.substring(seperatorIndex + 1).toLowerCase();
            String out = "";
            if (candidate.contains("json")) {
                candidate = candidate.replace("json", "");
                out = out + "AsJson";
            }
            if (org.springframework.util.StringUtils.hasText((String)(candidate = org.springframework.util.StringUtils.deleteAny((String)candidate, (String)" ,.+=-'\"\\|~`#$%^&\n\t")))) {
                out = org.springframework.util.StringUtils.capitalize((String)candidate) + out;
            }
            return "_" + out;
        }
        return "";
    }

    public static List<String> extractUriParams(String url) {
        ArrayList<String> outParams = new ArrayList<String>();
        if (org.springframework.util.StringUtils.hasText((String)url)) {
            String[] split;
            for (String part : split = org.springframework.util.StringUtils.split((String)url, (String)"/")) {
                int indexOfStart = part.indexOf("{");
                int indexOfEnd = part.indexOf("}");
                if (indexOfStart == -1 || indexOfEnd == -1 || indexOfStart >= indexOfEnd) continue;
                outParams.add(part.substring(indexOfStart + 1, indexOfEnd));
            }
        }
        return outParams;
    }

    public static boolean isValidJavaClassName(String input) {
        if (!org.springframework.util.StringUtils.hasText((String)input)) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(input.charAt(0))) {
            return false;
        }
        if (input.length() > 1) {
            for (int i = 1; i < input.length(); ++i) {
                if (Character.isJavaIdentifierPart(input.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static String cleanForJavadoc(String input) {
        return NamingHelper.cleanLeadingAndTrailingNewLineAndChars(input);
    }

    public static String cleanLeadingAndTrailingNewLineAndChars(String input) {
        if (!org.springframework.util.StringUtils.hasText((String)input)) {
            return input;
        }
        String output = input;
        output = output.replaceAll("[\\s]+\\*[\\s]+", " ");
        while (output.startsWith("/") || output.startsWith("\n") || output.startsWith("*") || output.startsWith("-") || output.startsWith("\t") || output.startsWith(" ") || output.startsWith("\\")) {
            output = output.substring(1);
        }
        while (output.endsWith("/") || output.endsWith("\n") || output.endsWith(" ") || output.endsWith(",") || output.endsWith("\t") || output.endsWith("-") || output.endsWith("*")) {
            output = output.substring(0, output.length() - 1);
        }
        return output;
    }

    public static String convertToClassName(String clazz) {
        return org.springframework.util.StringUtils.capitalize((String)NamingHelper.cleanNameForJava(clazz));
    }

    public static String getResourceName(RamlResource resource, boolean singularize) {
        String url = resource.getRelativeUri();
        if (org.springframework.util.StringUtils.hasText((String)url) && url.contains("/") && url.lastIndexOf("/") < url.length()) {
            return NamingHelper.getResourceName(url.substring(url.lastIndexOf("/") + 1), singularize);
        }
        return null;
    }

    public static String getAllResourcesNames(String url, boolean singularize, int resourceDepthInClassNames, int resourceTopLevelInClassNames, boolean reverseOrderInClassNames) {
        StringBuilder stringBuilder = new StringBuilder();
        if (org.springframework.util.StringUtils.hasText((String)url)) {
            String[] resources = SLASH.split(url);
            int lengthCounter = 0;
            for (int i = resources.length - 1; i >= resourceTopLevelInClassNames + 1; --i) {
                if (org.springframework.util.StringUtils.hasText((String)resources[i])) {
                    String resourceName = NamingHelper.getResourceName(resources[i], singularize);
                    if (reverseOrderInClassNames) {
                        stringBuilder.append(resourceName);
                    } else {
                        stringBuilder.insert(0, resourceName);
                    }
                    ++lengthCounter;
                }
                if (resourceDepthInClassNames > 0 && lengthCounter >= resourceDepthInClassNames) break;
            }
        }
        return stringBuilder.toString();
    }

    public static String getResourceName(String resource, boolean singularize) {
        if (org.springframework.util.StringUtils.hasText((String)resource)) {
            String resourceName = org.springframework.util.StringUtils.capitalize((String)resource);
            if (singularize) {
                resourceName = NamingHelper.singularize(resourceName);
            }
            resourceName = org.springframework.util.StringUtils.capitalize((String)NamingHelper.cleanNameForJava(resourceName));
            return resourceName;
        }
        return null;
    }

    public static String singularize(String target) {
        String result = Inflector.singularize((String)target);
        if (target.endsWith("ss") && result.equals(target.substring(0, target.length() - 1))) {
            result = target;
        }
        return result;
    }

    public static String pluralize(String target) {
        if (target.endsWith("s")) {
            return target;
        }
        return Inflector.pluralize((String)target);
    }

    public static String getParameterName(String name) {
        return org.springframework.util.StringUtils.uncapitalize((String)NamingHelper.cleanNameForJava(name));
    }

    public static String cleanNameForJava(String resourceName) {
        String outString = resourceName;
        if (org.springframework.util.StringUtils.hasText((String)resourceName) && org.springframework.util.StringUtils.hasText((String)(outString = NamingHelper.getNameHelper().normalizeName(resourceName)))) {
            outString = outString.replaceAll(ILLEGAL_CHARACTER_REGEX, "");
        }
        return outString;
    }

    public static String cleanNameForJavaEnum(String enumConstant) {
        if (!org.springframework.util.StringUtils.hasText((String)enumConstant)) {
            return enumConstant;
        }
        ArrayList<String> nameGroups = new ArrayList<String>(Arrays.asList(StringUtils.splitByCharacterTypeCamelCase((String)enumConstant)));
        nameGroups.removeIf(s -> StringUtils.containsOnly((CharSequence)s.replaceAll(ILLEGAL_CHARACTER_REGEX, "_"), (String)"_"));
        String enumName = StringUtils.upperCase((String)StringUtils.join(nameGroups, (String)"_"));
        if (StringUtils.isEmpty((CharSequence)enumName)) {
            enumName = "_DEFAULT_";
        } else if (Character.isDigit(enumName.charAt(0))) {
            enumName = "_" + enumName;
        }
        return enumName;
    }

    private static boolean doesUriEndsWithParam(String uri) {
        if (org.springframework.util.StringUtils.isEmpty((Object)uri)) {
            return false;
        }
        String subUri = uri;
        if (uri.lastIndexOf(47) > -1) {
            subUri = uri.substring(uri.lastIndexOf(47) + 1);
        }
        return subUri.startsWith("{") && subUri.endsWith("}");
    }

    public static String getActionName(ApiActionMetadata apiActionMetadata) {
        String uri = apiActionMetadata.getResource().getUri();
        String name = NamingHelper.convertActionTypeToIntent(apiActionMetadata.getActionType(), NamingHelper.doesUriEndsWithParam(uri));
        if (apiActionMetadata.getActionType().equals((Object)RamlActionType.GET)) {
            Map<String, ApiBodyMetadata> responseBody = apiActionMetadata.getResponseBody();
            if (responseBody.size() > 0) {
                ApiBodyMetadata apiBodyMetadata = responseBody.values().iterator().next();
                String responseObjectName = NamingHelper.cleanNameForJava(org.springframework.util.StringUtils.capitalize((String)apiBodyMetadata.getName()));
                if (apiBodyMetadata.isArray()) {
                    responseObjectName = org.springframework.util.StringUtils.capitalize((String)NamingHelper.pluralize(responseObjectName));
                }
                name = name + responseObjectName;
            } else {
                name = name + "Object";
            }
            List<ApiParameterMetadata> parameterMetadataList = NamingHelper.getParameters(apiActionMetadata);
            if (!parameterMetadataList.isEmpty()) {
                name = name + "By";
                if (parameterMetadataList.size() == 1) {
                    ApiParameterMetadata paramMetaData = parameterMetadataList.iterator().next();
                    name = name + org.springframework.util.StringUtils.capitalize((String)NamingHelper.cleanNameForJava(paramMetaData.getDisplayName() != null ? paramMetaData.getDisplayName() : paramMetaData.getName()));
                }
            }
        } else if (apiActionMetadata.getActionType().equals((Object)RamlActionType.DELETE)) {
            List<ApiParameterMetadata> parameterMetadataList = NamingHelper.getParameters(apiActionMetadata);
            if (!parameterMetadataList.isEmpty()) {
                name = name + "By";
                if (parameterMetadataList.size() == 1) {
                    name = name + NamingHelper.cleanNameForJava(org.springframework.util.StringUtils.capitalize((String)parameterMetadataList.iterator().next().getName()));
                }
            }
        } else {
            String creationObject;
            ApiBodyMetadata requestBody = apiActionMetadata.getRequestBody();
            if (requestBody != null) {
                creationObject = requestBody.getName();
            } else {
                creationObject = apiActionMetadata.getParent().getResourceUri();
                creationObject = creationObject.substring(creationObject.lastIndexOf(47) + 1);
            }
            return name + NamingHelper.cleanNameForJava(org.springframework.util.StringUtils.capitalize((String)creationObject));
        }
        return name;
    }

    private static List<ApiParameterMetadata> getParameters(ApiActionMetadata apiActionMetadata) {
        ArrayList<ApiParameterMetadata> parameterMetadataList = new ArrayList<ApiParameterMetadata>();
        parameterMetadataList.addAll(apiActionMetadata.getPathVariables());
        parameterMetadataList.addAll(apiActionMetadata.getRequestParameters());
        parameterMetadataList.addAll(apiActionMetadata.getRequestHeaders());
        return parameterMetadataList;
    }

    public static String getActionName(RamlResource controllerizedResource, RamlResource resource, RamlActionType actionType) {
        String url = resource.getUri();
        if (controllerizedResource != resource && org.springframework.util.StringUtils.countOccurrencesOf((String)url, (String)"{") < org.springframework.util.StringUtils.countOccurrencesOf((String)url, (String)"/") - 1) {
            url = NamingHelper.reduceToResourceNameAndId(url);
        }
        if (org.springframework.util.StringUtils.hasText((String)url)) {
            String[] splitUrl = SLASH.split(url);
            String name = "";
            int numberOfIdsParsed = 0;
            boolean singularizeNext = false;
            boolean isIdInPath = false;
            for (int index = splitUrl.length - 1; numberOfIdsParsed < 2 && index >= 0; --index) {
                String segment = splitUrl[index];
                if (segment.contains("{") && segment.contains("}")) {
                    if (index > 0 && index == splitUrl.length - 1) {
                        isIdInPath = true;
                        if (segment.startsWith("{") && segment.endsWith("}")) {
                            String peek = splitUrl[index - 1].toLowerCase();
                            name = "By" + org.springframework.util.StringUtils.capitalize((String)StringUtils.difference((String)peek, (String)segment.substring(1, segment.length() - 1)));
                        } else {
                            String[] split = segment.split("[{}]");
                            name = "By";
                            for (String segmentPart : split) {
                                name = name + org.springframework.util.StringUtils.capitalize((String)segmentPart);
                            }
                        }
                    }
                    singularizeNext = true;
                    continue;
                }
                segment = NamingHelper.cleanNameForJava(segment);
                if (singularizeNext) {
                    name = !segment.endsWith("details") ? NamingHelper.singularize(org.springframework.util.StringUtils.capitalize((String)segment)) + name : org.springframework.util.StringUtils.capitalize((String)segment) + name;
                    singularizeNext = false;
                } else {
                    name = org.springframework.util.StringUtils.capitalize((String)segment) + name;
                }
                ++numberOfIdsParsed;
            }
            String tail = splitUrl[splitUrl.length - 1];
            String prefix = NamingHelper.convertActionTypeToIntent(actionType, isIdInPath);
            if (!NamingHelper.singularize(tail).equals(tail) && !tail.endsWith("details") && (RamlActionType.POST.equals((Object)actionType) || RamlActionType.PUT.equals((Object)actionType) && isIdInPath)) {
                name = NamingHelper.singularize(name);
            }
            return prefix + name;
        }
        return null;
    }

    private static String reduceToResourceNameAndId(String url) {
        String[] splitUrl = SLASH.split(url);
        String slash = "/";
        return slash + splitUrl[splitUrl.length - 2] + slash + splitUrl[splitUrl.length - 1];
    }

    private static String convertActionTypeToIntent(RamlActionType actionType, boolean isIdInPath) {
        switch (actionType) {
            case DELETE: {
                return "delete";
            }
            case GET: {
                return "get";
            }
            case POST: {
                if (!isIdInPath) {
                    return "create";
                }
            }
            case PUT: {
                return "update";
            }
            case PATCH: {
                return "modify";
            }
        }
        return "do";
    }

    public static String getDefaultModelPackage() {
        return ".model";
    }
}

