/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlplugin.raml2code.interpreters;

import com.phoenixnap.oss.ramlplugin.raml2code.helpers.CodeModelHelper;
import com.phoenixnap.oss.ramlplugin.raml2code.interpreters.BaseTypeInterpreter;
import com.phoenixnap.oss.ramlplugin.raml2code.interpreters.RamlInterpretationResult;
import com.phoenixnap.oss.ramlplugin.raml2code.interpreters.RamlInterpreterFactory;
import com.phoenixnap.oss.ramlplugin.raml2code.interpreters.RamlTypeValidations;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlRoot;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.raml.v2.api.model.v10.datamodel.ArrayTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.springframework.util.StringUtils;

public class ArrayTypeInterpreter
extends BaseTypeInterpreter {
    @Override
    public Set<Class<? extends TypeDeclaration>> getSupportedTypes() {
        return Collections.singleton(ArrayTypeDeclaration.class);
    }

    @Override
    public RamlInterpretationResult interpret(RamlRoot document, TypeDeclaration type, JCodeModel builderModel, boolean property) {
        RamlInterpretationResult result = new RamlInterpretationResult(type.required());
        this.typeCheck(type);
        if (type instanceof ArrayTypeDeclaration) {
            ArrayTypeDeclaration arrayType = (ArrayTypeDeclaration)type;
            RamlTypeValidations validations = result.getValidations();
            validations.withLenghts(arrayType.minItems(), arrayType.maxItems());
            if (builderModel != null) {
                JClass searchedClass;
                String arrayItem = arrayType.items().name();
                if (!StringUtils.isEmpty((Object)arrayItem) && arrayItem.endsWith("[]")) {
                    arrayItem = arrayItem.substring(0, arrayItem.length() - 2);
                }
                if (!(searchedClass = CodeModelHelper.findFirstClassBySimpleName(builderModel, arrayItem)).getClass().getSimpleName().contains("JDirectClass")) {
                    JClass collection = this.resolveCollectionClass(arrayType, searchedClass, builderModel);
                    result.setCodeModel(builderModel);
                    result.setResolvedClass(collection);
                    return result;
                }
            } else {
                builderModel = new JCodeModel();
                result.setCodeModel(builderModel);
            }
            TypeDeclaration arrayContentsType = arrayType.items();
            RamlInterpretationResult childResult = RamlInterpreterFactory.getInterpreterForType(arrayContentsType).interpret(document, arrayContentsType, builderModel, false);
            JClass collection = this.resolveCollectionClass(arrayType, childResult.getResolvedClassOrBuiltOrObject(), builderModel);
            result.setResolvedClass(collection);
        }
        return result;
    }

    private JClass resolveCollectionClass(ArrayTypeDeclaration arrayType, JClass resolvedClass, JCodeModel builderModel) {
        Class container = List.class;
        if (arrayType.uniqueItems() != null && arrayType.uniqueItems().booleanValue()) {
            container = Set.class;
        }
        return builderModel.ref(container).narrow(resolvedClass);
    }
}

