/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlplugin.raml2code.interpreters;

import com.phoenixnap.oss.ramlplugin.raml2code.helpers.CodeModelHelper;
import com.phoenixnap.oss.ramlplugin.raml2code.helpers.SchemaHelper;
import com.phoenixnap.oss.ramlplugin.raml2code.interpreters.BaseTypeInterpreter;
import com.phoenixnap.oss.ramlplugin.raml2code.interpreters.RamlInterpretationResult;
import com.phoenixnap.oss.ramlplugin.raml2code.interpreters.RamlTypeValidations;
import com.phoenixnap.oss.ramlplugin.raml2code.plugin.Config;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlParamType;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlRoot;
import com.sun.codemodel.JCodeModel;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Set;
import org.raml.v2.api.model.v10.datamodel.IntegerTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.NumberTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.springframework.util.StringUtils;

public class NumberTypeInterpreter
extends BaseTypeInterpreter {
    @Override
    public Set<Class<? extends TypeDeclaration>> getSupportedTypes() {
        return Collections.singleton(NumberTypeDeclaration.class);
    }

    @Override
    public RamlInterpretationResult interpret(RamlRoot document, TypeDeclaration type, JCodeModel builderModel, boolean property) {
        RamlInterpretationResult result = new RamlInterpretationResult(type.required());
        String resolvedType = String.class.getSimpleName();
        this.typeCheck(type);
        if (type instanceof NumberTypeDeclaration) {
            NumberTypeDeclaration numberType = (NumberTypeDeclaration)type;
            String format = numberType.format();
            RamlTypeValidations validations = result.getValidations();
            validations.withMinMax(numberType.minimum(), numberType.maximum());
            resolvedType = !StringUtils.hasText((String)format) ? (type instanceof IntegerTypeDeclaration ? Long.class.getSimpleName() : Double.class.getSimpleName()) : SchemaHelper.mapSimpleType(RamlParamType.NUMBER, format).getSimpleName();
        }
        if (resolvedType.equals(Double.class.getSimpleName()) && Config.getPojoConfig().isUseBigDecimals()) {
            resolvedType = BigDecimal.class.getName();
        }
        if (resolvedType.equals(Long.class.getSimpleName()) && Config.getPojoConfig().isUseBigIntegers()) {
            resolvedType = BigInteger.class.getName();
        }
        result.setResolvedClass(CodeModelHelper.findFirstClassBySimpleName(builderModel, resolvedType));
        return result;
    }
}

