/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlplugin.raml2code.interpreters;

import com.phoenixnap.oss.ramlplugin.raml2code.interpreters.AnyTypeInterpreter;
import com.phoenixnap.oss.ramlplugin.raml2code.interpreters.ArrayTypeInterpreter;
import com.phoenixnap.oss.ramlplugin.raml2code.interpreters.BooleanTypeInterpreter;
import com.phoenixnap.oss.ramlplugin.raml2code.interpreters.DateTypeInterpreter;
import com.phoenixnap.oss.ramlplugin.raml2code.interpreters.FileTypeInterpreter;
import com.phoenixnap.oss.ramlplugin.raml2code.interpreters.NullTypeInterpreter;
import com.phoenixnap.oss.ramlplugin.raml2code.interpreters.NumberTypeInterpreter;
import com.phoenixnap.oss.ramlplugin.raml2code.interpreters.ObjectTypeInterpreter;
import com.phoenixnap.oss.ramlplugin.raml2code.interpreters.RamlTypeInterpreter;
import com.phoenixnap.oss.ramlplugin.raml2code.interpreters.StringTypeInterpreter;
import com.phoenixnap.oss.ramlplugin.raml2code.interpreters.UnionTypeInterpreter;
import java.util.LinkedHashMap;
import java.util.Map;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RamlInterpreterFactory {
    protected static final Logger logger = LoggerFactory.getLogger(RamlInterpreterFactory.class);
    static RamlTypeInterpreter DEFAULT_INTERPRETER = new StringTypeInterpreter();
    static RamlTypeInterpreter[] SUPPORTED_INTERPRETERS = new RamlTypeInterpreter[]{new ObjectTypeInterpreter(), new BooleanTypeInterpreter(), new NullTypeInterpreter(), new NumberTypeInterpreter(), new ArrayTypeInterpreter(), new AnyTypeInterpreter(), new FileTypeInterpreter(), new DateTypeInterpreter(), new UnionTypeInterpreter(), DEFAULT_INTERPRETER};
    private static Map<Class<? extends TypeDeclaration>, RamlTypeInterpreter> interpreters = new LinkedHashMap<Class<? extends TypeDeclaration>, RamlTypeInterpreter>();
    private static Map<Class<? extends TypeDeclaration>, RamlTypeInterpreter> interpreterCache = new LinkedHashMap<Class<? extends TypeDeclaration>, RamlTypeInterpreter>();

    private static String identifyByClass(Object obj) {
        if (obj instanceof Class) {
            return ((Class)obj).getSimpleName();
        }
        return obj.getClass().getSimpleName();
    }

    public static RamlTypeInterpreter getInterpreterForType(TypeDeclaration type) {
        RamlTypeInterpreter interpreter = interpreterCache.get(RamlInterpreterFactory.identifyByClass(type));
        if (interpreter != null) {
            return interpreter;
        }
        for (Class<? extends TypeDeclaration> key : interpreters.keySet()) {
            if (!key.isAssignableFrom(type.getClass())) continue;
            interpreter = interpreters.get(key);
            interpreterCache.put(type.getClass(), interpreter);
            break;
        }
        if (interpreter == null) {
            logger.error("Missing Interpreter for type " + RamlInterpreterFactory.identifyByClass(type) + ":" + type.type());
            interpreter = DEFAULT_INTERPRETER;
        }
        return interpreter;
    }

    static {
        for (RamlTypeInterpreter interpreter : SUPPORTED_INTERPRETERS) {
            for (Class<? extends TypeDeclaration> type : interpreter.getSupportedTypes()) {
                if (interpreters.containsKey(type)) {
                    logger.warn("Overwriting Interpreter " + interpreters.get(type) + " with " + RamlInterpreterFactory.identifyByClass(interpreter) + " for type " + type.getSimpleName());
                }
                interpreters.put(type, interpreter);
                logger.info("Adding Interpreter " + RamlInterpreterFactory.identifyByClass(interpreter) + " for type " + type.getSimpleName());
            }
        }
    }
}

