/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlplugin.raml2code.rules;

import com.google.common.base.CaseFormat;
import com.phoenixnap.oss.ramlplugin.raml2code.data.ApiActionMetadata;
import com.phoenixnap.oss.ramlplugin.raml2code.data.ApiResourceMetadata;
import com.phoenixnap.oss.ramlplugin.raml2code.helpers.RamlHelper;
import com.phoenixnap.oss.ramlplugin.raml2code.rules.ConfigurableRule;
import com.phoenixnap.oss.ramlplugin.raml2code.rules.GenericJavaClassRule;
import com.phoenixnap.oss.ramlplugin.raml2code.rules.basic.ClassAnnotationRule;
import com.phoenixnap.oss.ramlplugin.raml2code.rules.basic.ClassCommentRule;
import com.phoenixnap.oss.ramlplugin.raml2code.rules.basic.ClassFieldDeclarationRule;
import com.phoenixnap.oss.ramlplugin.raml2code.rules.basic.ClientInterfaceDeclarationRule;
import com.phoenixnap.oss.ramlplugin.raml2code.rules.basic.ControllerMethodSignatureRule;
import com.phoenixnap.oss.ramlplugin.raml2code.rules.basic.ImplementsControllerInterfaceRule;
import com.phoenixnap.oss.ramlplugin.raml2code.rules.basic.MethodCommentRule;
import com.phoenixnap.oss.ramlplugin.raml2code.rules.basic.MethodParamsRule;
import com.phoenixnap.oss.ramlplugin.raml2code.rules.basic.PackageRule;
import com.phoenixnap.oss.ramlplugin.raml2code.rules.basic.ResourceClassDeclarationRule;
import com.phoenixnap.oss.ramlplugin.raml2code.rules.spring.SpringResponseEntityRule;
import com.phoenixnap.oss.ramlplugin.raml2code.rules.spring.SpringRestClientMethodBodyRule;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class Spring4RestTemplateClientRule
implements ConfigurableRule<JCodeModel, JDefinedClass, ApiResourceMetadata> {
    public static final String ARRAY_PARAMETER_CONFIGURATION = "allowArrayParameters";
    String restTemplateFieldName = "restTemplate";
    String baseUrlFieldName = "baseUrl";
    String baseUrlConfigurationPath = "${client.url}";
    String restTemplateQualifierBeanName;
    boolean allowArrayParameters = true;

    @Override
    public final JDefinedClass apply(ApiResourceMetadata metadata, JCodeModel generatableType) {
        List<String> grants = new ArrayList<String>();
        Set<ApiActionMetadata> apiCalls = metadata.getApiCalls();
        for (ApiActionMetadata actionMetadata : apiCalls) {
            String grant = RamlHelper.getFirstAuthorizationGrant(actionMetadata.getAction(), actionMetadata.getParent().getDocument());
            if (StringUtils.isEmpty((Object)grant)) continue;
            grants.add(grant);
        }
        grants = RamlHelper.removeDuplicates(grants);
        JDefinedClass generatedInterface = new GenericJavaClassRule().setPackageRule(new PackageRule()).setClassCommentRule(new ClassCommentRule()).setClassRule(new ClientInterfaceDeclarationRule()).setMethodCommentRule(new MethodCommentRule()).setMethodSignatureRule(new ControllerMethodSignatureRule(new SpringResponseEntityRule(), new MethodParamsRule(true, this.allowArrayParameters))).apply(metadata, generatableType);
        GenericJavaClassRule clientGenerator = new GenericJavaClassRule().setPackageRule(new PackageRule()).setClassCommentRule(new ClassCommentRule()).addClassAnnotationRule(new ClassAnnotationRule(Component.class)).setClassRule(new ResourceClassDeclarationRule("ClientImpl")).setImplementsExtendsRule(new ImplementsControllerInterfaceRule(generatedInterface)).addFieldDeclarationRule(new ClassFieldDeclarationRule(this.baseUrlFieldName, String.class, this.getBaseUrlConfigurationName())).setMethodCommentRule(new MethodCommentRule()).setMethodSignatureRule(new ControllerMethodSignatureRule(new SpringResponseEntityRule(), new MethodParamsRule(false, this.allowArrayParameters))).setMethodBodyRule(new SpringRestClientMethodBodyRule(this.restTemplateFieldName, this.baseUrlFieldName));
        if (grants.isEmpty()) {
            clientGenerator.addFieldDeclarationRule(new ClassFieldDeclarationRule(this.restTemplateFieldName, RestTemplate.class, true, this.restTemplateQualifierBeanName));
        } else {
            for (String grant : grants) {
                grant = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, grant);
                clientGenerator.addFieldDeclarationRule(new ClassFieldDeclarationRule(grant + StringUtils.capitalize((String)this.restTemplateFieldName), RestTemplate.class, true, StringUtils.isEmpty((Object)this.restTemplateQualifierBeanName) ? null : this.restTemplateQualifierBeanName + grant));
            }
        }
        return clientGenerator.apply(metadata, generatableType);
    }

    private String getBaseUrlConfigurationName() {
        if (!this.baseUrlConfigurationPath.startsWith("${")) {
            this.baseUrlConfigurationPath = "${" + this.baseUrlConfigurationPath;
        }
        if (!this.baseUrlConfigurationPath.endsWith("}")) {
            this.baseUrlConfigurationPath = this.baseUrlConfigurationPath + "}";
        }
        return this.baseUrlConfigurationPath;
    }

    @Override
    public void applyConfiguration(Map<String, String> configuration) {
        if (!CollectionUtils.isEmpty(configuration)) {
            if (configuration.containsKey("restTemplateFieldName")) {
                this.restTemplateFieldName = configuration.get("restTemplateFieldName");
            }
            if (configuration.containsKey("restTemplateQualifierBeanName")) {
                this.restTemplateQualifierBeanName = configuration.get("restTemplateQualifierBeanName");
            }
            if (configuration.containsKey("baseUrlConfigurationPath")) {
                this.baseUrlConfigurationPath = configuration.get("baseUrlConfigurationPath");
            }
            if (configuration.containsKey(ARRAY_PARAMETER_CONFIGURATION)) {
                this.allowArrayParameters = BooleanUtils.toBoolean((String)configuration.get(ARRAY_PARAMETER_CONFIGURATION));
            }
        }
    }
}

