/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlplugin.raml2code.rules.spring;

import com.phoenixnap.oss.ramlplugin.raml2code.data.ApiResourceMetadata;
import com.phoenixnap.oss.ramlplugin.raml2code.rules.ConfigurableRule;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.util.CollectionUtils;

public abstract class SpringConfigurableRule
implements ConfigurableRule<JCodeModel, JDefinedClass, ApiResourceMetadata> {
    public static final String CALLABLE_RESPONSE_CONFIGURATION = "callableResponse";
    public static final String PARAMETER_JAVADOC_CONFIGURATION = "addParameterJavadoc";
    public static final String ARRAY_PARAMETER_CONFIGURATION = "allowArrayParameters";
    public static final String SIMPLE_RETURN_TYPES = "simpleReturnTypes";
    public static final String SHORTCUT_METHOD_MAPPINGS = "useShortcutMethodMappings";
    private boolean callableResponse = false;
    private boolean addParameterJavadoc = false;
    private boolean allowArrayParameters = true;
    private boolean simpleReturnTypes = false;
    private boolean useShortcutMethodMappings = false;

    @Override
    public void applyConfiguration(Map<String, String> configuration) {
        if (!CollectionUtils.isEmpty(configuration)) {
            if (configuration.containsKey(CALLABLE_RESPONSE_CONFIGURATION)) {
                this.setCallableResponse(BooleanUtils.toBoolean((String)configuration.get(CALLABLE_RESPONSE_CONFIGURATION)));
            }
            if (configuration.containsKey(PARAMETER_JAVADOC_CONFIGURATION)) {
                this.setAddParameterJavadoc(BooleanUtils.toBoolean((String)configuration.get(PARAMETER_JAVADOC_CONFIGURATION)));
            }
            if (configuration.containsKey(ARRAY_PARAMETER_CONFIGURATION)) {
                this.setAllowArrayParameters(BooleanUtils.toBoolean((String)configuration.get(ARRAY_PARAMETER_CONFIGURATION)));
            }
        }
    }

    public boolean isAddParameterJavadoc() {
        return this.addParameterJavadoc;
    }

    public void setAddParameterJavadoc(boolean addParameterJavadoc) {
        this.addParameterJavadoc = addParameterJavadoc;
    }

    public boolean isAllowArrayParameters() {
        return this.allowArrayParameters;
    }

    public void setAllowArrayParameters(boolean allowArrayParameters) {
        this.allowArrayParameters = allowArrayParameters;
    }

    public boolean isCallableResponse() {
        return this.callableResponse;
    }

    public void setCallableResponse(boolean callableResponse) {
        this.callableResponse = callableResponse;
    }

    public boolean isUseShortcutMethodMappings() {
        return this.useShortcutMethodMappings;
    }

    public void setUseShortcutMethodMappings(boolean useShortcutMethodMappings) {
        this.useShortcutMethodMappings = useShortcutMethodMappings;
    }

    public boolean isSimpleReturnTypes() {
        return this.simpleReturnTypes;
    }

    public void setSimpleReturnTypes(boolean simpleReturnTypes) {
        this.simpleReturnTypes = simpleReturnTypes;
    }
}

