/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlplugin.raml2code.rules.spring;

import com.phoenixnap.oss.ramlplugin.raml2code.data.ApiActionMetadata;
import com.phoenixnap.oss.ramlplugin.raml2code.data.ApiBodyMetadata;
import com.phoenixnap.oss.ramlplugin.raml2code.helpers.CodeModelHelper;
import com.phoenixnap.oss.ramlplugin.raml2code.rules.Rule;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JType;
import java.util.List;
import org.springframework.http.ResponseEntity;

public class SpringSimpleResponseTypeRule
implements Rule<JDefinedClass, JType, ApiActionMetadata> {
    @Override
    public JType apply(ApiActionMetadata endpointMetadata, JDefinedClass generatableType) {
        JClass responseType = generatableType.owner().ref(ResponseEntity.class);
        if (!endpointMetadata.getResponseBody().isEmpty()) {
            ApiBodyMetadata apiBodyMetadata = endpointMetadata.getResponseBody().values().iterator().next();
            JClass genericType = CodeModelHelper.findFirstClassBySimpleName(apiBodyMetadata.getCodeModel(), apiBodyMetadata.getName());
            if (apiBodyMetadata.isArray()) {
                JClass arrayType = generatableType.owner().ref(List.class);
                return arrayType.narrow(genericType);
            }
            return genericType;
        }
        return responseType.narrow(generatableType.owner().wildcard());
    }
}

