/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlplugin.raml2code.data;

import com.phoenixnap.oss.ramlplugin.raml2code.helpers.NamingHelper;
import com.phoenixnap.oss.ramlplugin.raml2code.helpers.SchemaHelper;
import com.phoenixnap.oss.ramlplugin.raml2code.plugin.Config;
import com.phoenixnap.oss.ramlplugin.raml2code.plugin.SpringMvcEndpointGeneratorMojo;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlAbstractParam;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlUriParameter;
import com.sun.codemodel.JCodeModel;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.NullArgumentException;
import org.raml.v2.api.model.v10.declarations.AnnotationRef;
import org.springframework.util.StringUtils;

public class ApiParameterMetadata {
    private String name;
    private RamlAbstractParam ramlParam;
    private Class<?> type;
    private String format;
    private boolean nullable;
    private boolean resourceId;
    private String example;
    private String displayName;
    private JCodeModel codeModel;

    public ApiParameterMetadata(String name, RamlAbstractParam param, JCodeModel codeModel) {
        if (param == null) {
            throw new NullArgumentException("param");
        }
        this.resourceId = param instanceof RamlUriParameter;
        this.nullable = !param.isRequired();
        this.name = name;
        this.displayName = param.getDisplayName();
        this.format = param.getFormat();
        this.type = SchemaHelper.mapSimpleType(param.getType(), this.format, param.getRawType());
        if (param.isRepeat()) {
            this.type = Array.newInstance(this.type, 0).getClass();
        }
        this.example = StringUtils.hasText((String)param.getExample()) ? param.getExample() : null;
        this.setRamlParam(param);
        this.codeModel = codeModel;
    }

    public Class<?> getType() {
        return this.type;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isResourceId() {
        return this.resourceId;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getExample() {
        return this.example;
    }

    public String toString() {
        return "ApiParameterMetadata [name=" + this.name + ", type=" + this.type + "]";
    }

    public RamlAbstractParam getRamlParam() {
        return this.ramlParam;
    }

    private void setRamlParam(RamlAbstractParam ramlParam) {
        this.ramlParam = ramlParam;
    }

    public boolean isArray() {
        if (this.type == null) {
            return false;
        }
        return this.type.isArray() || List.class.isAssignableFrom(this.type) || Set.class.isAssignableFrom(this.type);
    }

    public JCodeModel getCodeModel() {
        return this.codeModel;
    }

    public List<AnnotationRef> getAnnotations() {
        return this.ramlParam.getAnnotations();
    }

    public String getJavaName() {
        String javaName = null;
        if (Config.getOverrideNamingLogicWith() == SpringMvcEndpointGeneratorMojo.OverrideNamingLogicWith.DISPLAY_NAME && !StringUtils.isEmpty((Object)this.getDisplayName())) {
            javaName = NamingHelper.getParameterName(this.getDisplayName());
        } else if (Config.getOverrideNamingLogicWith() == SpringMvcEndpointGeneratorMojo.OverrideNamingLogicWith.ANNOTATION) {
            for (AnnotationRef annotation : this.getAnnotations()) {
                if (!"(javaName)".equals(annotation.name())) continue;
                javaName = String.valueOf(annotation.structuredValue().value());
                break;
            }
        }
        if (StringUtils.isEmpty(javaName)) {
            javaName = NamingHelper.getParameterName(this.getName());
        }
        return javaName;
    }
}

