/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlplugin.raml2code.data;

import com.phoenixnap.oss.ramlplugin.raml2code.data.ApiActionMetadata;
import com.phoenixnap.oss.ramlplugin.raml2code.data.ApiBodyMetadata;
import com.phoenixnap.oss.ramlplugin.raml2code.data.ApiParameterMetadata;
import com.phoenixnap.oss.ramlplugin.raml2code.helpers.NamingHelper;
import com.phoenixnap.oss.ramlplugin.raml2code.plugin.Config;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlAction;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlActionType;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlResource;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlRoot;
import com.sun.codemodel.JCodeModel;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class ApiResourceMetadata {
    private String controllerUrl;
    private transient RamlResource resource;
    private RamlRoot document;
    private boolean singularizeName = true;
    private JCodeModel bodyCodeModel;
    Set<ApiActionMetadata> apiCalls = new LinkedHashSet<ApiActionMetadata>();

    public ApiResourceMetadata(JCodeModel bodyCodeModel, String controllerUrl, RamlResource resource, RamlRoot document) {
        this.controllerUrl = controllerUrl;
        this.resource = resource;
        this.document = document;
        this.bodyCodeModel = bodyCodeModel;
    }

    public void addApiCall(RamlResource resource, RamlActionType actionType, RamlAction action, String responseContentType) {
        this.apiCalls.add(new ApiActionMetadata(this, resource, actionType, action, responseContentType));
    }

    public Set<ApiActionMetadata> getApiCalls() {
        return Collections.unmodifiableSet(this.apiCalls);
    }

    public String getName() {
        if (Config.getResourceDepthInClassNames() != 1 || Config.getResourceTopLevelInClassNames() != 0 || Config.isReverseOrderInClassNames().booleanValue()) {
            return NamingHelper.getAllResourcesNames(this.controllerUrl, this.singularizeName);
        }
        return NamingHelper.getResourceName(this.resource, this.singularizeName);
    }

    public RamlResource getResource() {
        return this.resource;
    }

    public String getResourceName() {
        return NamingHelper.getResourceName(this.resource, this.singularizeName);
    }

    public String getResourceUri() {
        return this.resource.getUri();
    }

    public String getControllerUrl() {
        return this.controllerUrl;
    }

    public String toString() {
        return "Controller " + this.getName() + "[" + this.getControllerUrl() + "]";
    }

    public Set<ApiBodyMetadata> getDependencies() {
        LinkedHashSet<ApiBodyMetadata> dependencies = new LinkedHashSet<ApiBodyMetadata>();
        for (ApiActionMetadata method : this.apiCalls) {
            if (method.getRequestBody() != null) {
                dependencies.add(method.getRequestBody());
            }
            dependencies.addAll(method.getResponseBody().values());
        }
        return dependencies;
    }

    public Set<ApiParameterMetadata> getParameters() {
        LinkedHashSet<ApiParameterMetadata> parameters = new LinkedHashSet<ApiParameterMetadata>();
        for (ApiActionMetadata method : this.apiCalls) {
            parameters.addAll(method.getRequestHeaders());
            parameters.addAll(method.getRequestParameters());
        }
        return parameters;
    }

    public String getDescription() {
        return this.resource.getDescription();
    }

    public RamlRoot getDocument() {
        return this.document;
    }

    public void setSingularizeName(boolean singularizeName) {
        this.singularizeName = singularizeName;
    }

    public JCodeModel getBodyCodeModel() {
        return this.bodyCodeModel;
    }
}

