/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlplugin.raml2code.helpers;

import com.phoenixnap.oss.ramlplugin.raml2code.data.ApiActionMetadata;
import com.phoenixnap.oss.ramlplugin.raml2code.data.ApiBodyMetadata;
import com.phoenixnap.oss.ramlplugin.raml2code.data.ApiParameterMetadata;
import com.phoenixnap.oss.ramlplugin.raml2code.helpers.SchemaHelper;
import com.phoenixnap.oss.ramlplugin.raml2code.plugin.Config;
import com.phoenixnap.oss.ramlplugin.raml2code.plugin.SpringMvcEndpointGeneratorMojo;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlActionType;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlResource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsonschema2pojo.util.NameHelper;
import org.raml.v2.api.model.v10.declarations.AnnotationRef;
import org.raml.v2.internal.utils.Inflector;
import org.springframework.util.StringUtils;

public class NamingHelper {
    private static final Pattern CONTENT_TYPE_VERSION = Pattern.compile("[^v]*(v[\\d\\.]*).*", 2);
    private static final Pattern SLASH = Pattern.compile("/");
    private static final String ILLEGAL_CHARACTER_REGEX = "[^0-9a-zA-Z_$]";
    private static final String[] KEYWORDS = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    private static List<String> keywordsList;
    private static NameHelper cachedNameHelper;

    private static NameHelper getNameHelper() {
        if (cachedNameHelper != null) {
            return cachedNameHelper;
        }
        cachedNameHelper = new NameHelper(SchemaHelper.getDefaultGenerationConfig());
        return cachedNameHelper;
    }

    public static String convertContentTypeToQualifier(String contentType) {
        String version;
        if (contentType.equals("application/json")) {
            return "AsJson";
        }
        if (contentType.equals("application/octet-stream")) {
            return "AsBinary";
        }
        if (contentType.equals("text/plain") || contentType.equals("text/html")) {
            return "AsText";
        }
        Matcher versionMatcher = CONTENT_TYPE_VERSION.matcher(contentType);
        if (versionMatcher.find() && (version = versionMatcher.group(1)) != null) {
            return StringUtils.capitalize((String)version).replace(".", "_");
        }
        int seperatorIndex = contentType.indexOf("/");
        if (seperatorIndex != -1 && seperatorIndex < contentType.length()) {
            String candidate = contentType.substring(seperatorIndex + 1).toLowerCase();
            String out = "";
            if (candidate.contains("json")) {
                candidate = candidate.replace("json", "");
                out = out + "AsJson";
            }
            if (StringUtils.hasText((String)(candidate = StringUtils.deleteAny((String)candidate, (String)" ,.+=-'\"\\|~`#$%^&\n\t")))) {
                out = StringUtils.capitalize((String)candidate) + out;
            }
            return "_" + out;
        }
        return "";
    }

    public static List<String> extractUriParams(String url) {
        ArrayList<String> outParams = new ArrayList<String>();
        if (StringUtils.hasText((String)url)) {
            String[] split;
            for (String part : split = StringUtils.split((String)url, (String)"/")) {
                int indexOfStart = part.indexOf("{");
                int indexOfEnd = part.indexOf("}");
                if (indexOfStart == -1 || indexOfEnd == -1 || indexOfStart >= indexOfEnd) continue;
                outParams.add(part.substring(indexOfStart + 1, indexOfEnd));
            }
        }
        return outParams;
    }

    public static boolean isValidJavaClassName(String input) {
        if (!StringUtils.hasText((String)input)) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(input.charAt(0))) {
            return false;
        }
        if (input.length() > 1) {
            for (int i = 1; i < input.length(); ++i) {
                if (Character.isJavaIdentifierPart(input.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static String cleanForJavadoc(String input) {
        return NamingHelper.cleanLeadingAndTrailingNewLineAndChars(input);
    }

    public static String cleanLeadingAndTrailingNewLineAndChars(String input) {
        if (!StringUtils.hasText((String)input)) {
            return input;
        }
        String output = input;
        output = output.replaceAll("[\\s]+\\*[\\s]+", " ");
        while (output.startsWith("/") || output.startsWith("\n") || output.startsWith("*") || output.startsWith("-") || output.startsWith("\t") || output.startsWith(" ") || output.startsWith("\\")) {
            output = output.substring(1);
        }
        while (output.endsWith("/") || output.endsWith("\n") || output.endsWith(" ") || output.endsWith(",") || output.endsWith("\t") || output.endsWith("-") || output.endsWith("*")) {
            output = output.substring(0, output.length() - 1);
        }
        return output;
    }

    public static String convertToClassName(String clazz) {
        return StringUtils.capitalize((String)NamingHelper.cleanNameForJava(clazz, false));
    }

    public static String getResourceName(RamlResource resource, boolean singularize) {
        String url = resource.getRelativeUri();
        if (StringUtils.hasText((String)url) && url.contains("/") && url.lastIndexOf(47) < url.length()) {
            return NamingHelper.getResourceName(url.substring(url.lastIndexOf(47) + 1), singularize);
        }
        return null;
    }

    public static String getAllResourcesNames(String url, boolean singularize) {
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.hasText((String)url)) {
            String[] resources = SLASH.split(url);
            int lengthCounter = 0;
            for (int i = resources.length - 1; i >= Config.getResourceTopLevelInClassNames() + 1; --i) {
                if (StringUtils.hasText((String)resources[i])) {
                    String resourceName = NamingHelper.getResourceName(resources[i], singularize);
                    if (Config.isReverseOrderInClassNames().booleanValue()) {
                        stringBuilder.append(resourceName);
                    } else {
                        stringBuilder.insert(0, resourceName);
                    }
                    ++lengthCounter;
                }
                if (Config.getResourceDepthInClassNames() > 0 && lengthCounter >= Config.getResourceDepthInClassNames()) break;
            }
        }
        return stringBuilder.toString();
    }

    public static String getResourceName(String resource, boolean singularize) {
        if (StringUtils.hasText((String)resource)) {
            String resourceName = StringUtils.capitalize((String)resource);
            if (singularize) {
                resourceName = NamingHelper.singularize(resourceName);
            }
            resourceName = StringUtils.capitalize((String)NamingHelper.cleanNameForJava(resourceName));
            return resourceName;
        }
        return null;
    }

    public static String singularize(String target) {
        String result = Inflector.singularize((String)target);
        if (target.endsWith("ss") && result.equals(target.substring(0, target.length() - 1))) {
            result = target;
        }
        return result;
    }

    public static String pluralize(String target) {
        if (target.endsWith("s")) {
            return target;
        }
        return Inflector.pluralize((String)target);
    }

    public static String getParameterName(String name) {
        return NamingHelper.filterKeywords(StringUtils.uncapitalize((String)NamingHelper.cleanNameForJava(name)));
    }

    public static String cleanNameForJava(String resourceName) {
        return NamingHelper.cleanNameForJava(resourceName, true);
    }

    private static String cleanNameForJava(String resourceName, boolean filterKeywords) {
        String outString = resourceName;
        if (StringUtils.hasText((String)resourceName) && StringUtils.hasText((String)(outString = NamingHelper.getNameHelper().replaceIllegalCharacters(resourceName)))) {
            outString = NamingHelper.getNameHelper().normalizeName(outString);
        }
        if (!filterKeywords) {
            return outString;
        }
        return NamingHelper.filterKeywords(outString);
    }

    public static String filterKeywords(String name) {
        if (NamingHelper.getKeywords().contains(name)) {
            return name + "Custom";
        }
        return name;
    }

    public static String cleanNameForJavaEnum(String enumConstant) {
        if (!StringUtils.hasText((String)enumConstant)) {
            return enumConstant;
        }
        ArrayList<String> nameGroups = new ArrayList<String>(Arrays.asList(org.apache.commons.lang3.StringUtils.splitByCharacterTypeCamelCase((String)enumConstant)));
        nameGroups.removeIf(s -> org.apache.commons.lang3.StringUtils.containsOnly((CharSequence)s.replaceAll(ILLEGAL_CHARACTER_REGEX, "_"), (String)"_"));
        String enumName = org.apache.commons.lang3.StringUtils.upperCase((String)org.apache.commons.lang3.StringUtils.join(nameGroups, (String)"_"));
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)enumName)) {
            enumName = "_DEFAULT_";
        } else if (Character.isDigit(enumName.charAt(0))) {
            enumName = "_" + enumName;
        }
        return NamingHelper.filterKeywords(enumName);
    }

    private static boolean doesUriEndsWithParam(String uri) {
        if (StringUtils.isEmpty((Object)uri)) {
            return false;
        }
        String subUri = uri;
        if (uri.lastIndexOf(47) > -1) {
            subUri = uri.substring(uri.lastIndexOf(47) + 1);
        }
        return subUri.startsWith("{") && subUri.endsWith("}");
    }

    public static String getActionName(ApiActionMetadata apiActionMetadata) {
        if (Config.getOverrideNamingLogicWith() == SpringMvcEndpointGeneratorMojo.OverrideNamingLogicWith.DISPLAY_NAME && !StringUtils.isEmpty((Object)apiActionMetadata.getDisplayName())) {
            return StringUtils.uncapitalize((String)NamingHelper.cleanNameForJava(apiActionMetadata.getDisplayName()));
        }
        if (Config.getOverrideNamingLogicWith() == SpringMvcEndpointGeneratorMojo.OverrideNamingLogicWith.ANNOTATION) {
            for (AnnotationRef annotation : apiActionMetadata.getAnnotations()) {
                if (!"(javaName)".equals(annotation.name())) continue;
                return String.valueOf(annotation.structuredValue().value());
            }
        }
        if (Config.getMethodsNamingLogic() == SpringMvcEndpointGeneratorMojo.MethodsNamingLogic.RESOURCES) {
            return NamingHelper.getActionNameFromResources(apiActionMetadata.getParent().getResource(), apiActionMetadata.getResource(), apiActionMetadata.getActionType());
        }
        return NamingHelper.getActionNameFromObjects(apiActionMetadata);
    }

    private static String getActionNameFromObjects(ApiActionMetadata apiActionMetadata) {
        String uri = apiActionMetadata.getResource().getUri();
        String name = NamingHelper.convertActionTypeToIntent(apiActionMetadata.getActionType(), NamingHelper.doesUriEndsWithParam(uri));
        if (apiActionMetadata.getActionType().equals((Object)RamlActionType.GET)) {
            Map<String, ApiBodyMetadata> responseBody = apiActionMetadata.getResponseBody();
            if (responseBody.size() > 0) {
                ApiBodyMetadata apiBodyMetadata = responseBody.values().iterator().next();
                String responseObjectName = NamingHelper.cleanNameForJava(StringUtils.capitalize((String)apiBodyMetadata.getName()));
                if (apiBodyMetadata.isArray()) {
                    responseObjectName = StringUtils.capitalize((String)NamingHelper.pluralize(responseObjectName));
                }
                name = name + responseObjectName;
            } else {
                name = name + "Object";
            }
            name = NamingHelper.appendActionNameWithSingleParameter(apiActionMetadata, name);
        } else if (apiActionMetadata.getActionType().equals((Object)RamlActionType.DELETE)) {
            String url = NamingHelper.cleanLeadingAndTrailingNewLineAndChars(apiActionMetadata.getResource().getUri());
            String[] splitUrl = SLASH.split(url);
            String resourceNameToUse = null;
            resourceNameToUse = splitUrl.length > 1 && StringUtils.countOccurrencesOf((String)splitUrl[splitUrl.length - 1], (String)"{") > 0 ? splitUrl[splitUrl.length - 2] : splitUrl[splitUrl.length - 1];
            name = name + StringUtils.capitalize((String)NamingHelper.cleanNameForJava(NamingHelper.singularize(resourceNameToUse)));
            name = NamingHelper.appendActionNameWithSingleParameter(apiActionMetadata, name);
        } else {
            String creationObject;
            ApiBodyMetadata requestBody = apiActionMetadata.getRequestBody();
            if (requestBody != null) {
                creationObject = requestBody.getName();
            } else {
                creationObject = apiActionMetadata.getParent().getResourceUri();
                creationObject = creationObject.substring(creationObject.lastIndexOf(47) + 1);
            }
            return name + NamingHelper.cleanNameForJava(StringUtils.capitalize((String)creationObject));
        }
        return name;
    }

    private static List<ApiParameterMetadata> getParameters(ApiActionMetadata apiActionMetadata) {
        ArrayList<ApiParameterMetadata> parameterMetadataList = new ArrayList<ApiParameterMetadata>();
        parameterMetadataList.addAll(apiActionMetadata.getPathVariables());
        parameterMetadataList.addAll(apiActionMetadata.getRequestParameters());
        parameterMetadataList.addAll(apiActionMetadata.getRequestHeaders());
        return parameterMetadataList;
    }

    private static String appendActionNameWithSingleParameter(ApiActionMetadata apiActionMetadata, String methodName) {
        String newMethodName = methodName;
        List<ApiParameterMetadata> parameterMetadataList = NamingHelper.getParameters(apiActionMetadata);
        if (parameterMetadataList.size() == 1) {
            ApiParameterMetadata paramMetaData = parameterMetadataList.iterator().next();
            newMethodName = newMethodName + "By" + StringUtils.capitalize((String)paramMetaData.getJavaName());
        }
        return newMethodName;
    }

    private static String getActionNameFromResources(RamlResource controllerizedResource, RamlResource resource, RamlActionType actionType) {
        String url = resource.getUri();
        if (controllerizedResource != resource && StringUtils.countOccurrencesOf((String)url, (String)"{") < StringUtils.countOccurrencesOf((String)url, (String)"/") - 1) {
            url = NamingHelper.reduceToResourceNameAndId(url);
        }
        if (StringUtils.hasText((String)url)) {
            String[] splitUrl = SLASH.split(url);
            String name = "";
            int numberOfIdsParsed = 0;
            boolean singularizeNext = false;
            boolean isIdInPath = false;
            for (int index = splitUrl.length - 1; numberOfIdsParsed < 2 && index >= 0; --index) {
                String segment = splitUrl[index];
                if (segment.contains("{") && segment.contains("}")) {
                    if (index > 0 && index == splitUrl.length - 1) {
                        isIdInPath = true;
                        if (segment.startsWith("{") && segment.endsWith("}")) {
                            String peek = splitUrl[index - 1].toLowerCase();
                            name = "By" + StringUtils.capitalize((String)org.apache.commons.lang3.StringUtils.difference((String)peek, (String)segment.substring(1, segment.length() - 1)));
                        } else {
                            String[] split = segment.split("[{}]");
                            name = "By";
                            for (String segmentPart : split) {
                                name = name + StringUtils.capitalize((String)segmentPart);
                            }
                        }
                    }
                    singularizeNext = true;
                    continue;
                }
                segment = NamingHelper.cleanNameForJava(segment);
                if (singularizeNext) {
                    name = !segment.endsWith("details") ? NamingHelper.singularize(StringUtils.capitalize((String)segment)) + name : StringUtils.capitalize((String)segment) + name;
                    singularizeNext = false;
                } else {
                    name = StringUtils.capitalize((String)segment) + name;
                }
                ++numberOfIdsParsed;
            }
            String tail = splitUrl[splitUrl.length - 1];
            String prefix = NamingHelper.convertActionTypeToIntent(actionType, isIdInPath);
            if (!NamingHelper.singularize(tail).equals(tail) && !tail.endsWith("details") && (RamlActionType.POST.equals((Object)actionType) || RamlActionType.PUT.equals((Object)actionType) && isIdInPath)) {
                name = NamingHelper.singularize(name);
            }
            return prefix + name;
        }
        return null;
    }

    private static String reduceToResourceNameAndId(String url) {
        String[] splitUrl = SLASH.split(url);
        String slash = "/";
        return slash + splitUrl[splitUrl.length - 2] + slash + splitUrl[splitUrl.length - 1];
    }

    private static String convertActionTypeToIntent(RamlActionType actionType, boolean isIdInPath) {
        switch (actionType) {
            case DELETE: {
                return "delete";
            }
            case GET: {
                return "get";
            }
            case POST: {
                if (!isIdInPath) {
                    return "create";
                }
            }
            case PUT: {
                return "update";
            }
            case PATCH: {
                return "modify";
            }
        }
        return "do";
    }

    public static String getDefaultModelPackage() {
        return ".model";
    }

    private static List<String> getKeywords() {
        if (keywordsList == null || keywordsList.isEmpty()) {
            keywordsList = Arrays.asList(KEYWORDS);
        }
        return keywordsList;
    }
}

