/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlplugin.raml2code.helpers;

import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlAction;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlResource;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlResponse;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlRoot;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlSecurityReference;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlSecurityScheme;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class RamlHelper {
    public static RamlResponse getSuccessfulResponse(RamlAction action) {
        String[] successfulResponses;
        for (String code : successfulResponses = new String[]{"200", "201", "202"}) {
            if (action == null || CollectionUtils.isEmpty(action.getResponses()) || !action.getResponses().containsKey(code)) continue;
            return action.getResponses().get(code);
        }
        return null;
    }

    public static String getFirstAuthorizationGrant(RamlAction action, RamlRoot document) {
        List<String> grants = RamlHelper.getAuthorizationGrants(action, document);
        if (grants.isEmpty()) {
            return null;
        }
        return grants.get(0);
    }

    private static List<String> getAuthorizationGrants(RamlAction action, RamlRoot document) {
        ArrayList<String> grants = new ArrayList<String>();
        List<RamlSecurityReference> securityRefs = RamlHelper.getSecurityRef(action, document);
        for (RamlSecurityReference securityRef : securityRefs) {
            List<String> authorizationGrants = securityRef.getAuthorizationGrants();
            for (String authorizationGrant : authorizationGrants) {
                grants.add(authorizationGrant);
            }
        }
        if (!grants.isEmpty()) {
            return grants;
        }
        return document.getSecuritySchemes().stream().map(RamlHelper::getAuthorizationGrants).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static List<String> getAuthorizationGrants(RamlSecurityScheme securityScheme) {
        return securityScheme.getAuthorizationGrants();
    }

    private static List<RamlSecurityReference> getSecurityRef(RamlAction action, RamlRoot document) {
        List<RamlSecurityReference> securedBy = action.getSecuredBy();
        if (!securedBy.isEmpty()) {
            return securedBy;
        }
        for (RamlResource resource = action.getResource(); resource != null && securedBy.isEmpty(); resource = resource.getParentResource()) {
            securedBy = resource.getSecuredBy();
        }
        if (!securedBy.isEmpty()) {
            return securedBy;
        }
        return document.getSecuredBy();
    }

    public static List<String> removeDuplicates(List<String> list) {
        return list.stream().distinct().collect(Collectors.toList());
    }
}

