/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlplugin.raml2code.helpers;

import com.phoenixnap.oss.ramlplugin.raml2code.data.ApiResourceMetadata;
import com.phoenixnap.oss.ramlplugin.raml2code.helpers.RamlHelper;
import com.phoenixnap.oss.ramlplugin.raml2code.plugin.Config;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlAction;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlActionType;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlResource;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlResponse;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlRoot;
import com.sun.codemodel.JCodeModel;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class RamlParser {
    private String startUrl = "";

    public RamlParser(String startUrl) {
        this.startUrl = startUrl;
    }

    public Set<ApiResourceMetadata> extractControllers(JCodeModel bodyCodeModel, RamlRoot raml) {
        LinkedHashSet<ApiResourceMetadata> controllers = new LinkedHashSet<ApiResourceMetadata>();
        if (raml == null) {
            return controllers;
        }
        if (bodyCodeModel == null) {
            bodyCodeModel = new JCodeModel();
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        LinkedHashSet<String> namesToDisable = new LinkedHashSet<String>();
        for (Map.Entry<String, RamlResource> resource : raml.getResources().entrySet()) {
            Set<ApiResourceMetadata> resources = this.checkResource(bodyCodeModel, this.startUrl, resource.getValue(), null, raml);
            for (ApiResourceMetadata resourceMetadata : resources) {
                if (names.contains(resourceMetadata.getResourceName())) {
                    namesToDisable.add(resourceMetadata.getResourceName());
                }
                names.add(resourceMetadata.getResourceName());
                controllers.add(resourceMetadata);
            }
        }
        for (ApiResourceMetadata resourceMetadata : controllers) {
            if (!namesToDisable.contains(resourceMetadata.getResourceName())) continue;
            resourceMetadata.setSingularizeName(false);
        }
        return controllers;
    }

    private boolean shouldCreateController(RamlResource resource) {
        if (resource.getActions() != null && !resource.getActions().isEmpty()) {
            return true;
        }
        if (resource.getResources() != null && !resource.getResources().isEmpty()) {
            for (RamlResource childResource : resource.getResources().values()) {
                if ((childResource.getUriParameters() == null || childResource.getUriParameters().isEmpty()) && (childResource.getResolvedUriParameters() == null || childResource.getResolvedUriParameters().isEmpty())) continue;
                return true;
            }
        }
        return false;
    }

    private Set<ApiResourceMetadata> checkResource(JCodeModel bodyCodeModel, String baseUrl, RamlResource resource, ApiResourceMetadata controller, RamlRoot document) {
        LinkedHashSet<ApiResourceMetadata> controllers = new LinkedHashSet<ApiResourceMetadata>();
        String url = baseUrl + resource.getRelativeUri();
        if (controller == null && this.shouldCreateController(resource)) {
            controller = new ApiResourceMetadata(bodyCodeModel, url, resource, document);
            controllers.add(controller);
        }
        if (resource.getActions() != null && !resource.getActions().isEmpty()) {
            for (RamlActionType actionType : RamlActionType.values()) {
                if (!resource.getActions().containsKey((Object)actionType)) continue;
                RamlAction childResource = resource.getActions().get((Object)actionType);
                RamlResponse response = null;
                if (childResource.getResponses() != null) {
                    response = RamlHelper.getSuccessfulResponse(childResource);
                }
                if (Config.isSeperateMethodsByContentType().booleanValue() && response != null && response.hasBody() && response.getBody().size() > 1) {
                    for (String responseType : response.getBody().keySet()) {
                        controller.addApiCall(resource, actionType, childResource, responseType);
                    }
                    continue;
                }
                controller.addApiCall(resource, actionType, childResource, null);
            }
        }
        if (resource.getResources() != null && !resource.getResources().isEmpty()) {
            for (Map.Entry entry : resource.getResources().entrySet()) {
                controllers.addAll(this.checkResource(bodyCodeModel, url, (RamlResource)entry.getValue(), controller, document));
            }
        }
        return controllers;
    }
}

