/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlplugin.raml2code.helpers;

import com.phoenixnap.oss.ramlplugin.raml2code.data.ApiBodyMetadata;
import com.phoenixnap.oss.ramlplugin.raml2code.interpreters.RamlInterpretationResult;
import com.phoenixnap.oss.ramlplugin.raml2code.interpreters.RamlInterpreterFactory;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlRoot;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import java.util.Collections;
import java.util.List;
import org.raml.v2.api.model.common.ValidationResult;
import org.raml.v2.api.model.v10.datamodel.ArrayTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.DateTimeTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.ExampleSpec;
import org.raml.v2.api.model.v10.datamodel.ExternalTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.NumberTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.StringTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.XMLFacetInfo;
import org.raml.v2.api.model.v10.declarations.AnnotationRef;
import org.raml.v2.api.model.v10.declarations.AnnotationTarget;
import org.raml.v2.api.model.v10.system.types.AnnotableStringType;
import org.raml.v2.api.model.v10.system.types.MarkdownString;

public class RamlTypeHelper {
    public static String getFormat(TypeDeclaration param) {
        if (param == null) {
            return null;
        }
        if (param instanceof NumberTypeDeclaration) {
            return ((NumberTypeDeclaration)param).format();
        }
        if (param instanceof DateTimeTypeDeclaration) {
            return ((DateTimeTypeDeclaration)param).format();
        }
        return null;
    }

    public static boolean isArray(TypeDeclaration param) {
        return param instanceof ArrayTypeDeclaration;
    }

    public static ApiBodyMetadata mapTypeToPojo(JCodeModel pojoCodeModel, RamlRoot document, TypeDeclaration type) {
        RamlInterpretationResult interpret = RamlInterpreterFactory.getInterpreterForType(type).interpret(document, type, pojoCodeModel, false);
        JClass pojo = null;
        if (interpret.getBuilder() != null) {
            pojo = interpret.getBuilder().getPojo();
        } else if (interpret.getResolvedClass() != null) {
            pojo = interpret.getResolvedClass();
        }
        if (pojo == null) {
            throw new IllegalStateException("No Pojo created or resolved for type " + type.getClass().getSimpleName() + ":" + type.name());
        }
        if (pojo.name().equals("Void")) {
            return null;
        }
        boolean array = false;
        String pojoName = pojo.name();
        if (pojo.name().contains("List<") || pojo.name().contains("Set<")) {
            array = true;
            pojoName = ((JClass)pojo.getTypeParameters().get(0)).name();
        }
        return new ApiBodyMetadata(pojoName, type, array, pojoCodeModel);
    }

    public static boolean isSchemaType(TypeDeclaration type) {
        return type != null && type instanceof ExternalTypeDeclaration;
    }

    public static String getDescription(TypeDeclaration type) {
        if (type == null || type.description() == null) {
            return null;
        }
        return type.description().value();
    }

    public static String getExample(TypeDeclaration type) {
        if (type == null || type.example() == null) {
            return null;
        }
        return type.example().value();
    }

    public static String getDisplayName(TypeDeclaration type) {
        if (type == null || type.displayName() == null) {
            return null;
        }
        return type.displayName().value();
    }

    public static String getName(TypeDeclaration type) {
        if (type == null) {
            return null;
        }
        return type.name();
    }

    public static boolean isRequired(TypeDeclaration type) {
        if (type == null || type.required() == null) {
            return true;
        }
        return type.required();
    }

    public static boolean isBaseObject(String type) {
        return type.equalsIgnoreCase(Object.class.getSimpleName());
    }

    public static void annotateDateWithPattern(JAnnotationUse jAnnotationUse, String type, String format) {
        String param;
        switch (param = type.toUpperCase()) {
            case "DATE-ONLY": {
                jAnnotationUse.param("pattern", "yyyy-MM-dd");
                break;
            }
            case "TIME-ONLY": {
                jAnnotationUse.param("pattern", "HH:mm:ss");
                break;
            }
            case "DATETIME-ONLY": {
                jAnnotationUse.param("pattern", "yyyy-MM-dd'T'HH:mm:ss");
                break;
            }
            case "DATETIME": {
                if ("rfc2616".equalsIgnoreCase(format)) {
                    jAnnotationUse.param("pattern", "EEE, dd MMM yyyy HH:mm:ss z");
                    break;
                }
                jAnnotationUse.param("pattern", "yyyy-MM-dd'T'HH:mm:ssXXX");
                break;
            }
            default: {
                jAnnotationUse.param("pattern", "yyyy-MM-dd'T'HH:mm:ss");
            }
        }
    }

    public static StringTypeDeclaration createDefaultStringDeclaration(final String paramName) {
        return new StringTypeDeclaration(){
            String name;
            {
                this.name = paramName;
            }

            public List<AnnotationRef> annotations() {
                return null;
            }

            public XMLFacetInfo xml() {
                return null;
            }

            public List<ValidationResult> validate(String payload) {
                return null;
            }

            public String type() {
                return "string";
            }

            public String toXmlSchema() {
                return null;
            }

            public Boolean required() {
                return true;
            }

            public List<TypeDeclaration> parentTypes() {
                return null;
            }

            public String name() {
                return this.name;
            }

            public List<TypeDeclaration> facets() {
                return Collections.emptyList();
            }

            public List<ExampleSpec> examples() {
                return Collections.emptyList();
            }

            public ExampleSpec example() {
                return null;
            }

            public AnnotableStringType displayName() {
                return new AnnotableStringType(){

                    public List<AnnotationRef> annotations() {
                        return null;
                    }

                    public String value() {
                        return name;
                    }
                };
            }

            public MarkdownString description() {
                return null;
            }

            public String defaultValue() {
                return null;
            }

            public List<AnnotationTarget> allowedTargets() {
                return Collections.emptyList();
            }

            public String pattern() {
                return null;
            }

            public Integer minLength() {
                return null;
            }

            public Integer maxLength() {
                return null;
            }

            public List<String> enumValues() {
                return null;
            }

            public String toJsonSchema() {
                return null;
            }
        };
    }
}

