/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlplugin.raml2code.helpers;

import com.phoenixnap.oss.ramlplugin.raml2code.data.ApiActionMetadata;
import com.phoenixnap.oss.ramlplugin.raml2code.data.ApiBodyMetadata;
import com.phoenixnap.oss.ramlplugin.raml2code.helpers.CodeModelHelper;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.Callable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.context.request.async.DeferredResult;

public class RuleHelper {
    private RuleHelper() {
    }

    public static JClass getResponseEntity(ApiActionMetadata endpointMetadata, JCodeModel owner, boolean checkBody) {
        return RuleHelper.narrow(endpointMetadata, owner, false, checkBody, true, false);
    }

    public static JClass getCallableResponseEntity(ApiActionMetadata endpointMetadata, JCodeModel owner) {
        return RuleHelper.narrow(endpointMetadata, owner, true, true, true, false);
    }

    public static JClass getDeferredResultResponseEntity(ApiActionMetadata endpointMetadata, JCodeModel owner) {
        return RuleHelper.narrow(endpointMetadata, owner, false, true, true, true);
    }

    public static JClass getObject(ApiActionMetadata endpointMetadata, JCodeModel owner) {
        return RuleHelper.narrow(endpointMetadata, owner, false, true, false, false);
    }

    private static JClass narrow(ApiActionMetadata endpointMetadata, JCodeModel owner, boolean useCallable, boolean checkBody, boolean useWildcard, boolean useDeferredResult) {
        JClass callable = null;
        if (useCallable) {
            callable = owner.ref(Callable.class);
        }
        if (useDeferredResult) {
            callable = owner.ref(DeferredResult.class);
        }
        if (checkBody && endpointMetadata.getResponseBody().isEmpty()) {
            if (useWildcard || useDeferredResult) {
                return RuleHelper.getResponseEntityNarrow(owner, owner.wildcard(), callable);
            }
            return owner.ref(Object.class);
        }
        return RuleHelper.getReturnEntity(endpointMetadata, owner, callable, useWildcard);
    }

    private static JClass getResponseEntityNarrow(JCodeModel owner, JClass genericType, JClass callable) {
        JClass responseEntity = owner.ref(ResponseEntity.class);
        JClass returnNarrow = responseEntity.narrow(genericType);
        if (callable != null) {
            returnNarrow = callable.narrow(returnNarrow);
        }
        return returnNarrow;
    }

    private static JClass getReturnEntity(ApiActionMetadata endpointMetadata, JCodeModel owner, JClass callable, boolean useResponseEntity) {
        ApiBodyMetadata apiBodyMetadata = endpointMetadata.getResponseBody().values().iterator().next();
        JClass type = CodeModelHelper.findFirstClassBySimpleName(apiBodyMetadata.getCodeModel(), apiBodyMetadata.getName());
        type = apiBodyMetadata.isArray() ? RuleHelper.updateType(owner, callable, type, useResponseEntity, true) : (BigDecimal.class.getSimpleName().equals(apiBodyMetadata.getName()) ? RuleHelper.updateType(owner, callable, owner.ref(BigDecimal.class), useResponseEntity, false) : (BigInteger.class.getSimpleName().equals(apiBodyMetadata.getName()) ? RuleHelper.updateType(owner, callable, owner.ref(BigInteger.class), useResponseEntity, false) : RuleHelper.updateType(owner, callable, type, useResponseEntity, false)));
        return type;
    }

    private static JClass updateType(JCodeModel owner, JClass callable, JClass type, boolean useResponseEntity, boolean isArray) {
        JClass arrayType = owner.ref(List.class);
        if (useResponseEntity && isArray) {
            type = RuleHelper.getResponseEntityNarrow(owner, arrayType.narrow(type), callable);
        } else if (useResponseEntity) {
            type = RuleHelper.getResponseEntityNarrow(owner, type, callable);
        } else if (isArray) {
            type = arrayType.narrow(type);
        }
        return type;
    }
}

