/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlplugin.raml2code.helpers;

import com.phoenixnap.oss.ramlplugin.raml2code.data.ApiBodyMetadata;
import com.phoenixnap.oss.ramlplugin.raml2code.helpers.NamingHelper;
import com.phoenixnap.oss.ramlplugin.raml2code.plugin.Config;
import com.phoenixnap.oss.ramlplugin.raml2code.plugin.PojoGenerationConfig;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlParamType;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlRoot;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JPackage;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.jsonschema2pojo.Annotator;
import org.jsonschema2pojo.DefaultGenerationConfig;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.Jackson2Annotator;
import org.jsonschema2pojo.SchemaGenerator;
import org.jsonschema2pojo.SchemaMapper;
import org.jsonschema2pojo.SchemaStore;
import org.jsonschema2pojo.rules.RuleFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class SchemaHelper {
    protected static final Logger logger = LoggerFactory.getLogger(SchemaHelper.class);
    private static String JSON_SCHEMA_IDENT = "http://jsonschema.net";

    public static String resolveSchema(String schema, RamlRoot document) {
        if (document == null || schema == null || schema.indexOf("{") != -1) {
            return null;
        }
        if (document.getSchemas() != null && !document.getSchemas().isEmpty()) {
            for (Map<String, String> map : document.getSchemas()) {
                if (!map.containsKey(schema)) continue;
                return map.get(schema);
            }
        }
        return null;
    }

    public static Class<?> mapSimpleType(RamlParamType param, String format, String rawType) {
        switch (param) {
            case BOOLEAN: {
                return Boolean.class;
            }
            case DATE: {
                return SchemaHelper.mapDateFormat(rawType);
            }
            case INTEGER: {
                Class<?> fromFormat = SchemaHelper.mapNumberFromFormat(format);
                if (fromFormat == Double.class) {
                    throw new IllegalStateException();
                }
                if (fromFormat == null) {
                    return Long.class;
                }
                return fromFormat;
            }
            case NUMBER: {
                Class<?> fromFormat = SchemaHelper.mapNumberFromFormat(format);
                if (fromFormat == null) {
                    return BigDecimal.class;
                }
                return fromFormat;
            }
            case FILE: {
                return MultipartFile.class;
            }
        }
        return String.class;
    }

    public static Class<?> mapDateFormat(String rawType) {
        String param = rawType.toUpperCase();
        try {
            switch (param) {
                case "DATE-ONLY": {
                    String dateType = Config.getPojoConfig().getDateType();
                    if (StringUtils.hasText((String)dateType)) {
                        return Class.forName(dateType);
                    }
                    break;
                }
                case "TIME-ONLY": {
                    String timeType = Config.getPojoConfig().getTimeType();
                    if (StringUtils.hasText((String)timeType)) {
                        return Class.forName(timeType);
                    }
                    break;
                }
                default: {
                    String dateTimeType = Config.getPojoConfig().getDateTimeType();
                    if (StringUtils.hasText((String)dateTimeType)) {
                        return Class.forName(dateTimeType);
                    }
                }
            }
        }
        catch (ClassNotFoundException e) {
            logger.error("Error trying to find class for date type: " + rawType);
        }
        return Date.class;
    }

    private static Class<?> mapNumberFromFormat(String format) {
        if (format == null) {
            return null;
        }
        if (format.equals("int64") || format.equals("long")) {
            return Long.class;
        }
        if (format.equals("int32") || format.equals("int")) {
            return Integer.class;
        }
        if (format.equals("int16") || format.equals("int8")) {
            return Short.class;
        }
        if (format.equals("double") || format.equals("float")) {
            return Double.class;
        }
        return null;
    }

    public static String extractNameFromSchema(String schema, String schemaName, String fallbackName) {
        String resolvedName = null;
        if (schema != null) {
            String javaType;
            int startIdx = 0;
            String type = SchemaHelper.extractTopItem("type", schema, startIdx);
            if (type != null && type.equalsIgnoreCase("array")) {
                String ref;
                int itemsIdx = schema.indexOf("\"items\"");
                if (itemsIdx != -1) {
                    startIdx = itemsIdx + 7;
                }
                if ((ref = SchemaHelper.extractTopItem("$ref", schema, startIdx)) != null) {
                    logger.info("Loading referenced schema " + ref);
                    ref = ref.replace("classpath:", "");
                    try {
                        schema = IOUtils.toString((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream(ref), (String)"UTF-8");
                        startIdx = 0;
                    }
                    catch (IOException e) {
                        logger.info("Erro Loading referenced schema " + ref, (Throwable)e);
                    }
                }
            }
            if (StringUtils.hasText((String)(javaType = SchemaHelper.extractTopItem("javaType", schema, startIdx)))) {
                int dotIdx = javaType.lastIndexOf(".");
                if (dotIdx > -1) {
                    javaType = javaType.substring(dotIdx + 1);
                }
                resolvedName = javaType;
            } else {
                String id = SchemaHelper.extractTopItem("id", schema, startIdx);
                if (StringUtils.hasText((String)id)) {
                    if (id.startsWith("urn:") && id.lastIndexOf(":") + 1 < id.length()) {
                        id = id.substring(id.lastIndexOf(":") + 1);
                    } else if (id.startsWith(JSON_SCHEMA_IDENT) && id.length() > JSON_SCHEMA_IDENT.length() + 3) {
                        id = id.substring(JSON_SCHEMA_IDENT.length());
                    }
                    resolvedName = StringUtils.capitalize((String)id);
                }
                if (!NamingHelper.isValidJavaClassName(resolvedName)) {
                    if (NamingHelper.isValidJavaClassName(schemaName)) {
                        return StringUtils.capitalize((String)schemaName);
                    }
                    resolvedName = fallbackName;
                }
            }
        }
        return resolvedName;
    }

    private static String extractTopItem(String searchString, String schema, int startIdx) {
        String extracted = null;
        int propIdx = schema.indexOf("\"properties\"", startIdx);
        if (propIdx == -1) {
            propIdx = Integer.MAX_VALUE;
        }
        int idIdx = schema.indexOf("\"" + searchString + "\"", startIdx);
        int secondIdIdx = schema.indexOf("\"" + searchString + "\"", idIdx + 1);
        if (secondIdIdx != -1 && propIdx > secondIdIdx) {
            idIdx = secondIdIdx;
        }
        if (idIdx != -1 && propIdx > idIdx) {
            int valueStartIdx = schema.indexOf("\"", idIdx + (searchString.length() + 2));
            int valueEndIdx = schema.indexOf("\"", valueStartIdx + 1);
            extracted = schema.substring(valueStartIdx + 1, valueEndIdx);
        }
        return extracted;
    }

    public static ApiBodyMetadata mapSchemaToPojo(RamlRoot document, String schema, String basePackage, String name, String schemaLocation) {
        String resolvedName = null;
        String schemaName = schema;
        String resolvedSchema = SchemaHelper.resolveSchema(schema, document);
        if (resolvedSchema == null) {
            resolvedSchema = schema;
            schemaName = null;
        }
        resolvedName = SchemaHelper.extractNameFromSchema(resolvedSchema, schemaName, name);
        JCodeModel codeModel = SchemaHelper.buildBodyJCodeModel(basePackage, StringUtils.hasText((String)schemaLocation) ? schemaLocation : "classpath:/", resolvedName, resolvedSchema, null);
        if (codeModel != null) {
            if (codeModel.countArtifacts() == 1) {
                try {
                    Iterator packages = codeModel.packages();
                    JPackage nextPackage = (JPackage)packages.next();
                    while (!nextPackage.classes().hasNext() && packages.hasNext()) {
                        nextPackage = (JPackage)packages.next();
                    }
                    resolvedName = ((JDefinedClass)nextPackage.classes().next()).name();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            return new ApiBodyMetadata(resolvedName, resolvedSchema, codeModel);
        }
        return null;
    }

    public static JCodeModel buildBodyJCodeModel(String basePackage, String schemaLocation, String name, String schema, Annotator annotator) {
        JCodeModel codeModel = new JCodeModel();
        SchemaStore schemaStore = new SchemaStore();
        PojoGenerationConfig config = Config.getPojoConfig();
        if (config == null) {
            config = SchemaHelper.getDefaultGenerationConfig();
        }
        if (annotator == null) {
            annotator = new Jackson2Annotator((GenerationConfig)config);
        }
        RuleFactory ruleFactory = new RuleFactory((GenerationConfig)config, annotator, schemaStore);
        SchemaMapper mapper = new SchemaMapper(ruleFactory, new SchemaGenerator());
        boolean useParent = StringUtils.hasText((String)schemaLocation);
        try {
            if (useParent) {
                mapper.generate(codeModel, name, basePackage, schema, new URI(schemaLocation));
            } else {
                mapper.generate(codeModel, name, basePackage, schema);
            }
        }
        catch (Exception e) {
            if (useParent && e.getMessage().contains("classpath")) {
                logger.debug("Referenced Schema contains self $refs or not found in classpath. Regenerating model withouth classpath: for " + name);
                codeModel = new JCodeModel();
                try {
                    mapper.generate(codeModel, name, basePackage, schema);
                    return codeModel;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            logger.error("Error generating pojo from schema" + name, (Throwable)e);
            return null;
        }
        return codeModel;
    }

    public static GenerationConfig getDefaultGenerationConfig() {
        return SchemaHelper.getGenerationConfig(true, false, false, false);
    }

    public static GenerationConfig getGenerationConfig(final Boolean generateBuilders, final Boolean includeAdditionalProperties, final Boolean includeDynamicAccessors, final Boolean useLongIntegers) {
        return new DefaultGenerationConfig(){

            public boolean isGenerateBuilders() {
                if (generateBuilders != null) {
                    return generateBuilders;
                }
                return true;
            }

            public boolean isIncludeAdditionalProperties() {
                if (includeAdditionalProperties != null) {
                    return includeAdditionalProperties;
                }
                return false;
            }

            public boolean isIncludeDynamicAccessors() {
                if (includeDynamicAccessors != null) {
                    return includeDynamicAccessors;
                }
                return false;
            }

            public boolean isUseLongIntegers() {
                if (useLongIntegers != null) {
                    return useLongIntegers;
                }
                return super.isUseLongIntegers();
            }
        };
    }
}

