/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlplugin.raml2code.interpreters;

import com.phoenixnap.oss.ramlplugin.raml2code.helpers.CodeModelHelper;
import com.phoenixnap.oss.ramlplugin.raml2code.helpers.NamingHelper;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractBuilder {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractBuilder.class);
    protected transient LinkedHashMap<String, JDefinedClass> codeModels = new LinkedHashMap();
    protected JCodeModel pojoModel = null;
    protected JDefinedClass pojo = null;
    protected JPackage pojoPackage = null;

    public AbstractBuilder(JCodeModel pojoModel) {
        this.pojoModel = pojoModel;
    }

    public AbstractBuilder extendsClass(String className) {
        this.pojoCreationCheck();
        if (this.pojo.name().equals(className)) {
            throw new IllegalStateException("A class cannot extend itself");
        }
        this.pojo._extends(CodeModelHelper.findFirstClassBySimpleName(this.pojoModel, className));
        return this;
    }

    public AbstractBuilder extendsClass(AbstractBuilder classBuilder) {
        if (classBuilder.pojo == null) {
            throw new IllegalStateException("Supplied builder does not contain a class");
        }
        return this.extendsClass(classBuilder.pojo.name());
    }

    protected void implementsSerializable() {
        this.pojo._implements(Serializable.class);
        this.pojo.field(24, (JType)this.pojoModel.LONG, "serialVersionUID", JExpr.lit((long)new Random(System.currentTimeMillis()).nextLong()));
    }

    public AbstractBuilder withPackage(String pojoPackage) {
        if (this.pojoPackage != null) {
            throw new IllegalStateException("Pojo Package already created");
        }
        if (this.pojoModel == null) {
            this.pojoModel = new JCodeModel();
        }
        this.pojoPackage = this.pojoModel._package(pojoPackage);
        return this;
    }

    public AbstractBuilder withClassComment(String classComment) {
        this.pojoCreationCheck();
        JDocComment javadoc = this.pojo.javadoc();
        javadoc.add((Object)this.toJavaComment(classComment));
        javadoc.add((Object)("\n\nGenerated using springmvc-raml-plugin on " + new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format(new Date())));
        return this;
    }

    public JCodeModel getCodeModel() {
        return this.pojoModel;
    }

    public JClass getPojo() {
        return this.pojo;
    }

    protected void pojoCreationCheck() {
        if (this.pojo == null) {
            throw new IllegalStateException("Class not created");
        }
    }

    protected String toJavaComment(String comment) {
        return NamingHelper.cleanForJavadoc(comment);
    }

    protected String toJavaName(String name) {
        return NamingHelper.cleanNameForJava(name);
    }

    protected JClass resolveType(String type) {
        JDefinedClass jDefinedClass = this.pojoModel._getClass(type);
        if (jDefinedClass != null) {
            return jDefinedClass;
        }
        if (type.contains(".")) {
            int lastIndexOf = type.lastIndexOf(".");
            type.substring(lastIndexOf + 1);
        }
        return CodeModelHelper.findFirstClassBySimpleName(this.pojoModel, type);
    }
}

