/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlplugin.raml2code.interpreters;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.phoenixnap.oss.ramlplugin.raml2code.helpers.CodeModelHelper;
import com.phoenixnap.oss.ramlplugin.raml2code.helpers.NamingHelper;
import com.phoenixnap.oss.ramlplugin.raml2code.interpreters.AbstractBuilder;
import com.phoenixnap.oss.ramlplugin.raml2code.plugin.Config;
import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDeclaration;
import com.sun.codemodel.JEnumConstant;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JForEach;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class EnumBuilder
extends AbstractBuilder {
    protected static final Logger logger = LoggerFactory.getLogger(EnumBuilder.class);
    private JFieldVar valueField = null;
    private JFieldVar lookupMap = null;
    private transient Map<String, Boolean> ENUM_CACHE = new HashMap<String, Boolean>();

    public EnumBuilder(JCodeModel pojoModel, String className) {
        super(pojoModel);
        this.withName(Config.getPojoPackage(), className);
    }

    public EnumBuilder withName(String pojoPackage, String className) {
        className = NamingHelper.convertToClassName(className);
        String fullyQualifiedClassName = pojoPackage + "." + className;
        if (this.pojoPackage == null) {
            this.withPackage(pojoPackage);
        }
        if (this.pojo != null) {
            throw new IllegalStateException("Enum already created");
        }
        try {
            logger.debug("Creating Enum " + fullyQualifiedClassName);
            this.pojo = this.pojoModel._class(fullyQualifiedClassName, ClassType.ENUM);
        }
        catch (JClassAlreadyExistsException e) {
            logger.debug("Enum {} already exists. Reusing it!", (Object)fullyQualifiedClassName);
            this.pojo = this.pojoModel._getClass(fullyQualifiedClassName);
        }
        this.codeModels.put(fullyQualifiedClassName, this.pojo);
        return this;
    }

    public EnumBuilder withValueField(Class<?> type) {
        this.pojoCreationCheck();
        if (!this.pojo.fields().containsKey("value")) {
            this.valueField = this.pojo.field(12, type, "value");
            JMethod constructor = this.pojo.constructor(4);
            JVar valueParam = constructor.param(type, "value");
            constructor.body().assign((JAssignmentTarget)JExpr._this().ref((JVar)this.valueField), (JExpression)valueParam);
            JClass lookupType = this.pojo.owner().ref(Map.class).narrow(new JClass[]{this.valueField.type().boxify(), this.pojo});
            this.lookupMap = this.pojo.field(28, (JType)lookupType, "VALUE_CACHE");
            JClass lookupImplType = this.pojo.owner().ref(HashMap.class).narrow(new JClass[]{this.valueField.type().boxify(), this.pojo});
            this.lookupMap.init((JExpression)JExpr._new((JClass)lookupImplType));
            JForEach forEach = this.pojo.init().forEach((JType)this.pojo, "c", (JExpression)JExpr.invoke((String)"values"));
            JInvocation put = forEach.body().invoke((JExpression)this.lookupMap, "put");
            put.arg((JExpression)forEach.var().ref("value"));
            put.arg((JExpression)forEach.var());
            JMethod fromValue = this.pojo.method(1, this.valueField.type(), "value");
            fromValue.body()._return((JExpression)JExpr._this().ref((JVar)this.valueField));
            this.addFromValueMethod();
            this.addToStringMethod();
        }
        return this;
    }

    private void addFromValueMethod() {
        JMethod fromValue = this.pojo.method(17, (JType)this.pojo, "fromValue");
        JVar valueParam = fromValue.param(this.valueField.type(), "value");
        fromValue.body()._return((JExpression)this.lookupMap.invoke("get").arg((JExpression)valueParam));
    }

    private void addToStringMethod() {
        JMethod toString = this.pojo.method(1, String.class, "toString");
        toString.annotate(Override.class);
        JFieldRef toReturn = JExpr._this().ref((JVar)this.valueField);
        if (!this.valueField.type().fullName().equals(String.class.getName())) {
            toReturn = toReturn.invoke("toString");
        }
        toString.body()._return((JExpression)toReturn);
    }

    public <T> EnumBuilder withEnum(T name, Class<T> type) {
        this.pojoCreationCheck();
        String cleaned = NamingHelper.cleanNameForJavaEnum(name.toString());
        if (!this.doesEnumContainField(type, cleaned)) {
            this.withValueField(type);
            this.ENUM_CACHE.put(cleaned, true);
            logger.debug("Adding field: {} to {}", name, (Object)this.pojo.name());
            if (StringUtils.hasText((String)cleaned)) {
                JEnumConstant enumConstant = this.pojo.enumConstant(cleaned);
                if (type.equals(Integer.class)) {
                    enumConstant.arg(JExpr.lit((int)((Integer)name)));
                } else if (type.equals(Boolean.class)) {
                    enumConstant.arg(JExpr.lit((boolean)((Boolean)name)));
                } else if (type.equals(Double.class)) {
                    enumConstant.arg(JExpr.lit((double)((Double)name)));
                } else if (type.equals(Float.class)) {
                    enumConstant.arg(JExpr.lit((float)((Float)name).floatValue()));
                } else if (type.equals(Long.class)) {
                    enumConstant.arg(JExpr.lit((long)((Long)name)));
                } else {
                    enumConstant.arg(JExpr.lit((String)name.toString()));
                    enumConstant.annotate(JsonProperty.class).param("value", name.toString());
                }
            }
        }
        return this;
    }

    private boolean doesEnumContainField(Class type, String name) {
        if (this.ENUM_CACHE.containsKey(name)) {
            return true;
        }
        boolean contains = false;
        try {
            Field field = this.pojo.getClass().getDeclaredField("enumConstantsByName");
            field.setAccessible(true);
            Map value = (Map)field.get(this.pojo);
            contains = value.containsKey(name);
        }
        catch (Exception e) {
            String elementAsString = CodeModelHelper.getElementAsString((JDeclaration)this.pojo);
            String toCheck = name + "(";
            if (type.equals(String.class)) {
                toCheck = toCheck + "\"";
            }
            contains = elementAsString.contains(toCheck);
        }
        if (contains) {
            this.ENUM_CACHE.put(name, true);
        }
        return contains;
    }

    public <T> EnumBuilder withEnums(List<? extends T> names, Class<T> type) {
        this.pojoCreationCheck();
        if (names != null && !names.isEmpty()) {
            for (T name : names) {
                this.withEnum(name, type);
            }
        }
        return this;
    }
}

