/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlplugin.raml2code.interpreters;

import com.phoenixnap.oss.ramlplugin.raml2code.helpers.NamingHelper;
import com.phoenixnap.oss.ramlplugin.raml2code.helpers.RamlTypeHelper;
import com.phoenixnap.oss.ramlplugin.raml2code.interpreters.BaseTypeInterpreter;
import com.phoenixnap.oss.ramlplugin.raml2code.interpreters.PojoBuilder;
import com.phoenixnap.oss.ramlplugin.raml2code.interpreters.RamlInterpretationResult;
import com.phoenixnap.oss.ramlplugin.raml2code.interpreters.RamlInterpreterFactory;
import com.phoenixnap.oss.ramlplugin.raml2code.plugin.Config;
import com.phoenixnap.oss.ramlplugin.raml2code.plugin.SpringMvcEndpointGeneratorMojo;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlDataType;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlRoot;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.declarations.AnnotationRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MimeType;
import org.springframework.util.StringUtils;

public class ObjectTypeInterpreter
extends BaseTypeInterpreter {
    protected static final Logger logger = LoggerFactory.getLogger(ObjectTypeInterpreter.class);

    @Override
    public Set<Class<? extends TypeDeclaration>> getSupportedTypes() {
        return Collections.singleton(ObjectTypeDeclaration.class);
    }

    @Override
    public RamlInterpretationResult interpret(RamlRoot document, TypeDeclaration type, JCodeModel builderModel, boolean property) {
        RamlInterpretationResult result = new RamlInterpretationResult(type.required());
        this.typeCheck(type);
        ObjectTypeDeclaration objectType = (ObjectTypeDeclaration)type;
        String name = objectType.name().endsWith("." + objectType.type()) ? StringUtils.capitalize((String)objectType.type()) : StringUtils.capitalize((String)objectType.name());
        Map<String, RamlDataType> types = document.getTypes();
        String typeName = objectType.type();
        if (RamlTypeHelper.isBaseObject(objectType.name()) && !RamlTypeHelper.isBaseObject(typeName)) {
            return this.interpret(document, (TypeDeclaration)type.parentTypes().get(0), builderModel, property);
        }
        if (!RamlTypeHelper.isBaseObject(objectType.name()) && !RamlTypeHelper.isBaseObject(typeName) && property) {
            name = typeName;
            if (types.get(name) == null) {
                throw new IllegalStateException("Data type " + name + " can't be found!");
            }
            typeName = types.get(name).getType().type();
        }
        try {
            MimeType.valueOf((String)name);
            name = typeName;
            typeName = types.get(name).getType().type();
        }
        catch (Exception ex) {
            logger.debug("mime: " + name);
        }
        ArrayList<RamlDataType> childTypes = new ArrayList<RamlDataType>();
        if (!StringUtils.isEmpty((Object)objectType.discriminator())) {
            for (RamlDataType ramlDataType : document.getTypes().values()) {
                if (!name.equals(ramlDataType.getType().type())) continue;
                childTypes.add(ramlDataType);
            }
        }
        if (builderModel != null) {
            JDefinedClass searchedClass = builderModel._getClass(Config.getPojoPackage() + "." + NamingHelper.convertToClassName(name));
            if (searchedClass != null) {
                result.setCodeModel(builderModel);
                result.setResolvedClass((JClass)searchedClass);
                return result;
            }
        } else {
            builderModel = new JCodeModel();
            result.setCodeModel(builderModel);
        }
        PojoBuilder builder = new PojoBuilder(builderModel, NamingHelper.convertToClassName(name));
        result.setBuilder(builder);
        TypeDeclaration parent = null;
        if (!RamlTypeHelper.isBaseObject(typeName)) {
            parent = types.get(typeName).getType();
        } else if (objectType.parentTypes() != null && objectType.parentTypes().size() > 0) {
            TypeDeclaration tempParent = (TypeDeclaration)objectType.parentTypes().get(0);
            if (!RamlTypeHelper.isBaseObject(tempParent.name())) {
                parent = types.get(tempParent.name()).getType();
            }
        } else {
            parent = null;
        }
        if (parent != null && !parent.name().equalsIgnoreCase(name)) {
            RamlInterpretationResult childResult = RamlInterpreterFactory.getInterpreterForType(parent).interpret(document, parent, builderModel, false);
            String childType = childResult.getResolvedClassOrBuiltOrObject().name();
            builder.extendsClass(childType);
        }
        ArrayList<String> excludeFieldsFromToString = new ArrayList<String>();
        for (TypeDeclaration objectProperty : objectType.properties()) {
            AnnotationRef annotation2;
            String fieldName = null;
            if (Config.getOverrideNamingLogicWith() == SpringMvcEndpointGeneratorMojo.OverrideNamingLogicWith.DISPLAY_NAME && objectProperty.displayName() != null) {
                fieldName = NamingHelper.getParameterName(objectProperty.displayName().value());
            } else if (Config.getOverrideNamingLogicWith() == SpringMvcEndpointGeneratorMojo.OverrideNamingLogicWith.ANNOTATION) {
                for (AnnotationRef annotation2 : objectProperty.annotations()) {
                    if (!"(javaName)".equals(annotation2.name())) continue;
                    fieldName = String.valueOf(annotation2.structuredValue().value());
                    break;
                }
            }
            if (StringUtils.isEmpty(fieldName)) {
                fieldName = NamingHelper.getParameterName(objectProperty.name());
            }
            List annotations = objectProperty.annotations();
            annotation2 = annotations.iterator();
            while (annotation2.hasNext()) {
                AnnotationRef annotation3 = (AnnotationRef)annotation2.next();
                if (!"(isSensitive)".equals(annotation3.name()) || !Boolean.TRUE.equals(annotation3.structuredValue().value())) continue;
                excludeFieldsFromToString.add(fieldName);
            }
            RamlInterpretationResult childResult = RamlInterpreterFactory.getInterpreterForType(objectProperty).interpret(document, objectProperty, builderModel, true);
            String childType = childResult.getResolvedClassOrBuiltOrObject().fullName();
            builder.withField(fieldName, childType, RamlTypeHelper.getDescription(objectProperty), childResult.getValidations(), objectProperty);
        }
        builder.withCompleteConstructor();
        builder.withOverridenMethods(excludeFieldsFromToString);
        if (!childTypes.isEmpty()) {
            builder.withJsonDiscriminator(childTypes, objectType.discriminator());
        }
        return result;
    }
}

