/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlplugin.raml2code.interpreters;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.phoenixnap.oss.ramlplugin.raml2code.helpers.CodeModelHelper;
import com.phoenixnap.oss.ramlplugin.raml2code.helpers.NamingHelper;
import com.phoenixnap.oss.ramlplugin.raml2code.helpers.RamlTypeHelper;
import com.phoenixnap.oss.ramlplugin.raml2code.interpreters.AbstractBuilder;
import com.phoenixnap.oss.ramlplugin.raml2code.interpreters.RamlTypeValidations;
import com.phoenixnap.oss.ramlplugin.raml2code.plugin.Config;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlDataType;
import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.raml.v2.api.model.v10.datamodel.DateTimeTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class PojoBuilder
extends AbstractBuilder {
    protected static final Logger logger = LoggerFactory.getLogger(PojoBuilder.class);

    public PojoBuilder(JCodeModel pojoModel, String className) {
        super(pojoModel);
        this.withName(Config.getPojoPackage(), className);
    }

    @Override
    public PojoBuilder extendsClass(String className) {
        this.pojoCreationCheck();
        if (this.pojo.name().equals(className)) {
            throw new IllegalStateException("A class cannot extend itself");
        }
        this.pojo._extends(CodeModelHelper.findFirstClassBySimpleName(this.pojoModel, className));
        return this;
    }

    public PojoBuilder extendsClass(PojoBuilder classBuilder) {
        if (classBuilder.pojo == null) {
            throw new IllegalStateException("Supplied builder does not contain a class");
        }
        return this.extendsClass(classBuilder.pojo.name());
    }

    public PojoBuilder withName(String pojoPackage, String className) {
        if (!NamingHelper.isValidJavaClassName(className)) {
            className = NamingHelper.cleanNameForJava(className);
        }
        String fullyQualifiedClassName = pojoPackage + "." + className;
        if (this.pojoPackage == null) {
            this.withPackage(pojoPackage);
        }
        if (this.pojo != null) {
            throw new IllegalStateException("Class already created");
        }
        try {
            logger.debug("Creating class " + fullyQualifiedClassName);
            this.pojo = this.pojoModel._class(fullyQualifiedClassName);
            this.withDefaultConstructor(className);
            this.implementsSerializable();
            this.codeModels.put(fullyQualifiedClassName, this.pojo);
        }
        catch (JClassAlreadyExistsException e) {
            logger.debug("Enum {} already exists. Reusing it!", (Object)fullyQualifiedClassName);
            this.pojo = this.pojoModel._getClass(fullyQualifiedClassName);
        }
        return this;
    }

    private void withDefaultConstructor(String className) {
        JMethod constructor = this.pojo.constructor(1);
        constructor.javadoc().add((Object)("Creates a new " + className + "."));
        JBlock defaultConstructorBody = constructor.body();
        defaultConstructorBody.invoke("super");
    }

    private JFieldVar parentContainsField(JClass pojo, String name) {
        JClass parent;
        if (pojo != null && !pojo.fullName().equals(Object.class.getName()) && (parent = pojo._extends()) != null) {
            JFieldVar parentField = this.parentContainsField(parent, name);
            if (parentField != null) {
                return parentField;
            }
            if (parent instanceof JDefinedClass) {
                return (JFieldVar)((JDefinedClass)parent).fields().get(name);
            }
        }
        return null;
    }

    public PojoBuilder withField(String name, String type, String comment, RamlTypeValidations validations, TypeDeclaration typeDeclaration) {
        JFieldVar parentField;
        this.pojoCreationCheck();
        logger.debug("Adding field: " + name + " to " + this.pojo.name());
        JClass resolvedType = this.resolveType(type);
        try {
            if (resolvedType.fullName().startsWith(List.class.getName() + "<")) {
                resolvedType = this.pojo.owner().ref(List.class).narrow((JClass)resolvedType.getTypeParameters().get(0));
            }
            if (resolvedType.fullName().startsWith(Set.class.getName() + "<")) {
                resolvedType = this.pojo.owner().ref(Set.class).narrow((JClass)resolvedType.getTypeParameters().get(0));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        JExpression jExpression = null;
        if (StringUtils.hasText((String)typeDeclaration.defaultValue())) {
            if (resolvedType.name().equals(Integer.class.getSimpleName())) {
                jExpression = JExpr.lit((int)Integer.valueOf(typeDeclaration.defaultValue()));
            } else if (resolvedType.name().equals(Boolean.class.getSimpleName())) {
                jExpression = JExpr.lit((boolean)Boolean.valueOf(typeDeclaration.defaultValue()));
            } else if (resolvedType.name().equals(Double.class.getSimpleName())) {
                jExpression = JExpr.lit((double)Double.valueOf(typeDeclaration.defaultValue()));
            } else if (resolvedType.name().equals(Float.class.getSimpleName())) {
                jExpression = JExpr.lit((float)Float.valueOf(typeDeclaration.defaultValue()).floatValue());
            } else if (resolvedType.name().equals(Long.class.getSimpleName())) {
                jExpression = JExpr.lit((long)Long.valueOf(typeDeclaration.defaultValue()));
            } else if (resolvedType.name().equals(BigDecimal.class.getSimpleName())) {
                jExpression = JExpr.direct((String)("new BigDecimal(\"" + typeDeclaration.defaultValue() + "\")"));
            } else if (resolvedType.name().equals(String.class.getSimpleName())) {
                jExpression = JExpr.lit((String)typeDeclaration.defaultValue());
            } else if (type.contains(".") && resolvedType instanceof JDefinedClass && ((JDefinedClass)resolvedType).getClassType().equals(ClassType.ENUM)) {
                jExpression = JExpr.direct((String)(resolvedType.name() + "." + NamingHelper.cleanNameForJavaEnum(typeDeclaration.defaultValue())));
            }
        } else if (resolvedType.fullName().startsWith(List.class.getName() + "<")) {
            JClass narrowedListClass = this.pojoModel.ref(ArrayList.class).narrow((JClass)resolvedType.getTypeParameters().get(0));
            jExpression = JExpr._new((JClass)narrowedListClass);
        }
        if (this.resolveType(Collection.class.getName()).isAssignableFrom(resolvedType) && !Config.getPojoConfig().isInitializeCollections()) {
            jExpression = null;
        }
        if ((parentField = this.parentContainsField((JClass)this.pojo, name)) != null) {
            JMethod getterMethod = this.generateGetterMethod(parentField, name, jExpression);
            if (Config.getPojoConfig().isIncludeJsr303Annotations() && validations != null) {
                validations.annotateFieldJSR303(getterMethod, false);
            }
            return this;
        }
        JFieldVar field = this.pojo.field(2, (JType)resolvedType, this.toJavaName(name), jExpression);
        if (!Objects.equals(typeDeclaration.name(), this.toJavaName(name))) {
            field.annotate(JsonProperty.class).param("value", typeDeclaration.name());
        }
        if (resolvedType.name().equals(Date.class.getSimpleName())) {
            JAnnotationUse jAnnotationUse = field.annotate(JsonFormat.class);
            String format = null;
            if (typeDeclaration instanceof DateTimeTypeDeclaration) {
                format = ((DateTimeTypeDeclaration)typeDeclaration).format();
            }
            RamlTypeHelper.annotateDateWithPattern(jAnnotationUse, typeDeclaration.type(), format);
        }
        if (StringUtils.hasText((String)comment)) {
            field.javadoc().add((Object)comment);
        }
        String fieldName = NamingHelper.convertToClassName(name);
        JMethod getterMethod = this.generateGetterMethod(field, name, null);
        if (Config.getPojoConfig().isIncludeJsr303Annotations() && validations != null) {
            boolean isPOJO = type.startsWith(this.pojo._package().name() + ".");
            if (!isPOJO && resolvedType.getClass().getName().equals("com.sun.codemodel.JNarrowedClass") && resolvedType.getTypeParameters().size() == 1) {
                JClass typeClass = (JClass)resolvedType.getTypeParameters().get(0);
                isPOJO = typeClass.fullName().startsWith(this.pojo._package().name() + ".");
            }
            validations.annotateFieldJSR303(getterMethod, isPOJO);
        }
        JMethod setter = this.pojo.method(1, (JType)this.pojoModel.VOID, "set" + fieldName);
        setter.param(field.type(), field.name());
        setter.body().assign((JAssignmentTarget)JExpr._this().ref(field.name()), (JExpression)JExpr.ref((String)field.name()));
        setter.javadoc().add((Object)("Set the " + name + "."));
        setter.javadoc().addParam(field.name()).add((Object)("the new " + field.name()));
        if (Config.getPojoConfig().isGenerateBuilders()) {
            JMethod wither = this.pojo.method(1, (JType)this.pojo, "with" + fieldName);
            wither.param(field.type(), field.name());
            wither.body().assign((JAssignmentTarget)JExpr._this().ref(field.name()), (JExpression)JExpr.ref((String)field.name()))._return(JExpr._this());
            wither.javadoc().add((Object)("With the " + name + "."));
            wither.javadoc().addParam(field.name()).add((Object)("the new " + field.name()));
        }
        return this;
    }

    private JMethod generateGetterMethod(JFieldVar field, String fieldName, JExpression defaultValue) {
        String javaName = NamingHelper.convertToClassName(fieldName);
        JMethod getter = this.pojo.method(1, field.type(), "get" + javaName);
        if (defaultValue != null) {
            JBlock body = getter.body();
            body._if(field.eq(JExpr._null()))._then()._return(defaultValue);
        }
        getter.body()._return((JExpression)field);
        getter.javadoc().add((Object)("Returns the " + fieldName + "."));
        getter.javadoc().addReturn().add((Object)field.name());
        return getter;
    }

    public PojoBuilder withCompleteConstructor() {
        this.pojoCreationCheck();
        Map<String, JFieldVar> nonTransientAndNonStaticFields = this.getNonTransientAndNonStaticFields();
        if (MapUtils.isNotEmpty(nonTransientAndNonStaticFields)) {
            JMethod constructor = this.pojo.constructor(1);
            Map<String, JVar> superParametersToAdd = this.getSuperParametersToAdd((JClass)this.pojo);
            this.addSuperConstructorInvocation(constructor, superParametersToAdd);
            constructor.javadoc().add((Object)("Creates a new " + this.pojo.name() + "."));
            for (Map.Entry<String, JFieldVar> pair : nonTransientAndNonStaticFields.entrySet()) {
                constructor.param(pair.getValue().type(), pair.getKey());
                constructor.body().assign((JAssignmentTarget)JExpr._this().ref(pair.getKey()), (JExpression)JExpr.ref((String)pair.getKey()));
            }
        }
        return this;
    }

    private void addSuperConstructorInvocation(JMethod constructor, Map<String, JVar> superParametersToAdd) {
        JBlock constructorBody = constructor.body();
        JInvocation invocation = constructorBody.invoke("super");
        for (JVar arg : superParametersToAdd.values()) {
            JVar param = constructor.param(arg.type(), arg.name());
            invocation.arg((JExpression)param);
        }
    }

    private Map<String, JVar> getSuperParametersToAdd(JClass pojo) {
        LinkedHashMap<String, JVar> tFields = new LinkedHashMap<String, JVar>();
        JClass parent = pojo._extends();
        if (!parent.name().equals(Object.class.getSimpleName()) && (parent = CodeModelHelper.findFirstClassBySimpleName(this.pojoModel, parent.name())) instanceof JDefinedClass) {
            JDefinedClass jParent = (JDefinedClass)parent;
            JMethod constructor = null;
            Iterator constructors = jParent.constructors();
            while (constructors.hasNext()) {
                JMethod targetConstructor = (JMethod)constructors.next();
                if (constructor != null && constructor.params().size() >= targetConstructor.params().size()) continue;
                constructor = targetConstructor;
            }
            for (JVar var : constructor.params()) {
                tFields.put(var.name(), var);
            }
        }
        return tFields;
    }

    private Map<String, JFieldVar> getNonTransientAndNonStaticFields() {
        LinkedHashMap<String, JFieldVar> nonStaticNonTransientFields = new LinkedHashMap<String, JFieldVar>();
        if (this.pojo instanceof JDefinedClass) {
            Map fields = this.pojo.fields();
            for (Map.Entry pair : fields.entrySet()) {
                if ((((JFieldVar)pair.getValue()).mods().getValue() & 0x110) != 0) continue;
                nonStaticNonTransientFields.put((String)pair.getKey(), (JFieldVar)pair.getValue());
            }
        }
        return nonStaticNonTransientFields;
    }

    public void withOverridenMethods(List<String> excludeFieldsFromToString) {
        if (Config.getPojoConfig().isIncludeHashcodeAndEquals()) {
            this.withHashCode();
            this.withEquals();
        }
        if (Config.getPojoConfig().isIncludeToString()) {
            this.withToString(excludeFieldsFromToString);
        }
    }

    public void withJsonDiscriminator(List<RamlDataType> childTypes, String discriminator) {
        this.pojo.annotate(JsonTypeInfo.class).param("property", discriminator).param("use", (Enum)JsonTypeInfo.Id.NAME).param("include", (Enum)JsonTypeInfo.As.EXISTING_PROPERTY).param("visible", true);
        JAnnotationUse param = this.pojo.annotate(JsonSubTypes.class).param("value", discriminator);
        JAnnotationArrayMember jAnnotationArrayMember = param.paramArray("value");
        for (RamlDataType childType : childTypes) {
            String discriminatorValue = childType.getDiscriminatorValue();
            if (StringUtils.isEmpty((Object)discriminatorValue)) {
                discriminatorValue = childType.getType().name();
            }
            jAnnotationArrayMember.annotate(JsonSubTypes.Type.class).param("value", (JType)this.resolveType(childType.getType().name())).param("name", discriminatorValue);
        }
    }

    private void withToString(List<String> excludeFieldsFromToString) {
        this.pojoCreationCheck();
        JMethod toString = this.pojo.method(1, String.class, "toString");
        Class<ToStringBuilder> toStringBuilderClass = ToStringBuilder.class;
        if (!Config.getPojoConfig().isUseCommonsLang3()) {
            toStringBuilderClass = org.apache.commons.lang.builder.ToStringBuilder.class;
        }
        JClass toStringBuilderRef = this.pojo.owner().ref(toStringBuilderClass);
        Map<String, JFieldVar> nonTransientAndNonStaticFields = this.getNonTransientAndNonStaticFields();
        nonTransientAndNonStaticFields.keySet().removeAll(excludeFieldsFromToString);
        JInvocation toStringBuilderInvocation = this.appendFieldsToString(nonTransientAndNonStaticFields, toStringBuilderRef);
        toString.body()._return((JExpression)toStringBuilderInvocation.invoke("toString"));
    }

    private JInvocation appendFieldsToString(Map<String, JFieldVar> nonTransientAndNonStaticFields, JClass toStringBuilderRef) {
        JInvocation invocation = JExpr._new((JClass)toStringBuilderRef).arg(JExpr._this());
        Iterator<Map.Entry<String, JFieldVar>> iterator = nonTransientAndNonStaticFields.entrySet().iterator();
        if (!this.pojo._extends().name().equals(Object.class.getSimpleName())) {
            invocation = invocation.invoke("appendSuper").arg((JExpression)JExpr._super().invoke("toString"));
        }
        while (iterator.hasNext()) {
            Map.Entry<String, JFieldVar> pair = iterator.next();
            invocation = invocation.invoke("append").arg(JExpr.lit((String)pair.getKey())).arg((JExpression)pair.getValue());
        }
        return invocation;
    }

    private void withHashCode() {
        JMethod hashCode = this.pojo.method(1, Integer.TYPE, "hashCode");
        Class<org.apache.commons.lang3.builder.HashCodeBuilder> hashCodeBuilderClass = org.apache.commons.lang3.builder.HashCodeBuilder.class;
        if (!Config.getPojoConfig().isUseCommonsLang3()) {
            hashCodeBuilderClass = HashCodeBuilder.class;
        }
        JClass hashCodeBuilderRef = this.pojo.owner().ref(hashCodeBuilderClass);
        JInvocation hashCodeBuilderInvocation = this.appendFieldsToHashCode(this.getNonTransientAndNonStaticFields(), hashCodeBuilderRef);
        hashCode.body()._return((JExpression)hashCodeBuilderInvocation.invoke("toHashCode"));
    }

    private JInvocation appendFieldsToHashCode(Map<String, JFieldVar> nonTransientAndNonStaticFields, JClass hashCodeBuilderRef) {
        JInvocation invocation = JExpr._new((JClass)hashCodeBuilderRef);
        Iterator<Map.Entry<String, JFieldVar>> iterator = nonTransientAndNonStaticFields.entrySet().iterator();
        if (!this.pojo._extends().name().equals(Object.class.getSimpleName())) {
            invocation = invocation.invoke("appendSuper").arg((JExpression)JExpr._super().invoke("hashCode"));
        }
        while (iterator.hasNext()) {
            Map.Entry<String, JFieldVar> pair = iterator.next();
            invocation = invocation.invoke("append").arg((JExpression)pair.getValue());
        }
        return invocation;
    }

    private void withEquals() {
        JMethod equals = this.pojo.method(1, Boolean.TYPE, "equals");
        JVar otherObject = equals.param(Object.class, "other");
        Class<EqualsBuilder> equalsBuilderClass = EqualsBuilder.class;
        if (!Config.getPojoConfig().isUseCommonsLang3()) {
            equalsBuilderClass = org.apache.commons.lang.builder.EqualsBuilder.class;
        }
        JBlock body = equals.body();
        body._if(otherObject.eq(JExpr._null()))._then()._return(JExpr.FALSE);
        body._if(otherObject.eq(JExpr._this()))._then()._return(JExpr.TRUE);
        body._if(JExpr._this().invoke("getClass").ne((JExpression)otherObject.invoke("getClass")))._then()._return(JExpr.FALSE);
        JVar otherObjectVar = body.decl((JType)this.pojo, "otherObject").init((JExpression)JExpr.cast((JType)this.pojo, (JExpression)otherObject));
        JClass equalsBuilderRef = this.pojo.owner().ref(equalsBuilderClass);
        JInvocation equalsBuilderInvocation = this.appendFieldsToEquals(this.getNonTransientAndNonStaticFields(), otherObjectVar, equalsBuilderRef);
        body._return((JExpression)equalsBuilderInvocation.invoke("isEquals"));
    }

    private JInvocation appendFieldsToEquals(Map<String, JFieldVar> nonTransientAndNonStaticFields, JVar otherObject, JClass equalsBuilderRef) {
        JInvocation invocation = JExpr._new((JClass)equalsBuilderRef);
        Iterator<Map.Entry<String, JFieldVar>> iterator = nonTransientAndNonStaticFields.entrySet().iterator();
        if (!this.pojo._extends().name().equals(Object.class.getSimpleName())) {
            invocation = invocation.invoke("appendSuper").arg((JExpression)JExpr._super().invoke("equals").arg((JExpression)otherObject));
        }
        while (iterator.hasNext()) {
            Map.Entry<String, JFieldVar> pair = iterator.next();
            invocation = invocation.invoke("append").arg((JExpression)pair.getValue()).arg((JExpression)otherObject.ref(pair.getKey()));
        }
        return invocation;
    }
}

