/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlplugin.raml2code.interpreters;

import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JMethod;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.springframework.util.StringUtils;

public class RamlTypeValidations {
    Integer minLength;
    Integer maxLength;
    Double minimum;
    Double maximum;
    String pattern;
    Boolean required;

    public RamlTypeValidations(Boolean required) {
        this.required = required == null || required == true ? Boolean.valueOf(true) : Boolean.valueOf(false);
    }

    public RamlTypeValidations withLenghts(Integer minLength, Integer maxLength) {
        this.minLength = minLength;
        this.maxLength = maxLength;
        return this;
    }

    public RamlTypeValidations withPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void annotateFieldJSR303(JMethod getter, boolean addValidAnnotation) {
        JAnnotationUse annotation;
        if (this.isRequired()) {
            getter.annotate(NotNull.class);
        }
        if (StringUtils.hasText((String)this.getPattern())) {
            annotation = getter.annotate(Pattern.class);
            annotation.param("regexp", this.getPattern());
        }
        if (this.getMinLength() != null || this.getMaxLength() != null) {
            annotation = getter.annotate(Size.class);
            if (this.getMinLength() != null) {
                annotation.param("min", this.getMinLength().intValue());
            }
            if (this.getMaxLength() != null) {
                annotation.param("max", this.getMaxLength().intValue());
            }
        }
        if (addValidAnnotation) {
            getter.annotate(Valid.class);
        }
        if (this.minimum != null) {
            annotation = getter.annotate(DecimalMin.class);
            annotation.param("value", String.valueOf(this.minimum));
        }
        if (this.maximum != null) {
            annotation = getter.annotate(DecimalMax.class);
            annotation.param("value", String.valueOf(this.maximum));
        }
    }

    public RamlTypeValidations withMinMax(Double minimum, Double maximum) {
        this.minimum = minimum;
        this.maximum = maximum;
        return this;
    }
}

