/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlplugin.raml2code.interpreters;

import com.phoenixnap.oss.ramlplugin.raml2code.helpers.CodeModelHelper;
import com.phoenixnap.oss.ramlplugin.raml2code.interpreters.BaseTypeInterpreter;
import com.phoenixnap.oss.ramlplugin.raml2code.interpreters.EnumBuilder;
import com.phoenixnap.oss.ramlplugin.raml2code.interpreters.RamlInterpretationResult;
import com.phoenixnap.oss.ramlplugin.raml2code.interpreters.RamlTypeValidations;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlRoot;
import com.sun.codemodel.JCodeModel;
import java.util.Collections;
import java.util.Set;
import org.raml.v2.api.model.v10.datamodel.StringTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class StringTypeInterpreter
extends BaseTypeInterpreter {
    private static final String DEFAULT_ENUM_NAME = "DefaultEnum";

    @Override
    public Set<Class<? extends TypeDeclaration>> getSupportedTypes() {
        return Collections.singleton(StringTypeDeclaration.class);
    }

    @Override
    public RamlInterpretationResult interpret(RamlRoot document, TypeDeclaration type, JCodeModel builderModel, boolean property) {
        RamlInterpretationResult result = new RamlInterpretationResult(type.required());
        if (type instanceof StringTypeDeclaration) {
            StringTypeDeclaration stringType = (StringTypeDeclaration)type;
            RamlTypeValidations validations = result.getValidations();
            validations.withPattern(stringType.pattern());
            validations.withLenghts(stringType.minLength(), stringType.maxLength());
            if (stringType.enumValues() != null && !stringType.enumValues().isEmpty()) {
                String enumName = stringType.type();
                if ("string".equalsIgnoreCase(enumName)) {
                    enumName = stringType.name();
                }
                if ("string".equalsIgnoreCase(enumName) || enumName.contains("/")) {
                    enumName = DEFAULT_ENUM_NAME;
                }
                EnumBuilder builder = new EnumBuilder(builderModel, enumName);
                builder.withEnums(stringType.enumValues(), String.class);
                result.setBuilder(builder);
                result.setCodeModel(builderModel);
            }
        }
        if (result.getBuilder() == null) {
            result.setResolvedClass(CodeModelHelper.findFirstClassBySimpleName(builderModel, "java.lang.String"));
        }
        return result;
    }
}

