/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlplugin.raml2code.interpreters;

import com.phoenixnap.oss.ramlplugin.raml2code.helpers.RamlTypeHelper;
import com.phoenixnap.oss.ramlplugin.raml2code.interpreters.BaseTypeInterpreter;
import com.phoenixnap.oss.ramlplugin.raml2code.interpreters.PojoBuilder;
import com.phoenixnap.oss.ramlplugin.raml2code.interpreters.RamlInterpretationResult;
import com.phoenixnap.oss.ramlplugin.raml2code.interpreters.RamlInterpreterFactory;
import com.phoenixnap.oss.ramlplugin.raml2code.plugin.Config;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlDataType;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlRoot;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.UnionTypeDeclaration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MimeType;
import org.springframework.util.StringUtils;

public class UnionTypeInterpreter
extends BaseTypeInterpreter {
    protected static final Logger logger = LoggerFactory.getLogger(UnionTypeInterpreter.class);

    @Override
    public Set<Class<? extends TypeDeclaration>> getSupportedTypes() {
        return Collections.singleton(UnionTypeDeclaration.class);
    }

    private String getClassName(TypeDeclaration type) {
        UnionTypeDeclaration objectType = (UnionTypeDeclaration)type;
        String name = StringUtils.capitalize((String)objectType.name());
        try {
            MimeType.valueOf((String)name);
            name = objectType.type();
        }
        catch (Exception ex) {
            logger.debug("mime: " + name);
        }
        return name;
    }

    private TypeDeclaration getParent(UnionTypeDeclaration objectType, String typeName, RamlRoot document) {
        Map<String, RamlDataType> types = document.getTypes();
        TypeDeclaration parent = null;
        if (!RamlTypeHelper.isBaseObject(typeName)) {
            parent = types.get(typeName).getType();
        } else if (objectType.parentTypes() != null && objectType.parentTypes().size() > 0) {
            TypeDeclaration tempParent = (TypeDeclaration)objectType.parentTypes().get(0);
            if (!RamlTypeHelper.isBaseObject(tempParent.name())) {
                parent = types.get(tempParent.name()).getType();
            }
        } else {
            parent = null;
        }
        return parent;
    }

    @Override
    public RamlInterpretationResult interpret(RamlRoot document, TypeDeclaration type, JCodeModel builderModel, boolean property) {
        RamlInterpretationResult result = new RamlInterpretationResult(type.required());
        this.typeCheck(type);
        String name = this.getClassName(type);
        UnionTypeDeclaration objectType = (UnionTypeDeclaration)type;
        String typeName = objectType.type();
        if (builderModel != null) {
            JDefinedClass searchedClass = builderModel._getClass(Config.getPojoPackage() + "." + name);
            if (searchedClass != null) {
                result.setCodeModel(builderModel);
                result.setResolvedClass((JClass)searchedClass);
                return result;
            }
        } else {
            builderModel = new JCodeModel();
            result.setCodeModel(builderModel);
        }
        PojoBuilder builder = new PojoBuilder(builderModel, name);
        result.setBuilder(builder);
        TypeDeclaration parent = this.getParent(objectType, typeName, document);
        if (parent != null && !parent.name().equals(name)) {
            RamlInterpretationResult childResult = RamlInterpreterFactory.getInterpreterForType(parent).interpret(document, parent, builderModel, false);
            String childType = childResult.getResolvedClassOrBuiltOrObject().name();
            builder.extendsClass(childType);
        }
        for (TypeDeclaration objectProperty : objectType.of()) {
            RamlInterpretationResult childResult = RamlInterpreterFactory.getInterpreterForType(objectProperty).interpret(document, objectProperty, builderModel, true);
            String childType = childResult.getResolvedClassOrBuiltOrObject().fullName();
            builder.withField(objectProperty.name(), childType, RamlTypeHelper.getDescription(objectProperty), childResult.getValidations(), objectProperty);
        }
        builder.withCompleteConstructor();
        builder.withOverridenMethods(Collections.emptyList());
        return result;
    }
}

