/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlplugin.raml2code.plugin;

import com.phoenixnap.oss.ramlplugin.raml2code.data.ApiBodyMetadata;
import com.phoenixnap.oss.ramlplugin.raml2code.data.ApiResourceMetadata;
import com.phoenixnap.oss.ramlplugin.raml2code.exception.InvalidRamlResourceException;
import com.phoenixnap.oss.ramlplugin.raml2code.helpers.NamingHelper;
import com.phoenixnap.oss.ramlplugin.raml2code.helpers.RamlParser;
import com.phoenixnap.oss.ramlplugin.raml2code.helpers.RamlTypeHelper;
import com.phoenixnap.oss.ramlplugin.raml2code.helpers.SchemaHelper;
import com.phoenixnap.oss.ramlplugin.raml2code.plugin.Config;
import com.phoenixnap.oss.ramlplugin.raml2code.plugin.PojoGenerationConfig;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlDataType;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlRoot;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.raml10.RJP10V2RamlRoot;
import com.phoenixnap.oss.ramlplugin.raml2code.rules.ConfigurableRule;
import com.phoenixnap.oss.ramlplugin.raml2code.rules.RamlLoader;
import com.phoenixnap.oss.ramlplugin.raml2code.rules.Rule;
import com.phoenixnap.oss.ramlplugin.raml2code.rules.Spring4ControllerStubRule;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.jsonschema2pojo.Annotator;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.Jackson1Annotator;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Mojo(name="generate-springmvc-endpoints", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true, requiresProject=false)
public class SpringMvcEndpointGeneratorMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${plugin}", readonly=true)
    private PluginDescriptor descriptor;
    @Parameter(property="ramlPath", required=true, readonly=true, defaultValue="")
    protected String ramlPath;
    @Parameter(property="pomPath", required=false, readonly=true, defaultValue="NA")
    protected String pomPath;
    @Parameter(property="outputRelativePath", required=false, readonly=true, defaultValue="")
    protected String outputRelativePath;
    @Parameter(required=false, readonly=true, defaultValue="false")
    protected Boolean addTimestampFolder;
    @Parameter(property="basePackage", required=true, readonly=true, defaultValue="")
    protected String basePackage;
    @Parameter(required=false, readonly=true, defaultValue="")
    protected String schemaLocation;
    @Parameter(required=false, readonly=true, defaultValue="false")
    protected Boolean generateUnreferencedObjects;
    @Parameter(required=false, readonly=true)
    protected String baseUri;
    @Parameter(required=false, readonly=true, defaultValue="false")
    protected Boolean seperateMethodsByContentType;
    @Parameter(required=false, readonly=true, defaultValue="false")
    protected Boolean useJackson1xCompatibility;
    @Parameter(required=false, readonly=true, defaultValue="com.phoenixnap.oss.ramlplugin.raml2code.rules.Spring4ControllerStubRule")
    protected String rule;
    @Parameter(required=false, readonly=true)
    protected Map<String, String> ruleConfiguration = new LinkedHashMap<String, String>();
    @Parameter(required=false, readonly=true)
    protected PojoGenerationConfig generationConfig = new PojoGenerationConfig();
    @Parameter(required=false, readonly=true, defaultValue="false")
    protected Boolean injectHttpHeadersParameter;
    @Parameter(required=false, readonly=true, defaultValue="1")
    protected Integer resourceDepthInClassNames;
    @Parameter(required=false, readonly=true, defaultValue="0")
    protected Integer resourceTopLevelInClassNames;
    @Parameter(required=false, readonly=true, defaultValue="false")
    protected Boolean reverseOrderInClassNames;
    @Parameter(required=false, readonly=true, defaultValue="OBJECTS")
    protected MethodsNamingLogic methodsNamingLogic;
    @Parameter(required=false, readonly=true)
    protected OverrideNamingLogicWith overrideNamingLogicWith;
    @Parameter(required=false, readonly=true)
    protected String dontGenerateForAnnotation;
    @Parameter(required=false, readonly=true, defaultValue="false")
    protected Boolean injectHttpRequestParameter;
    private ClassRealm classRealm;
    private String resolvedSchemaLocation;

    protected void generateEndpoints() throws IOException {
        String resolvedPath;
        File pomFile = null;
        if (!this.pomPath.equals("NA")) {
            Model model = null;
            FileReader reader = null;
            MavenXpp3Reader mavenreader = new MavenXpp3Reader();
            pomFile = new File(this.pomPath);
            try {
                reader = new FileReader(pomFile);
                model = mavenreader.read((Reader)reader);
                model.setPomFile(pomFile);
            }
            catch (Exception ex) {
                this.getLog().info((CharSequence)"Exception Occured", (Throwable)ex);
            }
            this.project = new MavenProject(model);
            this.project.setFile(pomFile);
        }
        if ((resolvedPath = this.project.getBasedir().getAbsolutePath()).endsWith(File.separator) || resolvedPath.endsWith("/")) {
            resolvedPath = resolvedPath.substring(0, resolvedPath.length() - 1);
        }
        String resolvedRamlPath = this.project.getBasedir().getAbsolutePath();
        resolvedRamlPath = !this.ramlPath.startsWith(File.separator) && !this.ramlPath.startsWith("/") ? resolvedRamlPath + File.separator + this.ramlPath : resolvedRamlPath + this.ramlPath;
        this.resolvedSchemaLocation = this.getSchemaLocation();
        RamlRoot loadRamlFromFile = RamlLoader.loadRamlFromFile(new File(resolvedRamlPath).toURI().toString());
        JCodeModel codeModel = null;
        boolean unifiedModel = false;
        if (loadRamlFromFile instanceof RJP10V2RamlRoot) {
            codeModel = new JCodeModel();
            unifiedModel = true;
        }
        Config.setMojo(this);
        RamlParser par = new RamlParser(this.getBasePath(loadRamlFromFile));
        Set<ApiResourceMetadata> controllers = par.extractControllers(codeModel, loadRamlFromFile);
        if (StringUtils.hasText((String)this.outputRelativePath)) {
            if (!this.outputRelativePath.startsWith(File.separator) && !this.outputRelativePath.startsWith("/")) {
                resolvedPath = resolvedPath + File.separator;
            }
            resolvedPath = resolvedPath + this.outputRelativePath;
        } else {
            resolvedPath = resolvedPath + "/target/generated-sources/spring-mvc";
        }
        File rootDir = new File(resolvedPath + (this.addTimestampFolder == true ? Long.valueOf(System.currentTimeMillis()) : "") + "/");
        if (!rootDir.exists() && !rootDir.mkdirs()) {
            throw new IOException("Could not create directory:" + rootDir.getAbsolutePath());
        }
        this.generateCode(null, controllers, rootDir);
        if (this.generateUnreferencedObjects.booleanValue()) {
            this.generateUnreferencedObjects(codeModel, loadRamlFromFile, resolvedRamlPath, rootDir, controllers);
        }
        if (unifiedModel) {
            this.buildCodeModelToDisk(codeModel, "Unified", rootDir);
        }
    }

    private Set<String> getAllReferencedTypeNames(Set<ApiResourceMetadata> controllers) {
        Set parametersNames = controllers.stream().flatMap(resourceMetadata -> resourceMetadata.getParameters().stream()).map(apiParameter -> StringUtils.capitalize((String)apiParameter.getName())).collect(Collectors.toSet());
        Set<String> bodyNames = controllers.stream().flatMap(resourceMetadata -> resourceMetadata.getDependencies().stream()).map(ApiBodyMetadata::getName).collect(Collectors.toSet());
        bodyNames.addAll(parametersNames);
        return bodyNames;
    }

    private void generateUnreferencedObjects(JCodeModel codeModel, RamlRoot loadRamlFromFile, String resolvedRamlPath, File rootDir, Set<ApiResourceMetadata> controllers) {
        if (loadRamlFromFile.getTypes() != null && !loadRamlFromFile.getTypes().isEmpty()) {
            this.getLog().debug((CharSequence)"Generating Code for Unreferenced Types");
            Set<String> allReferencedTypes = this.getAllReferencedTypeNames(controllers);
            for (Map.Entry<String, RamlDataType> type : loadRamlFromFile.getTypes().entrySet()) {
                if (allReferencedTypes.contains(type.getKey())) continue;
                ApiBodyMetadata tempBodyMetadata = RamlTypeHelper.mapTypeToPojo(codeModel, loadRamlFromFile, type.getValue().getType());
                this.generateModelSources(codeModel, tempBodyMetadata, rootDir);
            }
        }
        if (loadRamlFromFile.getSchemas() != null && !loadRamlFromFile.getSchemas().isEmpty()) {
            this.getLog().debug((CharSequence)"Generating Code for Unreferenced Schemas");
            for (Map<String, String> map : loadRamlFromFile.getSchemas()) {
                for (String schemaName : map.keySet()) {
                    this.getLog().info((CharSequence)("Generating POJO for unreferenced schema " + schemaName));
                    ApiBodyMetadata tempBodyMetadata = SchemaHelper.mapSchemaToPojo(loadRamlFromFile, schemaName, resolvedRamlPath, schemaName, this.resolvedSchemaLocation);
                    this.generateModelSources(null, tempBodyMetadata, rootDir);
                }
            }
        }
    }

    private void generateCode(JCodeModel codeModel, Set<ApiResourceMetadata> controllers, File rootDir) {
        for (ApiResourceMetadata met : controllers) {
            this.getLog().debug((CharSequence)"");
            this.getLog().debug((CharSequence)"-----------------------------------------------------------");
            this.getLog().info((CharSequence)("Generating Code for Resource: " + met.getName()));
            this.getLog().debug((CharSequence)"");
            if (codeModel == null) {
                Set<ApiBodyMetadata> dependencies = met.getDependencies();
                for (ApiBodyMetadata body : dependencies) {
                    this.generateModelSources(codeModel, body, rootDir);
                }
            }
            this.generateControllerSource(codeModel, met, rootDir);
        }
    }

    private String getBasePath(RamlRoot loadRamlFromFile) {
        String basePath = loadRamlFromFile.getBaseUri();
        if (this.baseUri != null) {
            basePath = this.baseUri;
        }
        if (basePath != null && basePath.equals("/")) {
            basePath = "";
        }
        return basePath;
    }

    private Rule<JCodeModel, JDefinedClass, ApiResourceMetadata> loadRule() {
        Rule<JCodeModel, JDefinedClass, ApiResourceMetadata> ruleInstance = new Spring4ControllerStubRule();
        try {
            ruleInstance = (Rule)this.getClassRealm().loadClass(this.rule).newInstance();
            this.getLog().debug((CharSequence)StringUtils.collectionToCommaDelimitedString(this.ruleConfiguration.keySet()));
            this.getLog().debug((CharSequence)StringUtils.collectionToCommaDelimitedString(this.ruleConfiguration.values()));
            if (ruleInstance instanceof ConfigurableRule && !CollectionUtils.isEmpty(this.ruleConfiguration)) {
                this.getLog().debug((CharSequence)"SETTING CONFIG");
                ((ConfigurableRule)ruleInstance).applyConfiguration(this.ruleConfiguration);
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Could not instantiate Rule " + this.rule + ". The default Rule will be used for code generation."), (Throwable)e);
        }
        return ruleInstance;
    }

    private ClassRealm getClassRealm() throws DependencyResolutionRequiredException, MalformedURLException {
        if (this.classRealm == null) {
            List runtimeClasspathElements = this.project.getRuntimeClasspathElements();
            this.classRealm = this.descriptor.getClassRealm();
            if (this.classRealm == null) {
                this.classRealm = this.project.getClassRealm();
            }
            for (String element : runtimeClasspathElements) {
                File elementFile = new File(element);
                this.classRealm.addURL(elementFile.toURI().toURL());
            }
        }
        return this.classRealm;
    }

    private void generateModelSources(JCodeModel codeModel, ApiBodyMetadata body, File rootDir) {
        boolean build = false;
        if (codeModel == null) {
            Jackson1Annotator annotator = this.useJackson1xCompatibility != false ? new Jackson1Annotator((GenerationConfig)this.generationConfig) : null;
            this.getLog().info((CharSequence)("Generating Model object for: " + body.getName()));
            build = true;
            codeModel = this.generationConfig == null && annotator == null ? body.getCodeModel() : body.getCodeModel(this.resolvedSchemaLocation, this.basePackage + NamingHelper.getDefaultModelPackage(), (Annotator)annotator);
        }
        if (build && codeModel != null) {
            this.buildCodeModelToDisk(codeModel, body.getName(), rootDir);
        }
    }

    private String getSchemaLocation() {
        if (StringUtils.hasText((String)this.schemaLocation)) {
            if (!this.schemaLocation.contains(":")) {
                String resolvedPath = this.project.getBasedir().getAbsolutePath();
                if (resolvedPath.endsWith(File.separator) || resolvedPath.endsWith("/")) {
                    resolvedPath = resolvedPath.substring(0, resolvedPath.length() - 1);
                }
                if (!this.schemaLocation.startsWith(File.separator) && !this.schemaLocation.startsWith("/")) {
                    resolvedPath = resolvedPath + File.separator;
                }
                resolvedPath = resolvedPath + this.schemaLocation;
                if (!this.schemaLocation.endsWith(File.separator) && !this.schemaLocation.endsWith("/")) {
                    resolvedPath = resolvedPath + File.separator;
                }
                resolvedPath = resolvedPath.replace(File.separator, "/").replace("\\", "/");
                try {
                    URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
                    Class<URLClassLoader> urlClass = URLClassLoader.class;
                    Method method = urlClass.getDeclaredMethod("addURL", URL.class);
                    method.setAccessible(true);
                    method.invoke((Object)urlClassLoader, new File(resolvedPath).toURI().toURL());
                    return "classpath:/";
                }
                catch (Exception ex) {
                    this.getLog().error((CharSequence)"Could not add schema location to classpath", (Throwable)ex);
                    return new File(resolvedPath).toURI().toString();
                }
            }
            return this.schemaLocation;
        }
        return null;
    }

    private void generateControllerSource(JCodeModel codeModel, ApiResourceMetadata met, File dir) {
        boolean build = false;
        if (codeModel == null) {
            codeModel = new JCodeModel();
            build = true;
        }
        this.loadRule().apply(met, codeModel);
        if (build) {
            this.buildCodeModelToDisk(codeModel, met.getName(), dir);
        }
    }

    private void buildCodeModelToDisk(JCodeModel codeModel, String name, File dir) {
        try {
            codeModel.build(dir);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.getLog().error((CharSequence)("Could not build code model for " + name), (Throwable)e);
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        long startTime = System.currentTimeMillis();
        try {
            this.generateEndpoints();
        }
        catch (IOException e) {
            throw new MojoExecutionException((Object)e, "Unexpected exception while executing Spring MVC Endpoint Generation Plugin.", e.toString());
        }
        catch (InvalidRamlResourceException e) {
            throw new MojoExecutionException((Object)e, "Supplied RAML has failed validation and cannot be loaded.", e.toString());
        }
        this.getLog().info((CharSequence)("Endpoint Generation Completed in:" + (System.currentTimeMillis() - startTime) + "ms"));
    }

    public static enum OverrideNamingLogicWith {
        DISPLAY_NAME,
        ANNOTATION;

    }

    public static enum MethodsNamingLogic {
        OBJECTS,
        RESOURCES;

    }
}

