/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlplugin.raml2code.raml.raml10;

import com.phoenixnap.oss.ramlplugin.raml2code.helpers.NamingHelper;
import com.phoenixnap.oss.ramlplugin.raml2code.helpers.RamlTypeHelper;
import com.phoenixnap.oss.ramlplugin.raml2code.plugin.Config;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlAction;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlActionType;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlResource;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlSecurityReference;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlUriParameter;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.raml10.RJP10V2RamlAction;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.raml10.RJP10V2RamlModelFactory;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.raml10.RJP10V2RamlUriParameter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.declarations.AnnotationRef;
import org.raml.v2.api.model.v10.methods.Method;
import org.raml.v2.api.model.v10.resources.Resource;
import org.springframework.util.StringUtils;

public class RJP10V2RamlResource
implements RamlResource {
    private static RJP10V2RamlModelFactory ramlModelFactory = new RJP10V2RamlModelFactory();
    private final Resource delegate;
    private transient Map<String, RamlResource> childResourceMap;

    public RJP10V2RamlResource(Resource resource) {
        this.delegate = resource;
        this.rebuildChildren();
    }

    private void rebuildChildren() {
        this.childResourceMap = new LinkedHashMap<String, RamlResource>();
        List resources = this.delegate.resources();
        if (resources != null) {
            for (Resource resource : resources) {
                boolean skipResource = false;
                if (StringUtils.hasText((String)Config.getDontGenerateForAnnotation())) {
                    for (AnnotationRef annotation : resource.annotations()) {
                        if (!("(" + Config.getDontGenerateForAnnotation() + ")").equals(annotation.name())) continue;
                        skipResource = true;
                    }
                }
                if (skipResource) continue;
                this.childResourceMap.put(resource.relativeUri().value(), new RJP10V2RamlResource(resource));
            }
        }
    }

    @Override
    public Map<String, RamlResource> getResources() {
        return this.childResourceMap;
    }

    @Override
    public RamlResource getResource(String path) {
        return this.childResourceMap.get(path);
    }

    @Override
    public String getRelativeUri() {
        return this.delegate.relativeUri() == null ? null : this.delegate.relativeUri().value();
    }

    @Override
    public Map<RamlActionType, RamlAction> getActions() {
        HashMap<RamlActionType, RamlAction> actions = new HashMap<RamlActionType, RamlAction>();
        for (Method method : this.delegate.methods()) {
            boolean skipMethod = false;
            if (StringUtils.hasText((String)Config.getDontGenerateForAnnotation())) {
                for (AnnotationRef annotation : method.annotations()) {
                    if (!("(" + Config.getDontGenerateForAnnotation() + ")").equals(annotation.name())) continue;
                    skipMethod = true;
                }
            }
            if (skipMethod) continue;
            actions.put(RamlActionType.valueOf(method.method().toUpperCase()), new RJP10V2RamlAction(method));
        }
        return actions;
    }

    @Override
    public Map<String, RamlUriParameter> getUriParameters() {
        LinkedHashMap<String, RamlUriParameter> uriParameters = new LinkedHashMap<String, RamlUriParameter>();
        for (TypeDeclaration type : this.delegate.uriParameters()) {
            RJP10V2RamlUriParameter rjp10v2RamlUriParameter = new RJP10V2RamlUriParameter(type);
            uriParameters.put(type.name(), rjp10v2RamlUriParameter);
        }
        List<String> missingUriParams = NamingHelper.extractUriParams(this.getRelativeUri());
        for (String missingParam : missingUriParams) {
            boolean contains = false;
            for (RamlUriParameter ramlUriParameter : uriParameters.values()) {
                if (!ramlUriParameter.getName().equals(missingParam)) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            uriParameters.put(missingParam, new RJP10V2RamlUriParameter((TypeDeclaration)RamlTypeHelper.createDefaultStringDeclaration(missingParam)));
        }
        return uriParameters;
    }

    @Override
    public void addUriParameter(String name, RamlUriParameter uriParameter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, RamlUriParameter> getResolvedUriParameters() {
        Map<String, RamlUriParameter> resolvedUriParameters = new HashMap<String, RamlUriParameter>();
        for (RamlResource resource = this; resource != null; resource = resource.getParentResource()) {
            resolvedUriParameters = Stream.concat(resolvedUriParameters.entrySet().stream(), resource.getUriParameters().entrySet().stream()).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (RamlUriParameter)entry.getValue()));
        }
        return resolvedUriParameters;
    }

    @Override
    public String getUri() {
        String outUri = this.delegate.relativeUri().value();
        for (Resource parentResource = this.delegate.parentResource(); parentResource != null; parentResource = parentResource.parentResource()) {
            if (parentResource.relativeUri() == null) continue;
            outUri = parentResource.relativeUri().value() + outUri;
        }
        return outUri;
    }

    @Override
    public String getDescription() {
        return this.delegate.description() == null ? null : this.delegate.description().value();
    }

    @Override
    public String getDisplayName() {
        if (this.delegate.displayName() == null) {
            return null;
        }
        String value = this.delegate.displayName().value();
        if (this.getRelativeUri().equals(value)) {
            return null;
        }
        return value;
    }

    @Override
    public RamlResource getParentResource() {
        return this.delegate.parentResource() == null ? null : new RJP10V2RamlResource(this.delegate.parentResource());
    }

    @Override
    public String getParentUri() {
        RamlResource parentResource = this.getParentResource();
        if (parentResource == null) {
            return "";
        }
        return parentResource.getUri();
    }

    @Override
    public RamlAction getAction(RamlActionType actionType) {
        List methods = this.delegate.methods();
        for (Method method : methods) {
            if (!method.method().equalsIgnoreCase(actionType.toString())) continue;
            return ramlModelFactory.createRamlAction(method);
        }
        return null;
    }

    Resource getResource() {
        return this.delegate;
    }

    @Override
    public List<RamlSecurityReference> getSecuredBy() {
        return ramlModelFactory.createRamlSecurityReferences(this.delegate.securedBy());
    }
}

