/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlplugin.raml2code.rules;

import com.phoenixnap.oss.ramlplugin.raml2code.exception.InvalidRamlException;
import com.phoenixnap.oss.ramlplugin.raml2code.exception.UnsupportedRamlVersionException;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlModelFactory;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlRoot;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.RamlVersion;
import com.phoenixnap.oss.ramlplugin.raml2code.raml.raml10.RJP10V2RamlModelFactory;
import java.util.Collection;
import org.raml.v2.api.RamlModelBuilder;
import org.raml.v2.api.RamlModelResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class RamlLoader {
    protected static final Logger logger = LoggerFactory.getLogger(RamlLoader.class);

    public static RamlRoot loadRamlFromFile(String ramlFileUrl) {
        try {
            return RamlLoader.createRamlModelFactoryFor(ramlFileUrl).buildRamlRoot(ramlFileUrl);
        }
        catch (NullPointerException npe) {
            logger.error("File not found at {}", (Object)ramlFileUrl);
            return null;
        }
    }

    private static RamlModelFactory createRamlModelFactoryFor(String ramlURL) {
        RamlModelResult ramlModelResult = new RamlModelBuilder().buildApi(ramlURL);
        if (ramlModelResult.hasErrors()) {
            if (logger.isErrorEnabled()) {
                logger.error("Loaded RAML has validation errors: {}", (Object)StringUtils.collectionToCommaDelimitedString((Collection)ramlModelResult.getValidationResults()));
            }
            throw new InvalidRamlException(ramlURL, ramlModelResult.getValidationResults());
        }
        if (!ramlModelResult.isVersion10()) {
            logger.error("Unsupported version detected!");
            throw new UnsupportedRamlVersionException(RamlVersion.V10);
        }
        logger.info("RJP10V2RamlModelFactory Instantiated");
        return new RJP10V2RamlModelFactory();
    }
}

